/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package opticalraytracer;

import java.util.*;

/**
 *
 * @author lutusp
 */
public class UndoRedoPackage {

    String stringVec;
    int isel = -1;

    public UndoRedoPackage(Vector<Lens> lv, Lens sl) {
        stringVec = lv.toString();
        isel = lv.indexOf(sl);
    }

    public void restore(OpticalRayTracer p) {
        p.sv_lensList = new Vector<Lens>();
        String s = stringVec.replaceFirst("\\[(.*)\\]", "$1");
        String[] array = s.split(",");
        for (int i = 0; i < array.length; i++) {
            p.sv_lensList.add(new Lens(p, p.rayTraceComputer, array[i]));
        }
        if (isel >= 0) {
            p.setSelectedLens(p.sv_lensList.get(isel));
        }
        else {
            p.setSelectedLens(null);
        }
        p.mouseTarget = null;
    }
}
