###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for ruby1.8 vulnerabilities USN-651-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840344);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "651-1");
  script_cve_id("CVE-2008-2376", "CVE-2008-3443", "CVE-2008-3655", "CVE-2008-3656", "CVE-2008-3657", "CVE-2008-3790", "CVE-2008-3905", "CVE-2008-1447");
  script_name( "Ubuntu Update for ruby1.8 vulnerabilities USN-651-1");
  desc = "

  Vulnerability Insight:

  Akira Tagoh discovered a vulnerability in Ruby which lead to an integer
  overflow. If a user or automated system were tricked into running a
  malicious script, an attacker could cause a denial of service or
  possibly execute arbitrary code with the privileges of the user
  invoking the program. (CVE-2008-2376)
  
  Laurent Gaffie discovered that Ruby did not properly check for memory
  allocation failures. If a user or automated system were tricked into
  running a malicious script, an attacker could cause a denial of
  service. (CVE-2008-3443)
  
  Keita Yamaguchi discovered several safe level vulnerabilities in Ruby.
  An attacker could use this to bypass intended access restrictions.
  (CVE-2008-3655)
  
  Keita Yamaguchi discovered that WEBrick in Ruby did not properly
  validate paths ending with &quot;.&quot;. A remote attacker could send a crafted
  HTTP request and cause a denial of service. (CVE-2008-3656)
  
  Keita Yamaguchi discovered that the dl module in Ruby did not check
  the taintness of inputs. An attacker could exploit this vulnerability
  to bypass safe levels and execute dangerous functions. (CVE-2008-3657)
  
  Luka Treiber and Mitja Kolsek discovered that REXML in Ruby did not
  always use expansion limits when processing XML documents. If a user or
  automated system were tricked into open a crafted XML file, an attacker
  could cause a denial of service via CPU consumption. (CVE-2008-3790)
  
  Jan Lieskovsky discovered several flaws in the name resolver of Ruby. A
  remote attacker could exploit this to spoof DNS entries, which could
  lead to misdirected traffic. This is a different vulnerability from
  CVE-2008-1447. (CVE-2008-3790)

  Affected Software/OS:
  ruby1.8 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-October/000759.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ruby1.8 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libruby1.8-dbg", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libruby1.8", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8-dev", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbm-ruby1.8", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgdbm-ruby1.8", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libopenssl-ruby1.8", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libreadline-ruby1.8", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libtcltk-ruby1.8", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"irb1.8", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"rdoc1.8", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ri1.8", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8-elisp", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8-examples", ver:"1.8.4-1ubuntu1.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libruby1.8-dbg", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libruby1.8", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8-dev", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbm-ruby1.8", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgdbm-ruby1.8", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libopenssl-ruby1.8", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libreadline-ruby1.8", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libtcltk-ruby1.8", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"irb1.8", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"rdoc1.8", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ri1.8", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8-elisp", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8-examples", ver:"1.8.5-4ubuntu2.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libruby1.8-dbg", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libruby1.8", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8-dev", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbm-ruby1.8", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgdbm-ruby1.8", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libopenssl-ruby1.8", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libreadline-ruby1.8", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libtcltk-ruby1.8", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"irb1.8", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"rdoc1.8", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ri1.8", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8-elisp", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8-examples", ver:"1.8.6.111-2ubuntu1.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libruby1.8-dbg", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libruby1.8", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8-dev", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbm-ruby1.8", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgdbm-ruby1.8", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libopenssl-ruby1.8", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libreadline-ruby1.8", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libtcltk-ruby1.8", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"irb1.8", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"rdoc1.8", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ri1.8", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8-elisp", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.8-examples", ver:"1.8.6.36-1ubuntu3.3", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}