###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_safari_xml_dos_vuln_win_apr09.nasl 1419 2009-04-03 10:40:26Z apr $
#
# Apple Safari Denial of Service Vulnerability (Win) - Apr09
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800549);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.1");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-1233");
  script_bugtraq_id(34318);
  script_name("Apple Safari Denial of Service Vulnerability (Win) - Apr09");
  desc = "

  Overview: This host is running Apple Safari Web Browser and is prone
  to denial of service vulnerability.

  Vulnerability Insight:
  Improper parsing of XML documents while persuading a victim to open a
  specially-crafted XML document containing an overly large number of nested
  elements crashes the Browser.

  Impact:
  Attacker could exploit this vulnerability to cause the browser to crash.

  Impact Level: Application

  Affected Software/OS:
  Apple Safari version 4 beta and prior on Windows.

  Fix: No solution or patch is available as on 06th April, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.apple.com/support/downloads

  References:
  http://www.milw0rm.com/exploits/8325
  http://xforce.iss.net/xforce/xfdb/49527

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 6.4
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Apple Safari");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}


include("version_func.inc");

safariVer = get_kb_item("AppleSafari/Version");
if(!safariVer){
  exit(0);
}

# Apple Safari Version <= (4.28.16.0) 4 build 528.16
if(version_is_less_equal(version:safariVer, test_version:"4.28.16.0")){
  security_hole(0);
}
