#
#VID b1e8c810-01d0-11da-bc08-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54461);
 script_cve_id("CVE-2005-0926");
 script_bugtraq_id(12934);
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.1");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: sylpheed, sylpheed-gtk2, sylpheed-claws";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   sylpheed
   sylpheed-gtk2
   sylpheed-claws

CVE-2005-0926
Buffer overflow in Sylpheed before 1.0.4 allows remote attackers to
cause a denial of service (crash) and possibly execute arbitrary code
via attachments with MIME-encoded file names.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://sylpheed.good-day.net/changelog.html.en
http://www.vuxml.org/freebsd/b1e8c810-01d0-11da-bc08-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: sylpheed, sylpheed-gtk2, sylpheed-claws";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"sylpheed");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.4")<0) {
    security_note(0, data:"Package sylpheed version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"sylpheed-gtk2");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.4")<0) {
    security_note(0, data:"Package sylpheed-gtk2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"sylpheed-claws");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.4")<0) {
    security_note(0, data:"Package sylpheed-claws version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
