# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 349-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53638);
 script_bugtraq_id(8179);
 script_cve_id("CVE-2003-0252");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 349-1 (nfs-utils)";
 script_name(name);

 desc = "The remote host is missing an update to nfs-utils
announced via advisory DSA 349-1.

The logging code in nfs-utils contains an off-by-one buffer overrun
when adding a newline to the string being logged.  This vulnerability
may allow an attacker to execute arbitrary code or cause a denial of
service condition by sending certain RPC requests.

For the stable distribution (woody) this problem has been fixed in
version 1:1.0-2woody1.

For the unstable distribution (sid) this problem has been fixed in
version 1:1.0.3-2.

We recommend that you update your nfs-utils package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20349-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 349-1 (nfs-utils)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"nfs-common", ver:"1.0-2woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nfs-kernel-server", ver:"1.0-2woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nhfsstone", ver:"1.0-2woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
