/*
 * Copyright (c) 2009, 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

import java.lang.annotation.*;
import java.io.*;
import java.net.URL;
import java.util.List;
import java.lang.classfile.*;
import java.lang.classfile.attribute.*;

/*
 * @test
 * @bug 6843077 8006775
 * @summary Qualified inner type annotation accessible to the class.
 * @enablePreview
 * @modules java.base/jdk.internal.classfile.impl
 */

@Scopes.UniqueInner
public class Scopes<T extends @Scopes.UniqueInner Object> extends ClassfileTestHelper{
    public static void main(String[] args) throws Exception {
        new Scopes().run();
    }

    public void run() throws Exception {
        expected_tinvisibles = 1;
        expected_invisibles = 1;

        ClassModel cm = getClassFile("Scopes.class");
        test(cm);

        countAnnotations();

        if (errors > 0)
            throw new Exception(errors + " errors found");
        System.out.println("PASSED");
    }

    @Target({ElementType.TYPE_USE})
    @interface UniqueInner { };
}
