import "TestFramework";

int main()
{
  int errorcount = 0;
  // Data
  float x[3] = { 1, 2 ,3 };
  float y[3] = { 4, 5, 6 };
  float A[3][3] = { { 1, 2, 3 }, { 4, 5, 6 }, { 7, 8, 9 } };
  float B[3][3] = { { 10, 11, 12 }, { 13, 14, 15 }, { 16, 17, 18 } };
  float C[4][4] = { { 1, 2, 3, 4 }, { 5, 6, 7, 8 }, { 9, 10, 11, 12 }, { 13, 14, 15, 16 } };
  float D[4][4] = { { 17, 18, 19, 20 }, { 21, 22, 23, 24}, { 25, 26, 27, 28 }, { 29, 30, 31, 32} };
  
  float E[3][3] = { { 2, 2, 2 }, { 2, 0, 2 }, { 0, 1, 2 } };
  float F[4][4] = { { 2, 2, 2, 2 }, { 2, 0, 2, 0 }, { 0, 1, 2,0 }, {1, 0, 0, 2} };
  
  // Test vectors
  Test::checkNearEqualVec( mult_f_f3( 1.5, x ), { 1.5, 3.0, 4.5 }, errorcount );
  Test::checkNearEqualVec( add_f3_f3( x, y ), { 5.0, 7.0, 9.0 }, errorcount );
  Test::checkNearEqualVec( sub_f3_f3( x, y ), { -3.0, -3.0, -3.0 }, errorcount );
  Test::checkNearEqualVec( cross_f3_f3( x, y ), { -3.0, 6.0, -3.0 }, errorcount );
  Test::checkNearEqual( dot_f3_f3( x, y ), 32, errorcount );
  Test::checkNearEqual( length_f3( x ), 3.74166, errorcount );
  Test::checkNearEqual( length_f3( y ), 8.77496, errorcount );
  
  // Test matrixes
  Test::checkNearEqualMat( mult_f_f33( 1.5, A), { { 1.5, 3.0, 4.5 }, { 6, 7.5, 9 }, { 10.5, 12, 13.5 } }, errorcount);
  Test::checkNearEqualMat( mult_f_f44( 2.0, C), { { 2.0, 4.0, 6.0, 8.0 }, { 10.0, 12.0, 14.0, 16.0 }, { 18.0, 20.0, 22.0, 24.0 }, { 26.0, 28.0, 30.0, 32.0 } }, errorcount);
  Test::checkNearEqualMat( add_f33_f33( A, B), { { 11.0, 13.0, 15.0 }, { 17.0, 19.0, 21.0 }, { 23.0, 25.0, 27.0 } }, errorcount);
  Test::checkNearEqualMat( add_f44_f44( C, D), { { 18.0, 20.0, 22.0, 24.0 }, { 26.0, 28.0, 30.0, 32.0 }, { 34.0, 36.0, 38.0, 40.0 }, { 42.0, 44.0, 46.0, 48.0 } }, errorcount);
  
  Test::checkNearEqualMat( mult_f33_f33(A,B), { { 84.0, 90.0, 96.0 }, { 201.0, 216.0, 231.0 }, { 318.0, 342.0, 366.0} }, errorcount );
  Test::checkNearEqualMat( mult_f44_f44(C,D), { { 250.0, 260.0, 270.0, 280.0 }, { 618.0, 644.0, 670.0, 696.0 }, { 986.0, 1028.0, 1070.0, 1112.0 }, { 1354.0, 1412.0, 1470.0, 1528.0 } }, errorcount );

  Test::checkNearEqualMat( invert_f33(E), { { 0.25, 0.25, -0.5 }, { 0.5, -0.5, 0.0 }, {-0.25, 0.25, 0.5 } }, errorcount );
  Test::checkNearEqualMat( invert_f44(F), { { 0.33333, 0.33333, -0.66667, -0.33333 }, {0.66667,-0.33333, -0.33333, -0.66667}, {-0.33333, 0.16667, 0.66667, 0.33333 }, {-0.16667, -0.16667, 0.33333, 0.66667 } }, errorcount );
  
  // Test vectors+matrixes
  Test::checkNearEqualVec( mult_f3_f33( x, A ), { 30.0, 36.0, 42.0 }, errorcount );
  Test::checkNearEqualVec( mult_f3_f44( x, C ), {  0.70833, 0.80556, 0.90278 }, errorcount );
  
  
  
  return errorcount;
}
