#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_BootHostedService.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_BootHostedService provider module";
Name = "Boot_OpenDRIM_BootHostedServiceModule";
Location = "cmpiBoot_OpenDRIM_BootHostedServiceProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_BootHostedService provider";
Name = "Boot_OpenDRIM_BootHostedServiceProvider";
ProviderModuleName = "Boot_OpenDRIM_BootHostedServiceModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_BootHostedService provider capabilities";
ProviderModuleName = "Boot_OpenDRIM_BootHostedServiceModule";
ProviderName = "Boot_OpenDRIM_BootHostedServiceProvider";
ClassName = "OpenDRIM_BootHostedService";
ProviderType = {2, 3};
Namespaces = {"$1"};
SupportedProperties = {"Antecedent", "Dependent"};
CapabilityID = "Boot_OpenDRIM_BootHostedService";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_BootHostedService.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_BootHostedService]   
   provider: Boot_OpenDRIM_BootHostedServiceProvider
   location: cmpiBoot_OpenDRIM_BootHostedServiceProvider
   type: instance association
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_BootHostedService.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_BootHostedService-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_BootHostedService.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
