/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.CORBA;

import com.visigenic.vbroker.CORBA.BaseSocket;
import com.visigenic.vbroker.CORBA.BoaStreamWorkerThread;
import com.visigenic.vbroker.CORBA.GiopInputStream;
import com.visigenic.vbroker.CORBA.GiopOutputStream;
import com.visigenic.vbroker.CORBA.IiopStream;
import com.visigenic.vbroker.CORBA.KeyId;
import com.visigenic.vbroker.CORBA.LocationForwardException;
import com.visigenic.vbroker.CORBA.ORB;
import com.visigenic.vbroker.CORBA.ObjectId;
import com.visigenic.vbroker.CORBA.ProtocolHandler;
import com.visigenic.vbroker.CORBA.SE;
import com.visigenic.vbroker.CORBA.SkeletonDelegate;
import com.visigenic.vbroker.CORBA.TransientId;
import com.visigenic.vbroker.GIOP.LocateReplyHeader;
import com.visigenic.vbroker.GIOP.LocateReplyHeaderHelper;
import com.visigenic.vbroker.GIOP.LocateRequestHeader;
import com.visigenic.vbroker.GIOP.LocateRequestHeaderHelper;
import com.visigenic.vbroker.GIOP.LocateStatusType;
import com.visigenic.vbroker.GIOP.MessageHeader;
import com.visigenic.vbroker.GIOP.MessageHeaderHelper;
import com.visigenic.vbroker.GIOP.ReplyHeader;
import com.visigenic.vbroker.GIOP.ReplyHeaderHelper;
import com.visigenic.vbroker.GIOP.ReplyStatusType;
import com.visigenic.vbroker.GIOP.RequestHeader;
import com.visigenic.vbroker.GIOP.RequestHeaderHelper;
import com.visigenic.vbroker.GIOP.ShmConnectReplyHeader;
import com.visigenic.vbroker.GIOP.ShmConnectReplyHeaderHelper;
import com.visigenic.vbroker.GIOP.ShmConnectRequestHeader;
import com.visigenic.vbroker.GIOP.ShmConnectRequestHeaderHelper;
import com.visigenic.vbroker.GIOP.ShmConnectStatusType;
import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.IORHelper;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Skeleton;

public class BoaStreamThread
extends Thread {
    protected ORB _orb;
    private IiopStream _stream;
    private ProtocolHandler _protocolHandler;
    private boolean _pooling;
    private Vector _skeletons = new Vector();
    private static Vector _threads = new Vector();
    private static byte[] EMPTY_OBJECT_KEY = new byte[0];
    private byte[] _objectKey = EMPTY_OBJECT_KEY;
    private Skeleton _skeleton;
    private RequestHeader _request;

    BoaStreamThread(ORB oRB, IiopStream iiopStream, Class clazz) {
        String string;
        this._orb = oRB;
        this._stream = iiopStream;
        if (clazz != null) {
            try {
                this._protocolHandler = (ProtocolHandler)clazz.newInstance();
                this._protocolHandler.init(this._orb);
            }
            catch (Exception exception) {
                throw new INTERNAL(exception.getMessage());
            }
        }
        this._pooling = (string = this._orb.getString("OAid")) != null && string.equals("ThreadPool");
    }

    protected BoaStreamThread() {
    }

    private void doLocateRequest(InputStream inputStream, OutputStream outputStream) {
        LocateRequestHeader locateRequestHeader = LocateRequestHeaderHelper.read(inputStream);
        LocateReplyHeader locateReplyHeader = new LocateReplyHeader();
        locateReplyHeader.request_id = locateRequestHeader.request_id;
        IOR iOR = null;
        try {
            ObjectId objectId = this._orb.toObjectId(locateRequestHeader.object_key);
            if (objectId instanceof KeyId && !(objectId instanceof TransientId)) {
                locateReplyHeader.locate_status = LocateStatusType.OBJECT_HERE;
            } else {
                locateReplyHeader.locate_status = LocateStatusType.OBJECT_FORWARD;
                Skeleton skeleton = objectId.toSkeleton();
                iOR = ((SkeletonDelegate)skeleton._get_delegate()).key_ior(skeleton);
            }
        }
        catch (SystemException systemException) {
            locateReplyHeader.locate_status = LocateStatusType.UNKNOWN_OBJECT;
        }
        LocateReplyHeaderHelper.write(outputStream, locateReplyHeader);
        if (locateReplyHeader.locate_status == LocateStatusType.OBJECT_FORWARD) {
            IORHelper.write(outputStream, iOR);
        }
    }

    private void doShmConnectRequest(InputStream inputStream, OutputStream outputStream) {
        ShmConnectRequestHeader shmConnectRequestHeader = ShmConnectRequestHeaderHelper.read((InputStream)inputStream);
        ShmConnectReplyHeader shmConnectReplyHeader = new ShmConnectReplyHeader(shmConnectRequestHeader.request_id, ShmConnectStatusType.SHM_NOT_SUPPORTED);
        ShmConnectReplyHeaderHelper.write(outputStream, shmConnectReplyHeader);
    }

    static byte[] get_principal(Object object) {
        Thread thread = Thread.currentThread();
        if (thread instanceof BoaStreamThread) {
            BoaStreamThread boaStreamThread;
            BoaStreamThread boaStreamThread2 = boaStreamThread = (BoaStreamThread)thread;
            synchronized (boaStreamThread2) {
                if (boaStreamThread._request != null && boaStreamThread._skeleton == object) {
                    byte[] byArray = boaStreamThread._request.requesting_principal;
                    java.lang.Object var5_5 = null;
                    return byArray;
                }
            }
        }
        return null;
    }

    private synchronized boolean doRequest(GiopInputStream giopInputStream, GiopOutputStream giopOutputStream) {
        try {
            int n;
            ReplyHeader replyHeader;
            block18: {
                this._request = RequestHeaderHelper.read(giopInputStream);
                giopOutputStream.request(this._request);
                replyHeader = new ReplyHeader(this._request.service_context, this._request.request_id, ReplyStatusType.NO_EXCEPTION);
                n = giopOutputStream.offset();
                ReplyHeaderHelper.write(giopOutputStream, replyHeader);
                try {
                    try {
                        boolean bl = false;
                        if (this._request.object_key.length == this._objectKey.length) {
                            bl = true;
                            int n2 = 0;
                            while (n2 < this._objectKey.length) {
                                if (this._request.object_key[n2] != this._objectKey[n2]) {
                                    bl = false;
                                    break;
                                }
                                ++n2;
                            }
                        }
                        if (!bl) {
                            ObjectId objectId = this._orb.toObjectId(this._request.object_key);
                            if (objectId == null) {
                                throw new INV_OBJREF();
                            }
                            this._skeleton = objectId.toSkeleton();
                            this._objectKey = this._request.object_key;
                        }
                        if (this._request.operation.equals("__bind")) {
                            this._skeletons.addElement(this._skeleton);
                            break block18;
                        }
                        if (this._request.operation.equals("__unbind")) {
                            this._skeletons.removeElement(this._skeleton);
                            break block18;
                        }
                        try {
                            SkeletonDelegate skeletonDelegate = (SkeletonDelegate)this._orb.getDelegate(this._skeleton);
                            boolean bl2 = skeletonDelegate.execute(this._skeleton, this._request, giopInputStream, giopOutputStream);
                            if (bl2) {
                                replyHeader.reply_status = ReplyStatusType.USER_EXCEPTION;
                            }
                        }
                        catch (LocationForwardException locationForwardException) {
                            replyHeader.reply_status = ReplyStatusType.LOCATION_FORWARD;
                            IORHelper.write(giopOutputStream, locationForwardException.ior());
                        }
                    }
                    catch (SystemException systemException) {
                        systemException.fillInStackTrace();
                        throw systemException;
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                        IMP_LIMIT iMP_LIMIT = new IMP_LIMIT("RuntimeException: " + runtimeException);
                        System.err.println("VisiBroker for Java runtime throwing: " + iMP_LIMIT);
                        throw iMP_LIMIT;
                    }
                }
                catch (SystemException systemException) {
                    replyHeader.reply_status = ReplyStatusType.SYSTEM_EXCEPTION;
                    SE.write(giopOutputStream, systemException);
                }
            }
            if (replyHeader.reply_status != ReplyStatusType.NO_EXCEPTION) {
                int n3 = giopOutputStream.offset();
                giopOutputStream.offset(n);
                ReplyHeaderHelper.write(giopOutputStream, replyHeader);
                giopOutputStream.offset(n3);
            }
            boolean bl = this._request.response_expected;
            java.lang.Object var5_17 = null;
            this._request = null;
            return bl;
        }
        catch (Throwable throwable) {
            java.lang.Object var5_18 = null;
            this._request = null;
            throw throwable;
        }
    }

    protected void doMessage(MessageHeader messageHeader, GiopInputStream giopInputStream) {
        GiopOutputStream giopOutputStream = this._orb.newGiopOutputStream();
        giopOutputStream.offset(12);
        giopOutputStream.byteOrder(giopInputStream.byteOrder());
        boolean bl = true;
        switch (messageHeader.message_type) {
            case 0: {
                messageHeader.message_type = 1;
                bl = this.doRequest(giopInputStream, giopOutputStream);
                break;
            }
            case 3: {
                messageHeader.message_type = (byte)4;
                this.doLocateRequest(giopInputStream, giopOutputStream);
                break;
            }
            case 7: {
                messageHeader.message_type = (byte)8;
                this.doShmConnectRequest(giopInputStream, giopOutputStream);
                break;
            }
            case 2: {
                throw new TRANSIENT(this._orb.messageType(messageHeader));
            }
            case 5: {
                throw new COMM_FAILURE(this._orb.messageType(messageHeader));
            }
            default: {
                throw new MARSHAL("Invalid message type: " + this._orb.messageType(messageHeader));
            }
        }
        if (bl) {
            int n = giopOutputStream.offset();
            messageHeader.message_size = n - 12;
            messageHeader.flags = (byte)(giopOutputStream.byteOrder() ? 1 : 0);
            giopOutputStream.offset(0);
            MessageHeaderHelper.write(giopOutputStream, messageHeader);
            giopOutputStream.offset(n);
            if (!this._pooling) {
                this._stream.write(giopOutputStream.bytes(), 0, giopOutputStream.offset());
                return;
            }
            IiopStream iiopStream = this._stream;
            synchronized (iiopStream) {
                BaseSocket baseSocket = this._stream.socket();
                synchronized (baseSocket) {
                    this._stream.write(giopOutputStream.bytes(), 0, giopOutputStream.offset());
                }
                return;
            }
        }
    }

    private void dispatchMessage(MessageHeader messageHeader, GiopInputStream giopInputStream) {
        BoaStreamWorkerThread boaStreamWorkerThread;
        int n;
        if (!this._pooling) {
            this.doMessage(messageHeader, giopInputStream);
            return;
        }
        Vector vector = this._orb.workerThreads();
        synchronized (vector) {
            n = this._orb.workerThreads().size();
            if (n == 0) {
                boaStreamWorkerThread = new BoaStreamWorkerThread();
                _threads.addElement(boaStreamWorkerThread);
            } else {
                boaStreamWorkerThread = (BoaStreamWorkerThread)this._orb.workerThreads().elementAt(n - 1);
                this._orb.workerThreads().removeElementAt(n - 1);
            }
        }
        boaStreamWorkerThread._orb = this._orb;
        boaStreamWorkerThread._stream = this._stream;
        boaStreamWorkerThread._protocolHandler = this._protocolHandler;
        boaStreamWorkerThread._skeletons = this._skeletons;
        boaStreamWorkerThread._pooling = this._pooling;
        boaStreamWorkerThread._objectKey = EMPTY_OBJECT_KEY;
        boaStreamWorkerThread._header = messageHeader;
        boaStreamWorkerThread._input = giopInputStream;
        if (n == 0) {
            boaStreamWorkerThread.start();
            return;
        }
        boaStreamWorkerThread.resume();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        java.lang.Object var2_1;
        _threads.addElement(this);
        try {
            while (true) {
                try {
                    if (this._orb.boa().shouldExit()) {
                        System.exit(0);
                    }
                    GiopInputStream[] giopInputStreamArray = new GiopInputStream[1];
                    MessageHeader messageHeader = this._orb.readMessage(this._stream, giopInputStreamArray, this._protocolHandler);
                    this.dispatchMessage(messageHeader, giopInputStreamArray[0]);
                }
                catch (COMM_FAILURE cOMM_FAILURE) {
                    var2_1 = null;
                    _threads.removeElement(this);
                    break;
                }
                catch (SystemException systemException) {
                    var2_1 = null;
                    _threads.removeElement(this);
                    break;
                }
                var2_1 = null;
                _threads.removeElement(this);
            }
        }
        catch (Throwable throwable) {
            var2_1 = null;
            _threads.removeElement(this);
            throw throwable;
        }
        try {
            if (this._protocolHandler == null || !this._protocolHandler.used()) {
                Enumeration enumeration = this._skeletons.elements();
                while (enumeration.hasMoreElements()) {
                    Skeleton cfr_ignored_0 = (Skeleton)enumeration.nextElement();
                }
            }
            this._stream.close();
            return;
        }
        catch (SystemException systemException) {
            systemException.printStackTrace();
            return;
        }
    }

    public static Enumeration threads() {
        return _threads.elements();
    }

    public Enumeration skeletons() {
        return this._skeletons.elements();
    }

    public static void clearCache() {
        Enumeration enumeration = BoaStreamThread.threads();
        while (enumeration.hasMoreElements()) {
            ((BoaStreamThread)enumeration.nextElement())._objectKey = EMPTY_OBJECT_KEY;
        }
    }

    public String toString() {
        return "BoaStreamThread[stream=" + this._stream + "," + super.toString() + "]";
    }
}

