/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ImageProducer;
import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.ExternalWindow;
import netscape.application.FileChooser;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.Graphics;
import netscape.application.Menu;
import netscape.application.MenuItem;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Sound;

public class AWTCompatibility {
    private AWTCompatibility() {
    }

    public static Bitmap bitmapForAWTImage(Image image) {
        return new Bitmap(image);
    }

    public static Bitmap bitmapForAWTImageProducer(ImageProducer imageProducer) {
        return new Bitmap(Application.application().applet.createImage(imageProducer));
    }

    public static Image awtImageForBitmap(Bitmap bitmap) {
        return bitmap.awtImage;
    }

    public static ImageProducer awtImageProducerForBitmap(Bitmap bitmap) {
        return bitmap.awtImage.getSource();
    }

    public static Sound soundForAWTAudioClip(AudioClip audioClip) {
        Sound sound = new Sound();
        sound.awtSound = audioClip;
        return sound;
    }

    public static AudioClip awtAudioClipForSound(Sound sound) {
        return sound.awtSound;
    }

    public static Font fontForAWTFont(java.awt.Font font) {
        Font font2 = new Font();
        font2._awtFont = font;
        font2._name = font.getName();
        font2._type = 1;
        return font2;
    }

    public static java.awt.Font awtFontForFont(Font font) {
        return font._awtFont;
    }

    public static Color colorForAWTColor(java.awt.Color color) {
        return new Color(color);
    }

    public static java.awt.Color awtColorForColor(Color color) {
        return color._color;
    }

    public static FontMetrics fontMetricsForAWTFontMetrics(java.awt.FontMetrics fontMetrics) {
        return new FontMetrics(fontMetrics);
    }

    public static java.awt.FontMetrics awtFontMetricsForFontMetrics(FontMetrics fontMetrics) {
        return fontMetrics._awtMetrics;
    }

    public static MenuBar awtMenuBarForMenu(Menu menu) {
        if (menu.isTopLevel()) {
            return menu.awtMenuBar();
        }
        return null;
    }

    public static java.awt.Menu awtMenuForMenu(Menu menu) {
        if (!menu.isTopLevel()) {
            return menu.awtMenu();
        }
        return null;
    }

    public static java.awt.MenuItem awtMenuItemForMenuItem(MenuItem menuItem) {
        return menuItem.foundationMenuItem();
    }

    public static Graphics graphicsForAWTGraphics(java.awt.Graphics graphics) {
        Rectangle rectangle = graphics.getClipRect();
        Rect rect = rectangle != null ? new Rect(rectangle.x, rectangle.y, rectangle.width, rectangle.height) : new Rect(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        return new Graphics(rect, graphics.create());
    }

    public static java.awt.Graphics awtGraphicsForGraphics(Graphics graphics) {
        return graphics.awtGraphics();
    }

    public static Panel awtPanelForRootView(RootView rootView) {
        return rootView.panel();
    }

    public static Window awtWindowForExternalWindow(ExternalWindow externalWindow) {
        return externalWindow.awtWindow;
    }

    public static Applet awtApplet() {
        Application application = Application.application();
        if (application == null) {
            return null;
        }
        return application.applet;
    }

    public static FileDialog awtFileDialogForFileChooser(FileChooser fileChooser) {
        return fileChooser.awtDialog;
    }

    public static Toolkit awtToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public static Frame awtFrameForRootView(RootView rootView) {
        return rootView.panel().frame();
    }
}

