/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.Container;
import netscape.application.AWTCompatibility;
import netscape.application.AWTComponentView;
import netscape.application.Application;
import netscape.application.ApplicationEvent;
import netscape.application.Autoscroller;
import netscape.application.Color;
import netscape.application.ColorChooser;
import netscape.application.DragView;
import netscape.application.Event;
import netscape.application.EventProcessor;
import netscape.application.ExtendedTarget;
import netscape.application.ExternalWindow;
import netscape.application.Font;
import netscape.application.FontChooser;
import netscape.application.FoundationDialog;
import netscape.application.FoundationFrame;
import netscape.application.FoundationPanel;
import netscape.application.FoundationWindow;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.InternalWindow;
import netscape.application.JDK11AirLock;
import netscape.application.KeyEvent;
import netscape.application.KeyStroke;
import netscape.application.KeyboardArrow;
import netscape.application.MenuItem;
import netscape.application.MenuView;
import netscape.application.MouseEvent;
import netscape.application.MouseFilter;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.ResizeFilter;
import netscape.application.Target;
import netscape.application.Timer;
import netscape.application.UpdateFilter;
import netscape.application.VectorCache;
import netscape.application.View;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class RootView
extends View
implements EventProcessor,
ExtendedTarget {
    Color _backgroundColor;
    Image _image;
    FoundationPanel panel;
    Application application;
    Timer _autoscrollTimer;
    ColorChooser colorChooser;
    FontChooser fontChooser;
    InternalWindow _mainWindow;
    View _mouseView;
    View _moveView;
    View _focusedView;
    View _windowClipView;
    View _mouseClickView;
    View _rootViewFocusedView;
    View _selectedView;
    View _defaultSelectedView;
    Vector windows = new Vector();
    long _lastClickTime;
    int _clickCount;
    int _mouseX;
    int _mouseY;
    int _currentCursor;
    int _viewCursor;
    int _overrideCursor = -1;
    int mouseDownCount;
    int _imageDisplayStyle;
    Vector dirtyViews = new Vector();
    boolean _redrawTransWindows = true;
    boolean recomputeCursor;
    boolean recomputeMoveView;
    boolean isVisible;
    boolean redrawAll = true;
    Vector componentViews;
    MouseFilter mouseFilter = new MouseFilter();
    static Vector _commands = new Vector();
    static final String VALIDATE_SELECTED_VIEW = "validateSelectedView";

    public RootView() {
        this(0, 0, 0, 0);
    }

    public RootView(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public RootView(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this._backgroundColor = Color.gray;
        this.application = Application.application();
        this._defaultSelectedView = this;
    }

    void addWindowRelativeTo(InternalWindow internalWindow, int n, InternalWindow internalWindow2) {
        if (internalWindow == null) {
            return;
        }
        if (this._windowClipView != null && internalWindow.layer() < 500) {
            this._windowClipView.addSubview(internalWindow);
        } else {
            this.addSubview(internalWindow);
        }
        this.makeWindowVisible(internalWindow, n, internalWindow2);
    }

    void removeWindow(InternalWindow internalWindow) {
        if (internalWindow == null) {
            return;
        }
        Rect rect = this.absoluteWindowBounds(internalWindow);
        internalWindow.removeFromSuperview();
        int n = this.windows.indexOf((Object)internalWindow) - 1;
        if (n < 0) {
            n = this.windows.indexOf((Object)internalWindow);
        }
        this.windows.removeElement((Object)internalWindow);
        if (internalWindow == this._mainWindow) {
            InternalWindow internalWindow2 = null;
            n = this.windows.count() - 1;
            while (n >= 0) {
                if (((InternalWindow)this.windows.elementAt(n)).canBecomeMain()) {
                    internalWindow2 = (InternalWindow)this.windows.elementAt(n);
                    break;
                }
                --n;
            }
            this._setMainWindow(internalWindow2);
        }
        if (this.canDraw()) {
            this.redraw(rect);
            this.redrawTransparentWindows(rect, null);
        }
        if (!(internalWindow instanceof KeyboardArrow)) {
            this.validateSelectedView();
        }
        this.createMouseEnterLater();
    }

    public Vector internalWindows() {
        return this.windows;
    }

    public InternalWindow mainWindow() {
        return this._mainWindow;
    }

    void _setMainWindow(InternalWindow internalWindow) {
        if (this._mainWindow == internalWindow || internalWindow != null && !internalWindow.canBecomeMain()) {
            return;
        }
        InternalWindow internalWindow2 = this._mainWindow;
        this._mainWindow = internalWindow;
        if (internalWindow2 != null) {
            internalWindow2.didResignMain();
        } else if (this._focusedView != null && !this.isInWindow(this._focusedView)) {
            this._rootViewFocusedView = this._focusedView;
            this.setFocusedView(null, false);
        }
        if (this._mainWindow != null) {
            this._mainWindow.didBecomeMain();
        } else if (this.rootViewFocusedView() != null) {
            this.setFocusedView(this.rootViewFocusedView(), false);
            this._rootViewFocusedView = null;
        }
        this.validateSelectedView();
        this.createMouseEnterLater();
    }

    InternalWindow frontWindowWithLayer(int n) {
        int n2 = this.windows.count() - 1;
        while (n2 >= 0) {
            InternalWindow internalWindow = (InternalWindow)this.windows.elementAt(n2);
            if (internalWindow.layer() == n) {
                return internalWindow;
            }
            --n2;
        }
        return null;
    }

    InternalWindow backWindowWithLayer(int n) {
        int n2 = this.windows.count();
        int n3 = 0;
        while (n3 < n2) {
            InternalWindow internalWindow = (InternalWindow)this.windows.elementAt(n3);
            if (internalWindow.layer() == n) {
                return internalWindow;
            }
            ++n3;
        }
        return null;
    }

    void makeWindowVisible(InternalWindow internalWindow, int n, InternalWindow internalWindow2) {
        boolean bl;
        InternalWindow internalWindow3 = null;
        if (internalWindow == null) {
            return;
        }
        if (!internalWindow.descendsFrom(this)) {
            return;
        }
        int n2 = this.windows.indexOf((Object)internalWindow);
        int n3 = internalWindow.layer();
        if (internalWindow2 != null) {
            if (internalWindow2.layer() > n3) {
                internalWindow2 = null;
                n = 0;
            } else if (internalWindow2.layer() < n3) {
                internalWindow2 = null;
                n = 1;
            }
        }
        this.windows.removeElement((Object)internalWindow);
        if (internalWindow2 != null) {
            boolean bl2 = n == 0 ? this.windows.insertElementAfter((Object)internalWindow, (Object)internalWindow2) : this.windows.insertElementBefore((Object)internalWindow, (Object)internalWindow2);
            if (bl2) {
                this._setMainWindow(internalWindow);
                if (n2 != this.windows.indexOf((Object)internalWindow)) {
                    internalWindow.draw();
                    this.updateTransWindows(internalWindow);
                    if (n == 1) {
                        this.updateWindowsAbove(internalWindow);
                    }
                }
                return;
            }
            internalWindow2 = null;
        }
        int n4 = this.windows.count();
        while (n4-- > 0) {
            internalWindow3 = (InternalWindow)this.windows.elementAt(n4);
            if (internalWindow3.layer() <= n3 && internalWindow3.layer() <= n3) break;
        }
        if (internalWindow3 == null) {
            this.windows.insertElementAt((Object)internalWindow, 0);
            bl = true;
        } else {
            bl = internalWindow3.layer() > n3 ? this.windows.insertElementBefore((Object)internalWindow, (Object)internalWindow3) : this.windows.insertElementAfter((Object)internalWindow, (Object)internalWindow3);
        }
        if (!bl) {
            this.windows.insertElementAt((Object)internalWindow, 0);
        }
        this._setMainWindow(internalWindow);
        if (n2 != this.windows.indexOf((Object)internalWindow)) {
            internalWindow.draw();
            this.updateTransWindows(internalWindow);
        }
    }

    void updateWindowsAbove(InternalWindow internalWindow) {
        Rect rect = this.absoluteWindowBounds(internalWindow);
        int n = this.windows.indexOf((Object)internalWindow);
        Rect rect2 = new Rect();
        int n2 = n + 1;
        int n3 = this.windows.count();
        while (n2 < n3) {
            InternalWindow internalWindow2 = (InternalWindow)this.windows.elementAt(n2);
            Rect rect3 = this.absoluteWindowBounds(internalWindow2);
            if (rect.intersects(rect3)) {
                rect2.setBounds(rect);
                rect2.intersectWith(rect3);
                this.convertRectToView(internalWindow2, rect2, rect2);
                internalWindow2.addDirtyRect(rect2);
            }
            ++n2;
        }
    }

    void updateTransWindows(InternalWindow internalWindow) {
        if (internalWindow == null) {
            return;
        }
        int n = this.windows.indexOf((Object)internalWindow);
        Rect rect = internalWindow.superview().convertRectToView(this, internalWindow.bounds);
        int n2 = 0;
        while (n2 < n) {
            Rect rect2;
            InternalWindow internalWindow2 = (InternalWindow)this.windows.elementAt(n2);
            if (internalWindow2.isTransparent() && ((rect2 = this.absoluteWindowBounds(internalWindow2)).intersects(rect) || rect.intersects(rect2))) {
                internalWindow2.updateDrawingBuffer();
            }
            ++n2;
        }
    }

    void disableWindowsAbove(InternalWindow internalWindow, boolean bl) {
        if (internalWindow == null) {
            return;
        }
        int n = this.windows.indexOf((Object)internalWindow);
        if (n == -1) {
            return;
        }
        int n2 = this.windows.count();
        while (n < n2) {
            InternalWindow internalWindow2 = (InternalWindow)this.windows.elementAt(n);
            if (bl) {
                internalWindow2.disableDrawing();
            } else {
                internalWindow2.reenableDrawing();
            }
            ++n;
        }
    }

    Vector windowRects(Rect rect, InternalWindow internalWindow) {
        Vector vector = null;
        int n = this.windows.count();
        int n2 = internalWindow != null ? this.windows.indexOf((Object)internalWindow) + 1 : 0;
        while (n2 < n) {
            InternalWindow internalWindow2 = (InternalWindow)this.windows.elementAt(n2);
            Rect rect2 = this.absoluteWindowBounds(internalWindow2);
            if (rect2.intersects(rect) || rect.intersects(rect2)) {
                if (vector == null) {
                    vector = VectorCache.newVector();
                }
                vector.addElement((Object)new Rect(rect2));
            }
            ++n2;
        }
        return vector;
    }

    void setRedrawTransparentWindows(boolean bl) {
        this._redrawTransWindows = bl;
    }

    public void redrawTransparentWindows(Rect rect, InternalWindow internalWindow) {
        this.redrawTransparentWindows(null, rect, internalWindow);
    }

    public void redrawTransparentWindows(Graphics graphics, Rect rect, InternalWindow internalWindow) {
        Rect rect2 = null;
        if (!this._redrawTransWindows) {
            return;
        }
        int n = this.windows.count();
        int n2 = internalWindow != null ? this.windows.indexOf((Object)internalWindow) + 1 : 0;
        while (n2 < n) {
            Rect rect3;
            InternalWindow internalWindow2 = (InternalWindow)this.windows.elementAt(n2);
            if (internalWindow2.isTransparent() && (rect3 = this.absoluteWindowBounds(internalWindow2)).intersects(rect)) {
                if (rect2 == null) {
                    rect2 = Rect.newRect();
                }
                this.convertRectToView(internalWindow2, rect, rect2);
                internalWindow2.draw(graphics, rect2);
            }
            ++n2;
        }
        if (rect2 != null) {
            Rect.returnRect(rect2);
        }
    }

    void paint(ApplicationEvent applicationEvent) {
        UpdateFilter updateFilter = new UpdateFilter(applicationEvent.rect());
        updateFilter.rootView = this;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        this.application.eventLoop().filterEvents(updateFilter);
        if (this.redrawAll) {
            Rect rect = Rect.newRect(0, 0, this.bounds.width, this.bounds.height);
            this.redraw(rect);
            this.redrawTransparentWindows(rect, null);
            Rect.returnRect(rect);
        } else {
            this.redraw(updateFilter._rect);
            this.redrawTransparentWindows(updateFilter._rect, null);
        }
        AWTCompatibility.awtToolkit().sync();
    }

    void print(ApplicationEvent applicationEvent) {
        Rect rect = new Rect(0, 0, this.width(), this.height());
        Graphics graphics = new Graphics(rect, applicationEvent.graphics());
        this.redraw(graphics, rect);
        this.redrawTransparentWindows(graphics, rect, null);
    }

    void resize(ApplicationEvent applicationEvent) {
        ResizeFilter resizeFilter = new ResizeFilter();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {}
        resizeFilter.lastEvent = applicationEvent;
        this.application.eventLoop().filterEvents(resizeFilter);
        this.sizeTo(resizeFilter.lastEvent.rect().width, resizeFilter.lastEvent.rect().height);
    }

    public void setMouseView(View view) {
        this._mouseView = view;
    }

    public View mouseView() {
        return this._mouseView;
    }

    public View viewForMouse(int n, int n2) {
        View view = null;
        int n3 = this.windows.count();
        while (n3-- > 0 && view == null) {
            InternalWindow internalWindow = (InternalWindow)this.windows.elementAt(n3);
            Rect rect = this.absoluteWindowBounds(internalWindow);
            view = internalWindow.viewForMouse(n - rect.x, n2 - rect.y);
        }
        if (view != null) {
            return view;
        }
        return super.viewForMouse(n, n2);
    }

    void _mouseDown(MouseEvent mouseEvent) {
        ++this.mouseDownCount;
        if (this.mouseDownCount > 1) {
            return;
        }
        View view = this.viewForMouse(mouseEvent.x, mouseEvent.y);
        if (view == null) {
            this._mouseView = null;
            return;
        }
        long l = mouseEvent.timeStamp;
        this._clickCount = this._mouseClickView == view && l - this._lastClickTime < 250L ? ++this._clickCount : 1;
        this._lastClickTime = l;
        mouseEvent.setClickCount(this._clickCount);
        this._mouseView = this._mouseClickView = view;
        if (this.viewExcludedFromModalSession(view)) {
            return;
        }
        if (!(this._mouseView instanceof InternalWindow)) {
            InternalWindow internalWindow = this._mouseView.window();
            if (!(this._mouseView instanceof MenuView) || internalWindow != null) {
                this._setMainWindow(internalWindow);
            }
        }
        mouseEvent.x -= this._mouseView.absoluteX();
        mouseEvent.y -= this._mouseView.absoluteY();
        View view2 = this._mouseView;
        if (!this._mouseView.mouseDown(mouseEvent) && view2 == this._mouseView) {
            this._mouseView = null;
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    void setVisible(boolean bl) {
        if (this.isVisible != bl) {
            this.isVisible = bl;
            if (this.isVisible) {
                this.ancestorWasAddedToViewHierarchy(this);
                if (this._focusedView != null) {
                    this._focusedView._startFocus();
                    Application.application().focusChanged(this._focusedView);
                    return;
                }
            } else {
                this.ancestorWillRemoveFromViewHierarchy(this);
                if (this._focusedView != null) {
                    this._focusedView._pauseFocus();
                }
            }
        }
    }

    void _mouseDrag(MouseEvent mouseEvent) {
        if (this.viewExcludedFromModalSession(this._mouseView)) {
            return;
        }
        if (this._mouseView != null) {
            boolean bl = this._mouseView.containsPointInVisibleRect(mouseEvent.x, mouseEvent.y);
            if (this._mouseView.wantsAutoscrollEvents() && !bl) {
                if (this._autoscrollTimer == null) {
                    Autoscroller autoscroller = new Autoscroller();
                    this._autoscrollTimer = new Timer(autoscroller, "autoscroll", 100);
                    this._autoscrollTimer.start();
                    this._autoscrollTimer.setData(this._mouseView);
                    autoscroller.setEvent(this._mouseView.convertEventToView(null, mouseEvent));
                    return;
                }
                Autoscroller autoscroller = (Autoscroller)this._autoscrollTimer.target();
                autoscroller.setEvent(this._mouseView.convertEventToView(null, mouseEvent));
                return;
            }
            if (this._autoscrollTimer != null) {
                this._autoscrollTimer.stop();
                this._autoscrollTimer = null;
            }
            mouseEvent.setClickCount(this._clickCount);
            this._mouseView.mouseDragged(mouseEvent);
            return;
        }
        if (this._autoscrollTimer != null) {
            this._autoscrollTimer.stop();
            this._autoscrollTimer = null;
        }
    }

    void _mouseUp(MouseEvent mouseEvent) {
        View view;
        --this.mouseDownCount;
        if (this.mouseDownCount > 0) {
            return;
        }
        if (this.viewExcludedFromModalSession(this._mouseView)) {
            return;
        }
        if (this._mouseView != null) {
            mouseEvent.setClickCount(this._clickCount);
            this._mouseView.mouseUp(mouseEvent);
            if (this._autoscrollTimer != null) {
                this._autoscrollTimer.stop();
                this._autoscrollTimer = null;
            }
        }
        if ((view = this.viewForMouse(this._mouseX, this._mouseY)) != this._moveView) {
            this.createMouseEnter();
        }
        this._mouseClickView = this._mouseView;
        this._mouseView = null;
    }

    void createMouseEnter() {
        MouseEvent mouseEvent = new MouseEvent(System.currentTimeMillis(), -4, this._mouseX, this._mouseY, 0);
        this._mouseEnter(mouseEvent);
    }

    void createMouseEnterLater() {
        if (this._mouseView == null) {
            this.recomputeMoveView = true;
        }
    }

    void _mouseEnter(MouseEvent mouseEvent) {
        this._mouseMove(mouseEvent);
    }

    void _mouseMove(MouseEvent mouseEvent) {
        View view = this.viewForMouse(mouseEvent.x, mouseEvent.y);
        if (this.viewExcludedFromModalSession(view)) {
            return;
        }
        if (view == this._moveView) {
            if (this._moveView == null) {
                return;
            }
            MouseEvent mouseEvent2 = this.convertEventToView(this._moveView, mouseEvent);
            this._moveView.mouseMoved(mouseEvent2);
        } else {
            MouseEvent mouseEvent3;
            View view2 = this._moveView;
            this._moveView = view;
            if (view2 != null) {
                mouseEvent3 = this.convertEventToView(view2, mouseEvent);
                mouseEvent3.setType(-6);
                view2.mouseExited(mouseEvent3);
            }
            if (this._moveView != null) {
                mouseEvent3 = this.convertEventToView(this._moveView, mouseEvent);
                mouseEvent3.setType(-4);
                this._moveView.mouseEntered(mouseEvent3);
            }
        }
        this.updateCursorLater();
    }

    void _mouseExit(MouseEvent mouseEvent) {
        if (this._moveView != null) {
            this._moveView.mouseExited(this.convertEventToView(this._moveView, mouseEvent));
            this._moveView = null;
            this.updateCursorLater();
        }
    }

    void flushCursor() {
        int n = this._overrideCursor != -1 ? this._overrideCursor : this._viewCursor;
        if (n != this._currentCursor) {
            this.panel.setCursor(n);
            this._currentCursor = n;
        }
    }

    void computeCursor() {
        View view = this.viewForMouse(this._mouseX, this._mouseY);
        if (view != null) {
            Point point = Point.newPoint();
            this.convertToView(view, this._mouseX, this._mouseY, point);
            this._viewCursor = view.cursorForPoint(point.x, point.y);
            Point.returnPoint(point);
        } else {
            this._viewCursor = 0;
        }
        this.flushCursor();
    }

    public int cursor() {
        return this._currentCursor;
    }

    public void setOverrideCursor(int n) {
        if (n < -1 || n > 13) {
            throw new InconsistencyException("Unknown cursor type: " + n);
        }
        if (this._overrideCursor != n) {
            this._overrideCursor = n;
            this.flushCursor();
        }
    }

    public void removeOverrideCursor() {
        this.setOverrideCursor(-1);
    }

    public void updateCursor() {
        this.computeCursor();
    }

    public void updateCursorLater() {
        this.recomputeCursor = true;
    }

    void _updateCursorAndMoveView() {
        if (this.recomputeMoveView) {
            this.createMouseEnter();
            this.recomputeMoveView = false;
            this.recomputeCursor = false;
            return;
        }
        if (this.recomputeCursor) {
            this.computeCursor();
            this.recomputeCursor = false;
        }
    }

    void _keyDown(KeyEvent keyEvent) {
        boolean bl = false;
        MenuItem menuItem = null;
        View view = this._focusedView;
        ExternalWindow externalWindow = this.externalWindow();
        if (externalWindow != null && externalWindow.menu() != null) {
            if (JDK11AirLock.menuShortcutExists()) {
                menuItem = externalWindow.menu().itemForKeyEvent(keyEvent);
                if (menuItem != null) {
                    bl = true;
                }
            } else {
                bl = externalWindow.menu().handleCommandKeyEvent(keyEvent);
            }
        }
        if (!bl) {
            if (this.processKeyboardEvent(keyEvent, true)) {
                return;
            }
            if (view != null && !this.viewExcludedFromModalSession(view)) {
                view.keyDown(keyEvent);
                return;
            }
            this.application().keyDown(keyEvent);
        }
    }

    void _keyUp(KeyEvent keyEvent) {
        View view = this._focusedView;
        if (view != null && !this.viewExcludedFromModalSession(view)) {
            view.keyUp(keyEvent);
            return;
        }
        this.application().keyUp(keyEvent);
    }

    void _keyTyped(KeyEvent keyEvent) {
        View view = this._focusedView;
        if (view != null && !this.viewExcludedFromModalSession(view)) {
            view.keyTyped(keyEvent);
            return;
        }
        this.application().keyTyped(keyEvent);
    }

    public void showColorChooser() {
        this.colorChooser().show();
    }

    public ColorChooser colorChooser() {
        if (this.colorChooser == null) {
            InternalWindow internalWindow = new InternalWindow(0, 0, 10, 10);
            internalWindow.setRootView(this);
            this.colorChooser = new ColorChooser();
            this.colorChooser.setWindow(internalWindow);
            internalWindow.center();
        }
        return this.colorChooser;
    }

    public void showFontChooser() {
        this.fontChooser().show();
    }

    public FontChooser fontChooser() {
        if (this.fontChooser == null) {
            InternalWindow internalWindow = new InternalWindow(0, 0, 1, 1);
            internalWindow.setRootView(this);
            this.fontChooser = new FontChooser();
            this.fontChooser.setWindow(internalWindow);
            internalWindow.center();
        }
        return this.fontChooser;
    }

    public ExternalWindow externalWindow() {
        Container container = this.panel;
        while (container != null) {
            if (container instanceof FoundationFrame) {
                return ((FoundationFrame)container).externalWindow;
            }
            if (container instanceof FoundationDialog) {
                return ((FoundationDialog)container).externalWindow;
            }
            if (container instanceof FoundationWindow) {
                return ((FoundationWindow)container).externalWindow;
            }
            container = container.getParent();
        }
        return null;
    }

    MouseEvent removeMouseEvents(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = (MouseEvent)this.application.eventLoop().filterEvents(this.mouseFilter);
        if (mouseEvent2 != null) {
            return mouseEvent2;
        }
        return mouseEvent;
    }

    void _convertMouseEventToMouseView(MouseEvent mouseEvent) {
        if (this._mouseView == null || mouseEvent == null) {
            return;
        }
        Point point = Point.newPoint();
        this.convertToView(this._mouseView, mouseEvent.x, mouseEvent.y, point);
        mouseEvent.x = point.x;
        mouseEvent.y = point.y;
        Point.returnPoint(point);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processEvent(Event event) {
        if (this.application == null) {
            return;
        }
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            int n = mouseEvent.type;
            if (n == -5 && this.mouseDownCount > 0 && this._mouseView != null) {
                MouseEvent mouseEvent2 = this.convertEventToView(this._mouseView, mouseEvent);
                mouseEvent2.setType(-3);
                this._mouseUp(mouseEvent2);
            }
            if (n == -2 && this._mouseView != null && this._mouseView.wantsMouseEventCoalescing()) {
                mouseEvent = this.removeMouseEvents(mouseEvent);
                n = mouseEvent.type();
            } else if (n == -5 && this._moveView != null && this._moveView.wantsMouseEventCoalescing()) {
                mouseEvent = this.removeMouseEvents(mouseEvent);
                n = mouseEvent.type();
            }
            this._mouseX = mouseEvent.x;
            this._mouseY = mouseEvent.y;
            switch (n) {
                case -1: {
                    if (this.application.firstRootView() != this) {
                        this.application.makeFirstRootView(this);
                    }
                    this._mouseDown(mouseEvent);
                    return;
                }
                case -2: {
                    this._convertMouseEventToMouseView(mouseEvent);
                    this._mouseDrag(mouseEvent);
                    return;
                }
                case -3: {
                    this._convertMouseEventToMouseView(mouseEvent);
                    this._mouseUp(mouseEvent);
                    return;
                }
                case -4: {
                    if (this._mouseView != null) return;
                    this._mouseEnter(mouseEvent);
                    return;
                }
                case -5: {
                    this._mouseMove(mouseEvent);
                    return;
                }
                case -6: {
                    if (this._mouseView != null) return;
                    this._mouseExit(mouseEvent);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (event instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (this.application.firstRootView() != this) {
                this.application.makeFirstRootView(this);
            }
            if (keyEvent.type == -11) {
                this._keyDown(keyEvent);
                return;
            }
            if (keyEvent.type == -12) {
                this._keyUp(keyEvent);
                return;
            }
            this._keyTyped(keyEvent);
            return;
        }
        if (!(event instanceof ApplicationEvent)) return;
        ExternalWindow externalWindow = null;
        switch (event.type) {
            case -21: {
                this.application.makeFirstRootView(this);
                if (externalWindow != null) {
                    externalWindow.didBecomeMain();
                }
                if (this._focusedView != null) {
                    this._focusedView.resumeFocus();
                    return;
                }
                break;
            }
            case -22: {
                externalWindow = this.externalWindow();
                if (externalWindow != null) {
                    externalWindow.didResignMain();
                }
                if (this._mainWindow != null) {
                    this._setMainWindow(null);
                }
                if (this._focusedView != null) {
                    this._focusedView._pauseFocus();
                    return;
                }
                break;
            }
            case -23: {
                if (this.isVisible) {
                    this.paint((ApplicationEvent)event);
                    return;
                }
                break;
            }
            case -24: {
                if (!this.bounds().equals(((ApplicationEvent)event).rect()) && this.bounds().contains(((ApplicationEvent)event).rect())) {
                    ApplicationEvent applicationEvent = new ApplicationEvent();
                    applicationEvent.data = ((ApplicationEvent)event).rect();
                    applicationEvent.type = -23;
                    applicationEvent.setProcessor(this);
                    if (this.application() != null && this.application().eventLoop() != null) {
                        this.application().eventLoop().addEvent(applicationEvent);
                    }
                }
                this.resize((ApplicationEvent)event);
                externalWindow = this.externalWindow();
                if (externalWindow != null) {
                    externalWindow.validateBounds();
                    return;
                }
                break;
            }
            case -28: {
                this.print((ApplicationEvent)event);
                return;
            }
        }
    }

    void setFocusedView(View view, boolean bl) {
        if (view != this._focusedView) {
            if (this._focusedView != null) {
                View view2 = this._focusedView;
                this._focusedView = null;
                if (bl) {
                    view2._stopFocus();
                } else {
                    view2._pauseFocus();
                }
            } else {
                this._focusedView = null;
            }
            if (this._focusedView == null) {
                this._focusedView = view;
                if (this._focusedView != null) {
                    this._focusedView._startFocus();
                }
            }
            Application.application().focusChanged(this._focusedView);
            Application.application().performCommandLater((Target)this, VALIDATE_SELECTED_VIEW, null, true);
        }
    }

    public void setFocusedView(View view) {
        this.setFocusedView(view, true);
    }

    public View focusedView() {
        return this._focusedView;
    }

    public void performCommand(String string, Object object) {
        if ("showFontChooser".equals(string)) {
            this.showFontChooser();
            return;
        }
        if ("showColorChooser".equals(string)) {
            this.showColorChooser();
            return;
        }
        if ("newFontSelection".equals(string)) {
            if (this.fontChooser != null) {
                this.fontChooser.setFont((Font)object);
                return;
            }
        } else {
            if (VALIDATE_SELECTED_VIEW.equals(string)) {
                this.validateSelectedView();
                return;
            }
            throw new NoSuchMethodError("unknown command: " + string);
        }
    }

    public boolean canPerformCommand(String string) {
        return _commands.contains((Object)string);
    }

    public void setColor(Color color) {
        this._backgroundColor = color;
    }

    public Color color() {
        return this._backgroundColor;
    }

    public void setImage(Image image) {
        this._image = image;
    }

    public Image image() {
        return this._image;
    }

    public void setImageDisplayStyle(int n) {
        if (n != 0 && n != 2 && n != 1) {
            throw new InconsistencyException("Unknown image display style: " + n);
        }
        this._imageDisplayStyle = n;
    }

    public int imageDisplayStyle() {
        return this._imageDisplayStyle;
    }

    public boolean isTransparent() {
        return false;
    }

    public void drawView(Graphics graphics) {
        if ((this._image == null || this._imageDisplayStyle == 0 && (this._image.width() < this.bounds.width || this._image.height() < this.bounds.height)) && this._backgroundColor != null) {
            graphics.setColor(this._backgroundColor);
            graphics.fillRect(graphics.clipRect());
        }
        if (this._image != null) {
            this._image.drawWithStyle(graphics, 0, 0, this.bounds.width, this.bounds.height, this._imageDisplayStyle);
        }
    }

    public void draw(Graphics graphics, Rect rect) {
        InternalWindow internalWindow;
        Vector vector = new Vector();
        int n = this.windows.count();
        while (n-- > 0) {
            internalWindow = (InternalWindow)this.windows.elementAt(n);
            if (!internalWindow.isDrawingEnabled()) continue;
            internalWindow.disableDrawing();
            vector.addElement((Object)internalWindow);
        }
        super.draw(graphics, rect);
        n = vector.count();
        while (n-- > 0) {
            internalWindow = (InternalWindow)vector.elementAt(n);
            internalWindow.reenableDrawing();
        }
    }

    View viewWithBuffer(View view, Rect rect) {
        View view2 = null;
        int n = view.subviewCount();
        if (n == 0) {
            return null;
        }
        Vector vector = view.subviews();
        Rect rect2 = Rect.newRect(0, 0, rect.width, rect.height);
        while (n-- > 0) {
            View view3 = (View)vector.elementAt(n);
            if (view3 instanceof InternalWindow || !view3.bounds.contains(rect)) continue;
            if (view3.isBuffered()) {
                Rect.returnRect(rect2);
                return view3;
            }
            view3.isTransparent();
            rect2.x = rect.x - view3.bounds.x;
            rect2.y = rect.y - view3.bounds.y;
            View view4 = this.viewWithBuffer(view3, rect2);
            if (view4 != null) {
                Rect.returnRect(rect2);
                return view4;
            }
            if (view2 == null) continue;
            Rect.returnRect(rect2);
            return view2;
        }
        Rect.returnRect(rect2);
        return null;
    }

    void redraw(Graphics graphics, Rect rect) {
        View view;
        Object object;
        InternalWindow internalWindow;
        Rect rect2 = Rect.newRect(0, 0, rect.width, rect.height);
        if (rect == null) {
            rect = new Rect(0, 0, this.bounds.width, this.bounds.height);
        }
        Vector vector = VectorCache.newVector();
        this.setRedrawTransparentWindows(false);
        int n = this.windows.count();
        boolean bl = false;
        int n2 = n;
        while (n2-- > 0 && !bl) {
            internalWindow = (InternalWindow)this.windows.elementAt(n2);
            object = this.absoluteWindowBounds(internalWindow);
            if (!((Rect)object).intersects(rect)) continue;
            vector.addElement((Object)internalWindow);
            if (internalWindow.isTransparent() || !((Rect)object).contains(rect)) continue;
            bl = true;
        }
        if (!bl) {
            view = this._viewForRect(rect, null);
            if (view != null) {
                this.convertRectToView(view, rect, rect2);
                graphics.pushState();
                graphics.translate(rect.x - rect2.x, rect.y - rect2.y);
                view.draw(graphics, rect2);
                graphics.popState();
            } else {
                this.draw(graphics, rect);
            }
        }
        n = vector.count();
        n2 = 0;
        while (n2 < n) {
            internalWindow = (InternalWindow)vector.elementAt(n2);
            object = internalWindow.superview();
            this.convertRectToView((View)object, rect, rect2);
            view = internalWindow._viewForRect(rect2, (View)object);
            if (view == null) {
                view = internalWindow;
            }
            this.convertRectToView(view, rect, rect2);
            graphics.pushState();
            graphics.translate(rect.x - rect2.x, rect.y - rect2.y);
            view.draw(graphics, rect2);
            graphics.popState();
            ++n2;
        }
        this.setRedrawTransparentWindows(true);
        Rect.returnRect(rect2);
        VectorCache.returnVector(vector);
    }

    public void redraw(Rect rect) {
        Graphics graphics = this.createGraphics();
        this.redraw(graphics, rect);
        graphics.dispose();
    }

    void redraw() {
        Graphics graphics = this.createGraphics();
        Rect rect = Rect.newRect(0, 0, this.bounds.width, this.bounds.height);
        this.redraw(graphics, rect);
        Rect.returnRect(rect);
        graphics.dispose();
    }

    synchronized void markDirty(View view) {
        if (this.dirtyViews != null) {
            this.dirtyViews.addElement((Object)view);
            return;
        }
        throw new InconsistencyException("Don't dirty a View while the list of dirty views is being drawn!");
    }

    synchronized void markClean(View view) {
        if (this.dirtyViews != null) {
            this.dirtyViews.removeElement((Object)view);
        }
    }

    public synchronized void resetDirtyViews() {
        Vector vector = this.dirtyViews;
        this.dirtyViews = null;
        int n = vector.count();
        int n2 = 0;
        while (n2 < n) {
            View view = (View)vector.elementAt(n2);
            view.setDirty(false);
            ++n2;
        }
        vector.removeAllElements();
        this.dirtyViews = vector;
    }

    public synchronized void drawDirtyViews() {
        int n = this.dirtyViews.count();
        if (n == 0) {
            return;
        }
        Vector vector = this.dirtyViews;
        try {
            View view;
            this.dirtyViews = null;
            Vector vector2 = new Vector(n);
            Rect rect = new Rect();
            int n2 = 0;
            while (n2 < n) {
                view = (View)vector.elementAt(n2);
                this.collectDirtyViews(view, vector2, rect);
                ++n2;
            }
            n = vector2.count();
            n2 = 0;
            while (n2 < n) {
                view = (View)vector2.elementAt(n2);
                view.draw(view.dirtyRect);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.dirtyViews = vector;
            this.resetDirtyViews();
            throw throwable;
        }
        Object var8_7 = null;
        this.dirtyViews = vector;
        this.resetDirtyViews();
    }

    void collectDirtyViews(View view, Vector vector, Rect rect) {
        View view2;
        View view3 = view2 = view;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        rect.setBounds(0, 0, view3.width(), view3.height());
        if (view.dirtyRect != null) {
            rect.intersectWith(view.dirtyRect);
        }
        if (rect.isEmpty()) {
            return;
        }
        do {
            n2 += view3.bounds.x;
            n4 += view3.bounds.y;
            rect.moveBy(view3.bounds.x, view3.bounds.y);
            view3 = view3.superview();
            if (view3 == null) continue;
            rect.intersectWith(0, 0, view3.width(), view3.height());
            if (rect.isEmpty()) {
                return;
            }
            if (!view3.isDirty()) continue;
            view2 = view3;
            n = n2;
            n3 = n4;
        } while (view3 != null && !(view3 instanceof InternalWindow));
        if (view != view2) {
            rect.moveBy(n - n2, n3 - n4);
            view2.addDirtyRect(rect);
        }
        if (!vector.containsIdentical((Object)view2)) {
            vector.addElement((Object)view2);
        }
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        return false;
    }

    public RootView rootView() {
        if (this.panel == null) {
            return super.rootView();
        }
        return this;
    }

    void setPanel(FoundationPanel foundationPanel) {
        this.panel = foundationPanel;
    }

    public FoundationPanel panel() {
        return this.panel;
    }

    Application application() {
        return this.application;
    }

    void setApplication(Application application) {
        this.application = application;
    }

    public void setWindowClipView(View view) {
        this._windowClipView = view;
    }

    public View windowClipView() {
        return this._windowClipView;
    }

    void addComponentView(AWTComponentView aWTComponentView) {
        if (this.componentViews == null) {
            this.componentViews = new Vector();
        }
        this.componentViews.addElement((Object)aWTComponentView);
        aWTComponentView.setComponentBounds();
        this.panel.add(aWTComponentView.component);
    }

    void removeComponentView(AWTComponentView aWTComponentView) {
        if (this.componentViews == null) {
            this.componentViews = new Vector();
        }
        this.componentViews.removeElement((Object)aWTComponentView);
        this.panel.remove(aWTComponentView.component);
    }

    private final void subviewDidResizeOrMove(View view) {
        KeyboardArrow keyboardArrow;
        View view2;
        if (this.componentViews != null) {
            int n = this.componentViews.count();
            int n2 = 0;
            while (n2 < n) {
                AWTComponentView aWTComponentView = (AWTComponentView)this.componentViews.elementAt(n2);
                if (aWTComponentView.descendsFrom(view)) {
                    aWTComponentView.setComponentBounds();
                }
                ++n2;
            }
        }
        this.createMouseEnterLater();
        if (this.application != null && (view2 = (keyboardArrow = this.application.keyboardArrow()).view()) != null && view2.rootView() == this) {
            this.updateArrowLocation(keyboardArrow);
        }
    }

    public void subviewDidResize(View view) {
        this.subviewDidResizeOrMove(view);
    }

    public void subviewDidMove(View view) {
        this.subviewDidResizeOrMove(view);
    }

    public boolean canDraw() {
        if (this.panel.getParent() == null) {
            return false;
        }
        return this.isVisible;
    }

    public Point mousePoint() {
        return new Point(this._mouseX, this._mouseY);
    }

    public boolean viewExcludedFromModalSession(View view) {
        if (view == null) {
            return true;
        }
        View view2 = Application.application().modalView();
        if (view2 != null && !view.descendsFrom(view2)) {
            return !(view instanceof DragView) && !(view instanceof InternalWindow);
        }
        return false;
    }

    public void setRedrawAll(boolean bl) {
        this.redrawAll = bl;
    }

    public boolean redrawAll() {
        return this.redrawAll;
    }

    Rect absoluteWindowBounds(InternalWindow internalWindow) {
        if (internalWindow.superview() != this) {
            return internalWindow.superview().convertRectToView(this, internalWindow.bounds);
        }
        return internalWindow.bounds;
    }

    void viewHierarchyChanged() {
        if (this._focusedView != null && !this._focusedView.descendsFrom(this)) {
            this.setFocusedView(null);
        }
        Application.application().performCommandLater((Target)this, VALIDATE_SELECTED_VIEW, null, true);
    }

    private boolean isInWindow(View view) {
        if (view == null) {
            return false;
        }
        if (view instanceof InternalWindow) {
            return true;
        }
        View view2 = view.superview();
        do {
            if (view2 == this) {
                return false;
            }
            if (!(view2 instanceof InternalWindow)) continue;
            return true;
        } while ((view2 = view2.superview()) != null);
        return false;
    }

    public boolean mouseStillDown() {
        return this.mouseDownCount > 0;
    }

    View rootViewFocusedView() {
        if (this._rootViewFocusedView != null) {
            if (this._rootViewFocusedView.descendsFrom(this)) {
                return this._rootViewFocusedView;
            }
            this._rootViewFocusedView = null;
        }
        return null;
    }

    public void setDefaultSelectedView(View view) {
        this._defaultSelectedView = view;
    }

    public View defaultSelectedView() {
        return this._defaultSelectedView;
    }

    public void selectView(View view, boolean bl) {
        View view2 = this.keyboardRootView();
        if (this.application != null && !this.application.isKeyboardUIEnabled() || this._selectedView == view2 || this._selectedView == null) {
            return;
        }
        if (bl) {
            this.setFocusedView(null);
        }
        if (this._focusedView == null && view.canBecomeSelectedView() && view.descendsFrom(view2)) {
            View view3 = view.superview();
            if (view3 != view2) {
                do {
                    if (!view3.hidesSubviewsFromKeyboard()) continue;
                    view = view3;
                } while ((view3 = view3.superview()) != view2);
            }
            this.makeSelectedView(view);
            return;
        }
        if (view2 instanceof RootView) {
            ((RootView)view2).setDefaultSelectedView(view);
            return;
        }
        if (view2 instanceof InternalWindow) {
            ((InternalWindow)view2).setDefaultSelectedView(view);
        }
    }

    public void selectViewAfter(View view) {
        View view2 = null;
        view2 = this.findNextView(view, this.keyboardRootView(), true);
        this.makeSelectedView(view2);
    }

    public void selectViewBefore(View view) {
        View view2 = null;
        view2 = this.findNextView(view, this.keyboardRootView(), false);
        this.makeSelectedView(view2);
    }

    void didBecomeFirstRootView() {
        ExternalWindow externalWindow = this.externalWindow();
        if (externalWindow != null) {
            externalWindow.didBecomeMain();
        }
        if (this._focusedView != null) {
            this._focusedView._startFocus();
            Application.application().focusChanged(this._focusedView);
        }
        this.application.performCommandLater((Target)this, VALIDATE_SELECTED_VIEW, null, true);
    }

    void didResignFirstRootView() {
        ExternalWindow externalWindow = this.externalWindow();
        if (externalWindow != null) {
            externalWindow.didResignMain();
        }
        if (this._mainWindow != null) {
            this._setMainWindow(null);
        }
        if (this._focusedView != null) {
            this._focusedView._pauseFocus();
        }
        this.application.performCommandLater((Target)this, VALIDATE_SELECTED_VIEW, null, true);
    }

    void makeSelectedView(View view) {
        if (this.application != null && this.application.isKeyboardUIEnabled()) {
            View view2 = this.keyboardRootView();
            if (view != this._selectedView) {
                if (this._selectedView != null) {
                    this._selectedView.willBecomeUnselected();
                    this._selectedView = null;
                }
                this._selectedView = view;
                if (this._selectedView != null) {
                    if (view2 instanceof RootView) {
                        ((RootView)view2).setDefaultSelectedView(this._selectedView);
                    } else if (view2 instanceof InternalWindow) {
                        ((InternalWindow)view2).setDefaultSelectedView(this._selectedView);
                    }
                    this._selectedView.scrollRectToVisible(new Rect(0, 0, this._selectedView.width(), this._selectedView.height()));
                    this._selectedView.willBecomeSelected();
                }
                this.validateKeyboardArrow();
            }
        }
    }

    void validateKeyboardArrow() {
        if (this.application != null && this.application.isKeyboardUIEnabled()) {
            View view = null;
            view = this._selectedView != null && this._selectedView.wantsKeyboardArrow() ? this._selectedView : (this._focusedView != null && this._focusedView.canBecomeSelectedView() && this._focusedView.wantsKeyboardArrow() ? this._focusedView : null);
            if (view != null) {
                this.showKeyboardArrowForView(view);
                return;
            }
            this.hideKeyboardArrow();
        }
    }

    void validateSelectedView() {
        if (this.application != null && !this.application.isKeyboardUIEnabled()) {
            return;
        }
        if (this._focusedView != null || this.application != null && this.application.firstRootView() != this) {
            if (this._selectedView != null) {
                this.makeSelectedView(null);
            }
        } else {
            View view;
            View view2 = this.keyboardRootView();
            if (this._selectedView != null && this._selectedView.descendsFrom(view2)) {
                boolean bl = false;
                if (!(this._selectedView instanceof InternalWindow) && !(this._selectedView instanceof RootView) || this._selectedView == view2) {
                    if (this._selectedView != view2) {
                        View view3 = this._selectedView.superview();
                        while (view3 != null && view3 != view2) {
                            if (view3.hidesSubviewsFromKeyboard()) {
                                bl = true;
                                break;
                            }
                            view3 = view3.superview();
                        }
                    }
                    if (!bl) {
                        return;
                    }
                    this.makeSelectedView(null);
                }
            }
            if ((view = view2 instanceof RootView ? ((RootView)view2).defaultSelectedView() : (view2 instanceof InternalWindow ? ((InternalWindow)view2).defaultSelectedView() : null)) != null && view.descendsFrom(view2)) {
                this.makeSelectedView(view);
            } else {
                this.selectNextSelectableView();
            }
        }
        this.validateKeyboardArrow();
    }

    void selectNextSelectableView() {
        View view = this.keyboardRootView();
        View view2 = null;
        view2 = this._selectedView != null && this._selectedView.descendsFrom(view) ? this.findNextView(this._selectedView, view, true) : this.findNextView(null, view, true);
        this.makeSelectedView(view2);
    }

    void selectPreviousSelectableView() {
        View view = this.keyboardRootView();
        View view2 = null;
        view2 = this._selectedView != null && this._selectedView.descendsFrom(view) ? this.findNextView(this._selectedView, view, false) : this.findNextView(null, view, false);
        this.makeSelectedView(view2);
    }

    boolean processKeyboardEvent(KeyEvent keyEvent, boolean bl) {
        View view;
        if (this.application != null && !this.application.isKeyboardUIEnabled() || this.subviews().count() == 0) {
            return false;
        }
        if (bl && !keyEvent.isControlKeyDown()) {
            return false;
        }
        if (!bl && keyEvent.isControlKeyDown()) {
            return false;
        }
        View view2 = this.keyboardRootView();
        this.validateSelectedView();
        if (!bl && (keyEvent.isTabKey() || keyEvent.isBackTabKey())) {
            if (keyEvent.isBackTabKey()) {
                this.selectPreviousSelectableView();
            } else {
                this.selectNextSelectableView();
            }
            return true;
        }
        KeyStroke keyStroke = new KeyStroke(keyEvent);
        if (this._selectedView != null) {
            if (this._selectedView.performCommandForKeyStroke(keyStroke, 0)) {
                return true;
            }
            if (this._selectedView != view2) {
                view = this._selectedView.superview();
                while (view != view2) {
                    if (view.performCommandForKeyStroke(keyStroke, 1)) {
                        return true;
                    }
                    view = view.superview();
                }
            }
        }
        view = view2;
        do {
            if (!(view = this.nextView(view, view2, true, true, false)).performCommandForKeyStroke(keyStroke, 1)) continue;
            return true;
        } while (view != view2);
        view = this;
        do {
            if (!(view = this.nextView(view, this, true, true, true)).performCommandForKeyStroke(keyStroke, 2)) continue;
            return true;
        } while (view != this);
        return false;
    }

    private View nextView(View view, View view2, boolean bl, boolean bl2, boolean bl3) {
        View view3 = null;
        if (view == view2 && bl) {
            Vector vector = view2.subviews();
            if (vector.count() > 0) {
                if (bl2) {
                    return view2.firstSubview();
                }
                return view2.lastSubview();
            }
            return null;
        }
        if (bl && (!view.hidesSubviewsFromKeyboard() || bl3 && view instanceof InternalWindow) && view.subviews().count() > 0) {
            if (bl2) {
                return view.firstSubview();
            }
            return view.lastSubview();
        }
        View view4 = view.superview();
        if (bl2 ? (view3 = view4.viewAfter(view)) != null : (view3 = view4.viewBefore(view)) != null) {
            return view3;
        }
        if (view4 == view2) {
            return view2;
        }
        return this.nextView(view4, view2, false, bl2, bl3);
    }

    private View findNextView(View view, View view2, boolean bl) {
        View view3;
        if (view2 == null) {
            return null;
        }
        if (view == null) {
            return view2;
        }
        View view4 = view3 = view;
        while ((view4 = this.nextView(view4, view2, true, bl, false)) != null && view4 != view3 && !view4.canBecomeSelectedView()) {
        }
        return view4;
    }

    private View keyboardRootView() {
        View view = Application.application().modalView();
        if (view != null && view.isInViewHierarchy()) {
            return view;
        }
        InternalWindow internalWindow = this.mainWindow();
        if (internalWindow != null) {
            return internalWindow;
        }
        if (this.application != null && this.application.firstRootView() != null) {
            return this.application.firstRootView();
        }
        return this;
    }

    void showKeyboardArrowForView(View view) {
        if (this.application != null) {
            KeyboardArrow keyboardArrow = this.application.keyboardArrow();
            if (keyboardArrow.view() == view) {
                return;
            }
            keyboardArrow.setRootView(this);
            keyboardArrow.setView(view);
            this.updateArrowLocation(keyboardArrow);
            keyboardArrow.show();
        }
    }

    void updateArrowLocation(KeyboardArrow keyboardArrow) {
        View view = keyboardArrow.view();
        int n = this.application.keyboardArrowPosition(view);
        Image image = this.application.keyboardArrowImage(n);
        Point point = this.application.keyboardArrowHotSpot(n);
        Point point2 = this.application.keyboardArrowLocation(view, n);
        point2.x -= point.x;
        point2.y -= point.y;
        if (this.windowClipView() != null) {
            this.convertPointToView(this.windowClipView(), point2, point2);
        }
        keyboardArrow.setImage(image);
        keyboardArrow.moveTo(point2.x, point2.y);
    }

    void hideKeyboardArrow() {
        KeyboardArrow keyboardArrow;
        if (this.application != null && (keyboardArrow = this.application.keyboardArrow()).rootView() == this) {
            keyboardArrow.hide();
            keyboardArrow.setRootView(null);
            keyboardArrow.setView(null);
        }
    }

    public boolean canBecomeSelectedView() {
        return true;
    }

    boolean wantsKeyboardArrow() {
        return false;
    }

    public void adjustForExpectedMouseDownCount() {
        if (!this.application.jdkMouseEventHackEnabled) {
            return;
        }
        if (this.mouseDownCount < 1) {
            MouseEvent mouseEvent = new MouseEvent(0L, -1, -1, -1, 0);
            while (this.mouseDownCount < 1) {
                this._mouseDown(mouseEvent);
            }
        }
    }

    static {
        _commands.addElement((Object)"showFontChooser");
        _commands.addElement((Object)"showColorChooser");
        _commands.addElement((Object)"newFontSelection");
        _commands.addElement((Object)VALIDATE_SELECTED_VIEW);
    }
}

