/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.CORBA;

import com.visigenic.vbroker.CORBA.BaseSocket;
import com.visigenic.vbroker.CORBA.IiopEndpoint;
import com.visigenic.vbroker.CORBA.ORB;
import com.visigenic.vbroker.IIOP.ProfileBody;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.util.Dictionary;
import java.util.Enumeration;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INTERNAL;

public class IiopStream {
    private ORB _orb;
    private boolean _isIncoming;
    private BaseSocket _socket;

    private static String check(ORB oRB, String string, int n) {
        if (oRB.boaInitialized() && oRB.isLocalPort(n) && oRB.isLocalHost(string)) {
            throw new INTERNAL("Should never establish a connection to myself");
        }
        if (oRB.securityRestricted()) {
            return oRB.locatorAddr();
        }
        return string;
    }

    static void removeEntry(ORB oRB, ProfileBody profileBody) {
        int n = oRB.getPort(profileBody);
        String string = profileBody.host;
        String string2 = IiopStream.check(oRB, string, n);
        Dictionary dictionary = oRB.sockets();
        synchronized (dictionary) {
            oRB.sockets().remove(new IiopEndpoint(string2, n));
            return;
        }
    }

    private void disconnect() {
        Dictionary dictionary = this._orb.sockets();
        synchronized (dictionary) {
            Enumeration enumeration = this._orb.sockets().keys();
            while (enumeration.hasMoreElements()) {
                IiopEndpoint iiopEndpoint = (IiopEndpoint)enumeration.nextElement();
                if (this._orb.sockets().get(iiopEndpoint) != this._socket) continue;
                this._orb.sockets().remove(iiopEndpoint);
                break;
            }
            return;
        }
    }

    public boolean isFrom(ProfileBody profileBody) {
        return this._socket.getPortNumber() == this._orb.getPort(profileBody) && this._socket.getHostName().equals(profileBody.host);
    }

    public static IiopStream connect(ORB oRB, ProfileBody profileBody) {
        int n = oRB.getPort(profileBody);
        String string = profileBody.host;
        String string2 = IiopStream.check(oRB, string, n);
        Dictionary dictionary = oRB.sockets();
        synchronized (dictionary) {
            IiopEndpoint iiopEndpoint = new IiopEndpoint(string2, n);
            BaseSocket baseSocket = (BaseSocket)oRB.sockets().get(iiopEndpoint);
            if (baseSocket == null) {
                baseSocket = BaseSocket.connect(oRB, string2, n);
                oRB.sockets().put(iiopEndpoint, baseSocket);
            } else {
                try {
                    baseSocket.getInputStream().available();
                }
                catch (IOException iOException) {
                    oRB.sockets().remove(iiopEndpoint);
                    IiopStream iiopStream = IiopStream.connect(oRB, profileBody);
                    Object var7_10 = null;
                    return iiopStream;
                }
            }
            IiopStream iiopStream = new IiopStream(oRB, baseSocket, false);
            Object var7_11 = null;
            return iiopStream;
        }
    }

    public static IiopStream accept(ORB oRB, ServerSocket serverSocket) {
        return new IiopStream(oRB, BaseSocket.accept(oRB, serverSocket), true);
    }

    public IiopStream(ORB oRB, BaseSocket baseSocket, boolean bl) {
        this._orb = oRB;
        this._isIncoming = bl;
        this._socket = baseSocket;
    }

    public void close() {
        this._socket.close();
    }

    public BaseSocket socket() {
        return this._socket;
    }

    public void socket(BaseSocket baseSocket) {
        this._socket = baseSocket;
    }

    public String toString() {
        String string = "IiopStream[";
        string = this._isIncoming ? String.valueOf(string) + "incoming" : String.valueOf(string) + "outgoing";
        return String.valueOf(string) + ",socket=" + this._socket + "]";
    }

    void read(byte[] byArray, int n, int n2) {
        try {
            InputStream inputStream = this._socket.getInputStream();
            while (n2 > 0) {
                int n3 = inputStream.read(byArray, n, n2);
                if (n3 == -1) {
                    throw new IOException("Peer disconnected socket");
                }
                n += n3;
                n2 -= n3;
            }
            return;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw new COMM_FAILURE(iOException.toString());
        }
    }

    void write(byte[] byArray, int n, int n2) {
        try {
            OutputStream outputStream = this._socket.getOutputStream();
            outputStream.write(byArray, n, n2);
            outputStream.flush();
            return;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw new COMM_FAILURE(iOException.toString());
        }
    }
}

