/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.DateUtil;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class DraginoProtocolDecoder
extends BaseHttpProtocolDecoder {
    public DraginoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        String content = request.content().toString(StandardCharsets.UTF_8);
        JsonObject json = Json.createReader((Reader)new StringReader(content)).readObject();
        String deviceId = json.getJsonObject("end_device_ids").getString("device_id");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, deviceId);
        if (deviceSession == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        JsonObject message = json.getJsonObject("uplink_message");
        JsonObject decoded = message.getJsonObject("decoded_payload");
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(DateUtil.parseDate(message.getString("received_at")));
        position.setValid(true);
        position.setLatitude(decoded.getJsonNumber("Latitude").doubleValue());
        position.setLongitude(decoded.getJsonNumber("Longitude").doubleValue());
        position.set("humidity", decoded.getJsonNumber("Hum").doubleValue());
        position.set("battery", decoded.getJsonNumber("BatV").doubleValue());
        position.set("temp1", decoded.getJsonNumber("Tem").doubleValue());
        if (Boolean.parseBoolean(decoded.getString("ALARM_status"))) {
            position.addAlarm("sos");
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return position;
    }
}

