/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.EditorOnlyDisplayer;
import org.netbeans.core.windows.view.ui.slides.SlideBar;
import org.openide.awt.StatusDisplayer;

final class AutoHideStatusText
implements ChangeListener,
Runnable {
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JLabel lblStatus = new JLabel();
    private String text;
    private final JPanel statusContainer;

    private AutoHideStatusText(JFrame jFrame, JPanel jPanel) {
        this.statusContainer = jPanel;
        Border border = UIManager.getBorder("Nb.ScrollPane.border");
        if (null == border) {
            border = BorderFactory.createEtchedBorder();
        }
        this.panel.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.lblStatus.setName("AutoHideStatusTextLabel");
        this.panel.add((Component)this.lblStatus, "Center");
        jFrame.getLayeredPane().add((Component)this.panel, (Object)101);
        StatusDisplayer.getDefault().addChangeListener((ChangeListener)this);
        jFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                AutoHideStatusText.this.run();
            }
        });
    }

    static void install(JFrame jFrame, JPanel jPanel) {
        new AutoHideStatusText(jFrame, jPanel);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.text = StatusDisplayer.getDefault().getStatusText();
        String string = this.lblStatus.getText();
        if (this.text == null ? string == null : this.text.equals(string)) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        this.lblStatus.setText(this.text);
        if (EditorOnlyDisplayer.getInstance().isActive()) {
            return;
        }
        if (null == this.text || this.text.isEmpty()) {
            this.panel.setVisible(false);
            Container container = this.panel.getParent();
            if (container instanceof JLayeredPane) {
                JLayeredPane jLayeredPane = (JLayeredPane)container;
                jLayeredPane.moveToBack(this.panel);
            }
        } else {
            JLayeredPane jLayeredPane;
            int n;
            this.panel.setVisible(true);
            Container container = this.panel.getParent();
            Dimension dimension = this.panel.getPreferredSize();
            Rectangle rectangle = container.getBounds();
            Component component = this.findSlideBar();
            if (null != component && (n = component.getWidth()) > 0) {
                rectangle.x += n + 10;
            }
            this.panel.setBounds(rectangle.x - 1, rectangle.y + rectangle.height - dimension.height + 1, dimension.width, dimension.height + 1);
            if (container instanceof JLayeredPane && (jLayeredPane = (JLayeredPane)container).getComponentZOrder(this.panel) >= 0) {
                jLayeredPane.moveToFront(this.panel);
            }
        }
    }

    private Component findSlideBar() {
        if (null == this.statusContainer) {
            return null;
        }
        for (Component component : this.statusContainer.getComponents()) {
            if (!(component instanceof SlideBar)) continue;
            return component;
        }
        return null;
    }
}

