/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.firewall;

import com.google.common.annotations.VisibleForTesting;
import com.ubnt.ace.F;
import com.ubnt.ace.api.OoOO.o0oo;
import com.ubnt.ace.api.null;
import com.ubnt.ace.api.validator.B;
import com.ubnt.data.FirewallGroup;
import com.ubnt.data.FirewallRule;
import com.ubnt.data.NetworkConf;
import com.ubnt.data.Setting;
import com.ubnt.data.X;
import com.ubnt.data.ooOO.E;
import com.ubnt.model.newsuper;
import com.ubnt.service.device.K;
import com.ubnt.service.devmgr.whileString;
import com.ubnt.service.firewall.O0oO;
import com.ubnt.service.firewall.P;
import com.ubnt.service.firewall.T;
import com.ubnt.service.system.W;
import com.ubnt.service.system.a;
import com.ubnt.service.system.mA;
import com.ubnt.service.system.setting.H;
import com.ubnt.service.system.setting.do;
import com.ubnt.service.trace.logerror.AnalyticsAppender;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class D
implements B<FirewallRule> {
    private static final Logger supersuper = mA.\u00d8o0000;
    private final a \u00f4O0000;
    private final do \u00f6O0000;
    private final K \u00f5O0000;
    private final W \u00d6O0000;

    public D(a a2, do do_, K k2, W w2) {
        this.\u00f4O0000 = a2;
        this.\u00f6O0000 = do_;
        this.\u00f5O0000 = k2;
        this.\u00d6O0000 = w2;
    }

    @Override
    public Class<FirewallRule> o00000() {
        return FirewallRule.class;
    }

    public void \u00f8\u00d30000(String string, @Nullable FirewallRule firewallRule, FirewallRule firewallRule2, X x2) {
        if (firewallRule2.getRuleset() == null || firewallRule2.getRuleIndex() <= 0 || !firewallRule2.hasAction()) {
            throw new null("api.err.FirewallRuleFieldsRequired", new Object[0]);
        }
        int n2 = firewallRule2.getRuleIndex();
        String string2 = firewallRule2.getRuleset();
        E e2 = new E._o().\u00d5O0000("site_id", string).\u00d2O0000("ruleset", this.\u00f4\u00d30000(string2).toArray()).\u00f400000();
        this.\u00f5O0000.supernew(string).ifPresent(device -> {
            if (!T.oO0000(device, firewallRule2)) {
                throw new P(n2, firewallRule2.getName());
            }
        });
        List<FirewallRule> list = this.\u00f4O0000.\u00d4o0000(FirewallRule.class, e2);
        if (firewallRule != null) {
            list.remove(firewallRule);
        }
        for (FirewallRule object2 : list) {
            if (object2.getRuleIndex() != n2) continue;
            throw new null("api.err.FirewallRuleIndexExisted", "rule_index", n2);
        }
        String string3 = firewallRule2.getProtocol();
        if (firewallRule2.isInvertedProtocolMatch()) {
            this.\u00d3\u00d40000(firewallRule2, string3);
        }
        Map<String, X> map = Map.of("destination", new X().append("firewallgroup_ids", firewallRule2.getDestinationFirewallGroupIds()).putIfPresent("address", firewallRule2.getDestinationAddress()).putIfPresent("address_v6", firewallRule2.getDestinationAddressV6()).putIfPresent("networkconf_id", firewallRule2.getDestinationNetworkConfId()).putIfPresent("port", firewallRule2.getDestinationPort()).putIfPresent("networkconf_type", firewallRule2.getDestinationNetworkConfType()), "source", new X().append("firewallgroup_ids", firewallRule2.getSourceFirewallGroupIds()).putIfPresent("address", firewallRule2.getSourceAddress()).putIfPresent("address_v6", firewallRule2.getSourceAddressV6()).putIfPresent("networkconf_id", firewallRule2.getSourceNetworkConfId()).putIfPresent("port", firewallRule2.getSourcePort()).putIfPresent("networkconf_type", firewallRule2.getSourceNetworkConfType()));
        for (X x3 : map.values()) {
            Object bl;
            String string4 = x3.getString("networkconf_id");
            String string5 = x3.getString("networkconf_type");
            String string6 = x3.getString("address");
            String string7 = x3.getString("address_v6");
            String string8 = x3.getString("port");
            List<String> list2 = x3.getList(String.class, "firewallgroup_ids", new ArrayList());
            if (!StringUtils.isBlank((CharSequence)string4)) {
                bl = this.\u00f4O0000.Oo0000(NetworkConf.class, E.\u00f400000(string4, string));
                if (bl == null) {
                    supersuper.error(AnalyticsAppender.SEND_TO_ANALYTICS, "Could not find NetworkConf by id '{}' and site id '{}' during firewall rule validation", (Object)string4, (Object)string);
                    throw new O0oO(firewallRule2.getName(), string4);
                }
                if (!((NetworkConf)bl).isLocalSiteNetwork()) {
                    throw new null("api.err.FirewallRuleInvalidNetworkType", new Object[0]);
                }
                if (firewallRule2.isIPv6Rule()) {
                    throw new null("api.err.FirewallRuleNetworkTypeInvalidForIpv6", new Object[0]);
                }
                if (StringUtils.isBlank((CharSequence)string5)) {
                    throw new null("api.err.FirewallRuleNetworkConfTypeRequired", "id", string4);
                }
            }
            if (!StringUtils.isBlank((CharSequence)string6)) {
                boolean bl2 = Pattern.matches("^([!][^!]*)$", string6);
                if (!bl2 && StringUtils.countMatches((CharSequence)string6, (CharSequence)"!") > 0) {
                    throw new null("api.err.FirewallRuleInvalidArgs", "args", string6);
                }
                X x4 = FirewallRule.parseAddressOptions(string6.replace("!", ""));
                if (x4 == null) {
                    throw new null("api.err.FirewallRuleInvalidArgs", "args", string6);
                }
            }
            if (!StringUtils.isBlank((CharSequence)string7)) {
                boolean bl3 = Pattern.matches("^([!][^!]*)$", string7);
                if (!bl3 && StringUtils.countMatches((CharSequence)string7, (CharSequence)"!") > 0) {
                    throw new null("api.err.FirewallRuleInvalidArgs", "args", string7);
                }
                if (!F.superString(string7) && !F.class(string7)) {
                    throw new null("api.err.FirewallRuleInvalidArgs", "args", string7);
                }
            }
            if (!StringUtils.isBlank((CharSequence)string8)) {
                boolean bl4 = Pattern.matches("^([!][^!]*)$", string8);
                if (!bl4 && StringUtils.countMatches((CharSequence)string8, (CharSequence)"!") > 0) {
                    throw new null("api.err.FirewallRuleInvalidArgs", "args", string8);
                }
                for (String string9 : string8.replace("!", "").split(",")) {
                    X x5 = FirewallRule.parsePortOptions(string9);
                    if (x5 == null) {
                        throw new null("api.err.FirewallRuleInvalidArgs", "args", string8);
                    }
                    String string10 = x5.getString("port_named_protocol");
                    if (StringUtils.isBlank((CharSequence)string10) || StringUtils.equals((CharSequence)string3, (CharSequence)string10)) continue;
                    throw new null("api.err.invalidName", "name", string10, "protocol", string3);
                }
                if (!(StringUtils.equals((CharSequence)newsuper.\u00d400000.toString(), (CharSequence)string3) || StringUtils.equals((CharSequence)newsuper.\u00d200000.toString(), (CharSequence)string3) || StringUtils.equals((CharSequence)newsuper.\u00d800000.toString(), (CharSequence)string3))) {
                    throw new null("api.err.invalidProtocolWithPortSetting", "protocol", string3, "port", string8);
                }
            }
            bl = new HashSet();
            for (String string11 : list2) {
                String string9;
                FirewallGroup firewallGroup = this.\u00f4O0000.Oo0000(FirewallGroup.class, E.\u00f400000(string11, string));
                if (firewallGroup == null) {
                    supersuper.error(AnalyticsAppender.SEND_TO_ANALYTICS, "Could not find FirewallGroup by id '{}' and site id '{}'", (Object)string11, (Object)string);
                    throw null.Oo0000;
                }
                string9 = firewallGroup.getString("group_type");
                if (bl.contains(string9)) {
                    throw new null("api.err.FirewallGroupTypeExists", "type", string9, "name", firewallGroup.getString("name"));
                }
                bl.add(string9);
            }
            if (bl.contains("port-group") && !StringUtils.isBlank((CharSequence)string8)) {
                throw new null("api.err.FirewallRuleCannotMixPortWithPortGroup", "port", string8);
            }
            if (bl.contains("address-group")) {
                if (!StringUtils.isBlank((CharSequence)string6)) {
                    throw new null("api.err.FirewallRuleCannotMixAddressWithAddressGroup", "address", string6);
                }
                if (!StringUtils.isBlank((CharSequence)string4)) {
                    throw new null("api.err.FirewallRuleCannotMixInterfaceWithAddressGroup", "id", string4);
                }
            }
            if (StringUtils.isBlank((CharSequence)string4) || StringUtils.isBlank((CharSequence)string6)) continue;
            throw new null("api.err.FirewallRuleCannotMixInterfaceWithAddress", "id", string4, "address", string6);
        }
        this.\u00d8\u00d30000(string, firewallRule2);
    }

    @VisibleForTesting
    private void \u00d3\u00d40000(FirewallRule firewallRule, String string2) {
        if (StringUtils.equals((CharSequence)"all", (CharSequence)string2) || StringUtils.equals((CharSequence)newsuper.\u00d800000.toString(), (CharSequence)string2)) {
            throw new null("api.err.FirewallRuleInvalidProtocol", "protocol", string2);
        }
        firewallRule.getDestinationPort().ifPresent(string -> {
            throw new null("api.err.InvertedProtocolWithPortNumber", "port", string);
        });
        firewallRule.getSourcePort().ifPresent(string -> {
            throw new null("api.err.InvertedProtocolWithPortNumber", "port", string);
        });
    }

    private List<String> \u00f4\u00d30000(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        if (this.\u00d6O0000.floatclass()) {
            whileString.\u00d800000(string2).ifPresent(string -> arrayList.add((String)string));
        }
        return arrayList;
    }

    @VisibleForTesting
    void \u00d8\u00d30000(String string, FirewallRule firewallRule) {
        Setting setting = this.\u00f6O0000.\u00d300000(H.supersuper, string);
        boolean bl = setting.is("direct_connect_enabled", false);
        if (firewallRule.isEnabled() && bl && this.\u00d5\u00d30000(string, firewallRule)) {
            throw new o0oo();
        }
    }

    public boolean \u00d5\u00d30000(String string, FirewallRule firewallRule) {
        return this.\u00f5\u00d30000(firewallRule) || this.o\u00d40000(string, firewallRule);
    }

    private boolean \u00f5\u00d30000(FirewallRule firewallRule) {
        return firewallRule.getDestinationPort().filter(string -> FirewallRule.containsAsDestinationPort(string, 443)).isPresent();
    }

    private boolean o\u00d40000(String string, FirewallRule firewallRule) {
        String string2 = String.valueOf(443);
        return firewallRule.getDestinationFirewallGroupIds().stream().anyMatch(string3 -> {
            E e2 = E.\u00f400000(string3, string);
            return this.\u00f4O0000.\u00d4o0000(FirewallGroup.class, e2).stream().anyMatch(firewallGroup -> firewallGroup.containsPort(string2));
        });
    }
}

