/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;
import org.vinniks.parsla.exception.GrammarException;
import org.vinniks.parsla.exception.ParsingException;
import org.vinniks.parsla.grammar.Grammar;
import org.vinniks.parsla.grammar.RuleItem;
import org.vinniks.parsla.grammar.TokenItem;
import org.vinniks.parsla.parser.AbstractCompiledTokenItem;
import org.vinniks.parsla.parser.AbstractParseTreeNode;
import org.vinniks.parsla.parser.CompiledIgnoredTokenItem;
import org.vinniks.parsla.parser.CompiledItem;
import org.vinniks.parsla.parser.CompiledOption;
import org.vinniks.parsla.parser.CompiledRegularTokenItem;
import org.vinniks.parsla.parser.CompiledRuleItem;
import org.vinniks.parsla.parser.LeftRecursionDetector;
import org.vinniks.parsla.parser.ParserOutput;
import org.vinniks.parsla.parser.ParserOutputListener;
import org.vinniks.parsla.parser.RuleParseTreeNode;
import org.vinniks.parsla.parser.TokenParseTreeNode;
import org.vinniks.parsla.tokenizer.Token;
import org.vinniks.parsla.tokenizer.TokenIterator;

public class Parser<P> {
    private final Grammar grammar;
    private final Set<String> ignoredTokenTypes;
    private Map<String, Collection<CompiledOption>> compiledRules;
    private CompiledRuleItem ignoredTokenRuleItem;

    protected Parser(@NonNull Grammar grammar, @NonNull Set<String> ignoredTokenTypes) {
        if (grammar == null) {
            throw new NullPointerException("grammar is marked non-null but is null");
        }
        if (ignoredTokenTypes == null) {
            throw new NullPointerException("ignoredTokenTypes is marked non-null but is null");
        }
        if (ignoredTokenTypes.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("Ignored token types must not contain nulls");
        }
        this.grammar = grammar;
        this.ignoredTokenTypes = Set.copyOf(ignoredTokenTypes);
        this.compileRules();
        this.createIgnoredTokenRuleItem();
        LeftRecursionDetector.detect(this.compiledRules);
    }

    public Parser(Grammar grammar) {
        this(grammar, Collections.emptySet());
    }

    public final void parse(@NonNull TokenIterator<P> tokenIterator, @NonNull String rootRuleName, @NonNull ParserOutputListener<P> outputListener) throws IOException {
        if (tokenIterator == null) {
            throw new NullPointerException("tokenIterator is marked non-null but is null");
        }
        if (rootRuleName == null) {
            throw new NullPointerException("rootRuleName is marked non-null but is null");
        }
        if (outputListener == null) {
            throw new NullPointerException("outputListener is marked non-null but is null");
        }
        CompiledRuleItem rootItem = new CompiledRuleItem(rootRuleName, true, this.getOptions(rootRuleName));
        ArrayList<Path> paths = new ArrayList<Path>();
        RuleLookAheadTreeNode ignoredTokenRuleNode = this.ignoredTokenRuleItem != null ? new RuleLookAheadTreeNode(null, this.ignoredTokenRuleItem, 2) : null;
        paths.add(new Path(this, null, (AbstractLookAheadTreeNode)new RuleLookAheadTreeNode(ignoredTokenRuleNode, rootItem, 1)));
        ArrayList nextPaths = new ArrayList();
        ParserOutput<P> output = new ParserOutput<P>(outputListener);
        while (tokenIterator.hasNext()) {
            Token token = tokenIterator.next();
            nextPaths.clear();
            paths.forEach(path -> this.findNextPaths((Path<?>)path, token, tokenIterator.position(), nextPaths));
            paths.clear();
            if (nextPaths.isEmpty()) {
                throw new ParsingException(String.format("unexpected %s", token), tokenIterator.position());
            }
            if (nextPaths.size() == 1) {
                Path nextPath = (Path)nextPaths.get(0);
                output.next((AbstractParseTreeNode<?, P>)nextPath.getParseTreeNode());
                if (nextPath.getLookAheadTreeNode() == null) continue;
                paths.add(new Path(this, null, nextPath.getLookAheadTreeNode()));
                continue;
            }
            paths.addAll(nextPaths);
        }
        if (!paths.isEmpty()) {
            ArrayList tailPaths = new ArrayList();
            paths.forEach(path -> this.findTails((Path<? extends AbstractParseTreeNode<?, P>>)path, tailPaths, tokenIterator.position()));
            if (tailPaths.isEmpty()) {
                throw new ParsingException("unexpected end of the input", tokenIterator.position());
            }
            if (tailPaths.size() > 1) {
                throw new ParsingException("Ambiguous parsing path detected", tokenIterator.position());
            }
            output.next((AbstractParseTreeNode<?, P>)((Path)tailPaths.get(0)).getParseTreeNode());
        }
        output.end();
    }

    private void compileRules() {
        this.compiledRules = new LinkedHashMap<String, Collection<CompiledOption>>();
        this.grammar.getOptions().forEach(option -> {
            if (!this.compiledRules.containsKey(option.getRuleName())) {
                this.compiledRules.put(option.getRuleName(), new ArrayList());
            }
        });
        this.grammar.getOptions().forEach(option -> {
            CompiledItem[] compiledItems = (CompiledItem[])StreamSupport.stream(option.getItems().spliterator(), false).map(item -> {
                if (item instanceof TokenItem) {
                    TokenItem tokenItem = (TokenItem)item;
                    return new CompiledRegularTokenItem(tokenItem.getElevation(), tokenItem.getTokenType(), tokenItem.isOutputType(), tokenItem.getTokenValue(), tokenItem.isOutputValue());
                }
                RuleItem ruleItem = (RuleItem)item;
                return new CompiledRuleItem(ruleItem.getRuleName(), ruleItem.isOutput(), this.getOptions(ruleItem.getRuleName()));
            }).toArray(CompiledItem[]::new);
            this.compiledRules.get(option.getRuleName()).add(new CompiledOption(option.isOutput(), compiledItems));
        });
    }

    private void createIgnoredTokenRuleItem() {
        if (!this.ignoredTokenTypes.isEmpty()) {
            ArrayList<CompiledOption> ignoredTokenOptions = new ArrayList<CompiledOption>();
            this.ignoredTokenRuleItem = new CompiledRuleItem(null, false, ignoredTokenOptions);
            ignoredTokenOptions.add(new CompiledOption(false, new CompiledItem[0]));
            ignoredTokenOptions.add(new CompiledOption(false, new CompiledItem[]{new CompiledIgnoredTokenItem(), this.ignoredTokenRuleItem}));
        }
    }

    private Collection<CompiledOption> getOptions(String ruleName) {
        return Optional.ofNullable(this.compiledRules.get(ruleName)).orElseThrow(() -> new GrammarException(String.format("Unknown grammar rule \"%s\"", ruleName)));
    }

    private void findNextPaths(Path<?> path, Token token, P position, List<Path<TokenParseTreeNode<P>>> nextPaths) {
        if (path.getLookAheadTreeNode() != null) {
            TokenLookAheadTreeNode tokenNode;
            int match;
            if (path.getLookAheadTreeNode() instanceof RuleLookAheadTreeNode) {
                RuleLookAheadTreeNode ruleNode = (RuleLookAheadTreeNode)path.getLookAheadTreeNode();
                ruleNode.explode(path.getParseTreeNode(), position).forEach(explodedPath -> this.findNextPaths((Path<?>)explodedPath, token, position, nextPaths));
            } else if (path.getLookAheadTreeNode() instanceof TokenLookAheadTreeNode && (match = ((AbstractCompiledTokenItem)(tokenNode = (TokenLookAheadTreeNode)path.getLookAheadTreeNode()).getItem()).match(token, this.ignoredTokenTypes)) > 0) {
                Path nextPath = tokenNode.save(path.getParseTreeNode(), token, position, match);
                if (!nextPaths.isEmpty() && nextPaths.get(0).getParseTreeNode().getMatch() < match) {
                    nextPaths.clear();
                }
                if (nextPaths.isEmpty() || nextPaths.get(0).getParseTreeNode().getMatch() == match) {
                    nextPaths.add(nextPath);
                }
            }
        }
    }

    private void findTails(Path<? extends AbstractParseTreeNode<?, P>> path, Collection<Path<?>> tailPaths, P position) {
        if (path.getLookAheadTreeNode() == null) {
            tailPaths.add(path);
        } else if (path.getLookAheadTreeNode() instanceof RuleLookAheadTreeNode) {
            RuleLookAheadTreeNode ruleNode = (RuleLookAheadTreeNode)path.getLookAheadTreeNode();
            ruleNode.explode(path.getParseTreeNode(), position).forEach(explodedPath -> this.findTails((Path<? extends AbstractParseTreeNode<?, P>>)explodedPath, tailPaths, position));
        }
    }

    @Generated
    public Grammar getGrammar() {
        return this.grammar;
    }

    @Generated
    public Set<String> getIgnoredTokenTypes() {
        return this.ignoredTokenTypes;
    }

    final class RuleLookAheadTreeNode
    extends AbstractLookAheadTreeNode<CompiledRuleItem> {
        private RuleLookAheadTreeNode(AbstractLookAheadTreeNode<?> parent, CompiledRuleItem item, int level) {
            super(Parser.this, parent, (CompiledItem)item, level);
        }

        private Stream<Path<?>> explode(AbstractParseTreeNode<?, P> parentParseTreeNode, P position) {
            return ((CompiledRuleItem)this.getItem()).getOptions().stream().map(option -> {
                AbstractLookAheadTreeNode explodedNode = this.getParent();
                for (CompiledItem item : option.getItems(true)) {
                    if (item instanceof AbstractCompiledTokenItem) {
                        AbstractCompiledTokenItem tokenItem = (AbstractCompiledTokenItem)item;
                        explodedNode = new TokenLookAheadTreeNode(explodedNode, tokenItem, this.getLevel() + 1);
                    } else {
                        CompiledRuleItem ruleItem = (CompiledRuleItem)item;
                        explodedNode = new RuleLookAheadTreeNode(explodedNode, ruleItem, this.getLevel() + 1);
                    }
                    if (!(item instanceof CompiledRegularTokenItem) || Parser.this.ignoredTokenRuleItem == null) continue;
                    explodedNode = new RuleLookAheadTreeNode(explodedNode, Parser.this.ignoredTokenRuleItem, this.getLevel() + 1);
                }
                return new Path(Parser.this, new RuleParseTreeNode<Object>(parentParseTreeNode, this.getLevel(), (CompiledRuleItem)this.getItem(), position, option.isOutput()), explodedNode);
            });
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    abstract class AbstractLookAheadTreeNode<T extends CompiledItem> {
        private final AbstractLookAheadTreeNode<?> parent;
        private final T item;
        private final int level;
        final /* synthetic */ Parser this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        @Generated
        private AbstractLookAheadTreeNode(AbstractLookAheadTreeNode<?> parent, T item, int level) {
            this.this$0 = (Parser)this$0;
            this.parent = parent;
            this.item = item;
            this.level = level;
        }

        @Generated
        protected AbstractLookAheadTreeNode<?> getParent() {
            return this.parent;
        }

        @Generated
        protected T getItem() {
            return this.item;
        }

        @Generated
        protected int getLevel() {
            return this.level;
        }
    }

    private static class Path<T extends AbstractParseTreeNode<?, P>> {
        private final T parseTreeNode;
        private final AbstractLookAheadTreeNode<?> lookAheadTreeNode;
        final /* synthetic */ Parser this$0;

        @Generated
        Path(T parseTreeNode, AbstractLookAheadTreeNode<?> lookAheadTreeNode) {
            this.this$0 = var1_1;
            this.parseTreeNode = parseTreeNode;
            this.lookAheadTreeNode = lookAheadTreeNode;
        }

        @Generated
        T getParseTreeNode() {
            return this.parseTreeNode;
        }

        @Generated
        AbstractLookAheadTreeNode<?> getLookAheadTreeNode() {
            return this.lookAheadTreeNode;
        }
    }

    final class TokenLookAheadTreeNode
    extends AbstractLookAheadTreeNode<AbstractCompiledTokenItem> {
        private TokenLookAheadTreeNode(AbstractLookAheadTreeNode<?> parent, AbstractCompiledTokenItem item, int level) {
            super(Parser.this, parent, (CompiledItem)item, level);
        }

        private Path<TokenParseTreeNode<P>> save(AbstractParseTreeNode<?, P> parentParseTreeNode, Token token, P position, int match) {
            return new Path(Parser.this, new TokenParseTreeNode(parentParseTreeNode, this.getLevel(), (AbstractCompiledTokenItem)this.getItem(), position, token, match), this.getParent());
        }
    }
}

