/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.grammar.serialization;

import java.io.IOException;
import java.io.Reader;
import org.vinniks.parsla.exception.GrammarException;
import org.vinniks.parsla.exception.ParsingException;
import org.vinniks.parsla.grammar.Grammar;
import org.vinniks.parsla.grammar.GrammarBuilder;
import org.vinniks.parsla.grammar.serialization.GrammarReader;
import org.vinniks.parsla.grammar.serialization.GrammarTokenizer;
import org.vinniks.parsla.grammar.serialization.StandardGrammarBuilder;
import org.vinniks.parsla.grammar.serialization.StandardIdentifierCharacterValidator;
import org.vinniks.parsla.parser.text.TextParser;
import org.vinniks.parsla.syntaxtree.SyntaxTreeNode;
import org.vinniks.parsla.tokenizer.text.TextPosition;
import org.vinniks.parsla.tokenizer.text.buffered.CharacterBufferProvider;

public final class StandardGrammarReader
implements GrammarReader {
    private static final int DEFAULT_CHARACTER_BUFFER_SIZE = 8192;
    private static final StandardGrammarReader INSTANCE = new StandardGrammarReader(() -> new char[8192]);
    private final TextParser parser;

    public static StandardGrammarReader instance() {
        return INSTANCE;
    }

    public static Grammar grammarGrammar() {
        return GrammarBuilder.grammar(GrammarBuilder.options(GrammarBuilder.option("options"), GrammarBuilder.option("options", GrammarBuilder.items(GrammarBuilder.rule("option"), GrammarBuilder.rule("options"))), GrammarBuilder.option("option", true, GrammarBuilder.items(GrammarBuilder.rule("output"), GrammarBuilder.rule("rule-name", true), GrammarBuilder.token("colon"), GrammarBuilder.rule("items", true), GrammarBuilder.token("semicolon"))), GrammarBuilder.option("output"), GrammarBuilder.option("output", true, GrammarBuilder.items(GrammarBuilder.token("gt"))), GrammarBuilder.option("rule-name", GrammarBuilder.items(GrammarBuilder.token("identifier", false, true))), GrammarBuilder.option("items", GrammarBuilder.items(GrammarBuilder.token("caret"))), GrammarBuilder.option("items", GrammarBuilder.items(GrammarBuilder.rule("item"), GrammarBuilder.rule("items-tail"))), GrammarBuilder.option("items-tail"), GrammarBuilder.option("items-tail", GrammarBuilder.items(GrammarBuilder.rule("item"), GrammarBuilder.rule("items-tail"))), GrammarBuilder.option("item", GrammarBuilder.items(GrammarBuilder.rule("token"))), GrammarBuilder.option("item", GrammarBuilder.items(GrammarBuilder.rule("rule"))), GrammarBuilder.option("token", true, GrammarBuilder.items(GrammarBuilder.token("left-curly-bracket"), GrammarBuilder.rule("token-type"), GrammarBuilder.rule("token-value"), GrammarBuilder.token("right-curly-bracket"), GrammarBuilder.rule("elevations", true))), GrammarBuilder.option("token-type", GrammarBuilder.items(GrammarBuilder.rule("output-type"), GrammarBuilder.rule("type"))), GrammarBuilder.option("output-type"), GrammarBuilder.option("output-type", true, GrammarBuilder.items(GrammarBuilder.token("gt"))), GrammarBuilder.option("type"), GrammarBuilder.option("type", true, GrammarBuilder.items(GrammarBuilder.token("identifier", false, true))), GrammarBuilder.option("token-value"), GrammarBuilder.option("token-value", GrammarBuilder.items(GrammarBuilder.token("comma"), GrammarBuilder.rule("output-value"), GrammarBuilder.rule("value"))), GrammarBuilder.option("output-value"), GrammarBuilder.option("output-value", true, GrammarBuilder.items(GrammarBuilder.token("gt"))), GrammarBuilder.option("value"), GrammarBuilder.option("value", true, GrammarBuilder.items(GrammarBuilder.token("string", false, true))), GrammarBuilder.option("elevations"), GrammarBuilder.option("elevations", GrammarBuilder.items(GrammarBuilder.rule("elevation", true), GrammarBuilder.rule("elevations"))), GrammarBuilder.option("elevation", GrammarBuilder.items(GrammarBuilder.token("exclamation"))), GrammarBuilder.option("rule", true, GrammarBuilder.items(GrammarBuilder.rule("output"), GrammarBuilder.rule("name", true))), GrammarBuilder.option("name", GrammarBuilder.items(GrammarBuilder.token("identifier", false, true)))));
    }

    public StandardGrammarReader(CharacterBufferProvider characterBufferProvider) {
        this.parser = new TextParser(StandardGrammarReader.grammarGrammar(), new GrammarTokenizer(false, new StandardIdentifierCharacterValidator(), characterBufferProvider));
    }

    @Override
    public Grammar read(Reader reader) throws IOException {
        try {
            SyntaxTreeNode<TextPosition> syntaxTree = this.parser.parse(reader, "options");
            return StandardGrammarBuilder.build(syntaxTree);
        }
        catch (ParsingException e) {
            throw new GrammarException("failed to read standard grammar", e);
        }
    }
}

