/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;

public final class NanoClock
extends Clock
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long EPOCH_NANOS = System.currentTimeMillis() * 1000000L;
    private static final long NANO_START = System.nanoTime();
    private static final long OFFSET_NANOS = EPOCH_NANOS - NANO_START;
    private static final NanoClock UTC_INSTANCE = new NanoClock(ZoneOffset.UTC);
    private static final NanoClock DEFAULT_INSTANCE = new NanoClock(ZoneId.systemDefault());
    public static final long NANOS_PER_SECOND = 1000000000L;
    private final ZoneId _zone;

    private NanoClock(ZoneId zone) {
        this._zone = Objects.requireNonNull(zone, "zone");
    }

    @Override
    public ZoneId getZone() {
        return this._zone;
    }

    @Override
    public NanoClock withZone(ZoneId zone) {
        return zone.equals(this._zone) ? this : new NanoClock(zone);
    }

    @Override
    public long millis() {
        return System.currentTimeMillis();
    }

    public long nanos() {
        return System.nanoTime() + OFFSET_NANOS;
    }

    @Override
    public Instant instant() {
        long now = this.nanos();
        return Instant.ofEpochSecond(now / 1000000000L, now % 1000000000L);
    }

    @Override
    public int hashCode() {
        return this._zone.hashCode() + 11;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof NanoClock && ((NanoClock)obj)._zone.equals(this._zone);
    }

    public String toString() {
        return "NanoClock[" + this._zone + "]";
    }

    public static NanoClock system(ZoneId zone) {
        return new NanoClock(zone);
    }

    public static NanoClock systemUTC() {
        return UTC_INSTANCE;
    }

    public static NanoClock systemDefaultZone() {
        return DEFAULT_INSTANCE;
    }
}

