/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import java.io.Serializable;

public final class DoubleRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double _min;
    private final double _max;

    private DoubleRange(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("Min greater than max: %s > %s", min, max));
        }
        this._min = min;
        this._max = max;
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public static DoubleRange of(double min, double max) {
        return new DoubleRange(min, max);
    }

    public int hashCode() {
        int hash = 17;
        hash += 31 * Double.hashCode(this._max) + 37;
        return hash += 31 * Double.hashCode(this._min) + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DoubleRange && Double.compare(this._min, ((DoubleRange)obj)._min) == 0 && Double.compare(this._max, ((DoubleRange)obj)._max) == 0;
    }

    public String toString() {
        return "[" + this._min + ", " + this._max + "]";
    }
}

