/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.stat;

import io.jenetics.stat.DoubleMomentStatistics;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collector;

public final class DoubleMoments
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long _count;
    private final double _min;
    private final double _max;
    private final double _sum;
    private final double _mean;
    private final double _variance;
    private final double _skewness;
    private final double _kurtosis;

    private DoubleMoments(long count, double min, double max, double sum, double mean, double variance, double skewness, double kurtosis) {
        this._count = count;
        this._min = min;
        this._max = max;
        this._sum = sum;
        this._mean = mean;
        this._variance = variance;
        this._skewness = skewness;
        this._kurtosis = kurtosis;
    }

    public long getCount() {
        return this._count;
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public double getSum() {
        return this._sum;
    }

    public double getMean() {
        return this._mean;
    }

    public double getVariance() {
        return this._variance;
    }

    public double getSkewness() {
        return this._skewness;
    }

    public double getKurtosis() {
        return this._kurtosis;
    }

    public int hashCode() {
        int hash = 17;
        hash = (int)((long)hash + (33L * this._count + 37L));
        hash += 33 * Double.hashCode(this._sum) + 37;
        hash += 33 * Double.hashCode(this._min) + 37;
        hash += 33 * Double.hashCode(this._max) + 37;
        hash += 33 * Double.hashCode(this._mean) + 37;
        hash += 33 * Double.hashCode(this._variance) + 37;
        hash += 33 * Double.hashCode(this._skewness) + 37;
        return hash += 33 * Double.hashCode(this._kurtosis) + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DoubleMoments && this._count == ((DoubleMoments)obj)._count && Double.compare(this._sum, ((DoubleMoments)obj)._sum) == 0 && Double.compare(this._min, ((DoubleMoments)obj)._min) == 0 && Double.compare(this._max, ((DoubleMoments)obj)._max) == 0 && Double.compare(this._mean, ((DoubleMoments)obj)._mean) == 0 && Double.compare(this._variance, ((DoubleMoments)obj)._variance) == 0 && Double.compare(this._skewness, ((DoubleMoments)obj)._skewness) == 0 && Double.compare(this._kurtosis, ((DoubleMoments)obj)._kurtosis) == 0;
    }

    public String toString() {
        return String.format("DoubleMoments[N=%d, \u2227=%s, \u2228=%s, \u03a3=%s, \u03bc=%s, s\u00b2=%s, S=%s, K=%s]", this.getCount(), this.getMin(), this.getMax(), this.getSum(), this.getMean(), this.getVariance(), this.getSkewness(), this.getKurtosis());
    }

    public static DoubleMoments of(long count, double min, double max, double sum, double mean, double variance, double skewness, double kurtosis) {
        return new DoubleMoments(count, min, max, sum, mean, variance, skewness, kurtosis);
    }

    public static DoubleMoments of(DoubleMomentStatistics statistics) {
        return new DoubleMoments(statistics.getCount(), statistics.getMin(), statistics.getMax(), statistics.getSum(), statistics.getMean(), statistics.getVariance(), statistics.getSkewness(), statistics.getKurtosis());
    }

    public static <N extends Number> Collector<N, ?, DoubleMoments> toDoubleMoments() {
        return DoubleMoments.toDoubleMoments(Number::doubleValue);
    }

    public static <T> Collector<T, ?, DoubleMoments> toDoubleMoments(ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return Collector.of(DoubleMomentStatistics::new, (a, b) -> a.accept(mapper.applyAsDouble(b)), DoubleMomentStatistics::combine, DoubleMoments::of, new Collector.Characteristics[0]);
    }
}

