/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.CharacterGene;
import io.jenetics.VariableChromosome;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.internal.util.IntRef;
import io.jenetics.internal.util.reflect;
import io.jenetics.util.CharSeq;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import io.jenetics.util.MSeq;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CharacterChromosome
extends VariableChromosome<CharacterGene>
implements CharSequence,
Serializable {
    private static final long serialVersionUID = 3L;
    private transient CharSeq _validCharacters;

    protected CharacterChromosome(ISeq<CharacterGene> genes, IntRange lengthRange) {
        super(genes, lengthRange);
        this._validCharacters = ((CharacterGene)genes.get(0)).getValidCharacters();
    }

    public CharacterChromosome(CharSeq validCharacters, IntRange lengthRange) {
        this(CharacterGene.seq(validCharacters, lengthRange), lengthRange);
        this._valid = true;
    }

    public CharacterChromosome(CharSeq validCharacters, int length) {
        this(validCharacters, IntRange.of(length));
    }

    @Override
    public char charAt(int index) {
        return ((CharacterGene)this.getGene(index)).charValue();
    }

    @Override
    public CharacterChromosome subSequence(int start, int end) {
        return new CharacterChromosome((ISeq<CharacterGene>)this._genes.subSeq(start, end), this.lengthRange());
    }

    public CharacterChromosome newInstance(ISeq<CharacterGene> genes) {
        return new CharacterChromosome(genes, this.lengthRange());
    }

    @Override
    public CharacterChromosome newInstance() {
        return new CharacterChromosome(this._validCharacters, this.lengthRange());
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).and(this._validCharacters).value();
    }

    @Override
    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(cc -> super.equals(obj) && Equality.eq(this._validCharacters, cc._validCharacters));
    }

    @Override
    public String toString() {
        return this.toSeq().stream().map(Object::toString).collect(Collectors.joining());
    }

    public char[] toArray(char[] array2) {
        char[] a = array2.length >= this.length() ? array2 : new char[this.length()];
        int i = this.length();
        while (--i >= 0) {
            a[i] = this.charAt(i);
        }
        return a;
    }

    public char[] toArray() {
        return this.toArray(new char[this.length()]);
    }

    public static CharacterChromosome of(IntRange lengthRange) {
        return new CharacterChromosome(CharacterGene.seq(CharacterGene.DEFAULT_CHARACTERS, lengthRange), lengthRange);
    }

    public static CharacterChromosome of(int length) {
        return new CharacterChromosome(CharacterGene.seq(CharacterGene.DEFAULT_CHARACTERS, IntRange.of(length)), IntRange.of(length));
    }

    public static CharacterChromosome of(String alleles, CharSeq validChars) {
        IntRef index = new IntRef();
        Supplier<CharacterGene> geneFactory = () -> CharacterGene.of(alleles.charAt(index.value++), validChars);
        ISeq<CharacterGene> genes = MSeq.ofLength(alleles.length()).fill(geneFactory).toISeq();
        return new CharacterChromosome(genes, IntRange.of(alleles.length()));
    }

    public static CharacterChromosome of(String alleles) {
        return CharacterChromosome.of(alleles, CharacterGene.DEFAULT_CHARACTERS);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.length());
        out.writeObject(this._validCharacters);
        for (CharacterGene gene : this._genes) {
            out.writeChar(gene.getAllele().charValue());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int length = in.readInt();
        this._validCharacters = (CharSeq)in.readObject();
        MSeq<CharacterGene> genes = MSeq.ofLength(length);
        for (int i = 0; i < length; ++i) {
            CharacterGene gene = CharacterGene.of(in.readChar(), this._validCharacters);
            genes.set(i, gene);
        }
        reflect.setField(this, "_genes", genes.toISeq());
    }
}

