/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.device;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.data.DeviceType;
import com.ubnt.model.L.A.ooOO;
import com.ubnt.model.L.B;
import com.ubnt.model.L.R;
import com.ubnt.model.L.for;
import com.ubnt.model.api.SearchTag;
import com.ubnt.model.api.device.DeviceIconInfoDto;
import com.ubnt.model.api.device.ImmutableClientDeviceDto;
import com.ubnt.model.api.device.UnifiDeviceDto;
import com.ubnt.model.api.device.UplinkDto;
import com.ubnt.model.api.device.UpsDeviceDto;
import com.ubnt.return.C;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableClientDeviceDto.class)
@Value.Immutable
@C
public abstract class ClientDeviceDto
implements UnifiDeviceDto {
    @JsonProperty(value="type")
    public abstract Optional<DeviceType> type();

    @JsonProperty(value="icon_resolutions")
    public abstract List<List<Integer>> iconResolutions();

    @JsonProperty(value="icon_filename")
    public abstract String iconFilename();

    @JsonProperty(value="icons")
    public abstract List<DeviceIconInfoDto> icons();

    @Override
    public abstract int state();

    @Override
    public for unifiDeviceType() {
        return for.\u00d300000;
    }

    @JsonProperty(value="is_wired")
    public abstract boolean isWired();

    @JsonProperty(value="wired_speed_megabits_per_second")
    public abstract Optional<Integer> wiredSpeedMegabitsPerSecond();

    @JsonProperty(value="firmware_status")
    public abstract Optional<R> firmwareStatus();

    @JsonProperty(value="essid")
    public abstract Optional<String> essid();

    @JsonProperty(value="rate_imbalance")
    @Schema(description="Imbalance in percent between rate of the client and its uplink. Possible values [-100;100]. 0 indicates perfect balance, negative values - higher client rate. Since 7.3.26", example="-40")
    public abstract Optional<Integer> rateImbalance();

    @JsonProperty(value="uplink_mac")
    public abstract String uplinkMac();

    @JsonProperty(value="last_uplink")
    public abstract Optional<UplinkDto> lastUplink();

    @JsonProperty(value="uplink_radio_band")
    public abstract Optional<ooOO> uplinkRadioBand();

    @JsonProperty(value="view_in_application")
    public abstract boolean viewInApplication();

    @JsonProperty(value="tags")
    public abstract Set<SearchTag> tags();

    public static ImmutableClientDeviceDto.Builder builder() {
        return ImmutableClientDeviceDto.builder();
    }

    public static ClientDeviceDto of(B b2) {
        return ClientDeviceDto.of(b2, null);
    }

    public static ClientDeviceDto of(B b2, @Nullable DeviceType deviceType) {
        return ClientDeviceDto.builder().id(b2.\u00d6O0000()).mac(b2.\u00d500000()).type(Optional.ofNullable(deviceType)).name(b2.oO0000()).state(b2.classsuper()).isDefault(b2.\u00d200000()).modelShortname(b2.void()).ipAddress(b2.oo0000()).experience(b2.\u00f5O0000()).version(b2.\u00d400000()).displayableVersion(b2.public()).firmwareStatus(b2.publicnull()).usageBytes(b2.Oo0000()).downloadSpeedBytesPerSecond(b2.\u00d4O0000()).uploadSpeedBytesPerSecond(b2.\u00f4O0000()).uptimeSeconds(b2.\u00d600000()).iconFilename(b2.O\u00f80000()).iconResolutions(b2.classint()).icons(ClientDeviceDto.\u00d4\u00d80000(b2)).productLine(b2.\u00f500000()).isWired(b2.\u00d6\u00f80000()).wiredSpeedMegabitsPerSecond(b2.O0O000()).lastSeenTimestampSeconds(b2.\u00f600000()).essid(b2.\u00f5\u00f80000()).rateImbalance(b2.OOO000()).connectionNetworkId(b2.supersuper()).connectionNetworkName(b2.Object()).uplinkMac(b2.\u00f4\u00f80000()).lastUplink(UplinkDto.of(b2.\u00d2O0000())).ipv4ActiveLeaseExpirationTimestampSeconds(b2.\u00d2o0000()).lastConnectionNetworkId(b2.OO0000()).lastConnectionNetworkName(b2.\u00f6O0000()).uplinkRadioBand(b2.\u00d4\u00f80000()).viewInApplication(b2.\u00f50O000()).tags(b2.\u00f4\u00f60000()).upsDevice(b2.\u00f400000().map(UpsDeviceDto::of)).gracefulShutdownTriggeredByPairedUpsAt(b2.float()).build();
    }

    private static List<DeviceIconInfoDto> \u00d4\u00d80000(B b2) {
        return b2.\u00d5\u00f80000().stream().map(DeviceIconInfoDto::of).collect(Collectors.toList());
    }
}

