/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.auth.eap.tls;

import com.axlradius.misc.StackTrace;
import com.axlradius.radclient4.auth.eap.Entity;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TLSParameters {
    public static final int HEADER_LENGTH = 5;
    public static final int MAX_PLAINTEXT_SIZE = 16384;
    public static final int MAX_COMPRESSEDTEXT_SIZE = 17408;
    public static final int MAX_CIPHERTEXT_SIZE = 18432;
    private String e;
    private X509Certificate[] c;
    private X509Certificate a;
    private Key a;
    private Entity a;
    private int Z;
    private List<CRL> a;
    private KeyPair a;
    private KeyStore a;

    public final void setCertificates(X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        int n2 = x509CertificateArray.length;
        if (this.getEntity() == Entity.Server && n2 == 0) {
            throw new IllegalArgumentException("No certificates provided. Anonymous servers are not supported.");
        }
        this.c = new X509Certificate[n2 - 1];
        if (n2 > 1) {
            System.arraycopy(x509CertificateArray, 0, this.c, 0, this.c.length);
        }
        this.a = x509CertificateArray[this.c.length];
        this.a = privateKey;
    }

    public final void setKeyStore(String object, char[] object2, char[] cArray) throws IOException {
        Object object3;
        if (object2 == null) {
            object2 = new char[]{};
        }
        if (cArray == null) {
            cArray = new char[]{};
        }
        this.e = object;
        object = this;
        if (((TLSParameters)object).e == null) {
            throw new IOException("KeyStore path is null.");
        }
        Object object4 = object;
        char[] cArray2 = object2;
        object2 = object4;
        if (((TLSParameters)object4).a == null) {
            try {
                object2.a = KeyStore.getInstance(KeyStore.getDefaultType());
                object3 = new BufferedInputStream(new FileInputStream(object2.e));
                object2.a.load((InputStream)object3, cArray2);
                ((BufferedInputStream)object3).close();
            }
            catch (CertificateException certificateException) {
                System.out.println("initKeyStore: CertificateException message = [" + certificateException.getMessage() + "]");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                System.out.println("initKeyStore: NoSuchAlgorithmException message = [" + noSuchAlgorithmException.getMessage() + "]");
            }
            catch (KeyStoreException keyStoreException) {
                System.out.println("initKeyStore: KeyStoreException message = [" + keyStoreException.getMessage() + "]");
                throw new IOException(keyStoreException.getMessage());
            }
        }
        try {
            int n2 = 0;
            int n3 = 0;
            ((TLSParameters)object).c = null;
            object3 = ((TLSParameters)object).a.aliases();
            while (object3.hasMoreElements()) {
                String string = (String)object3.nextElement();
                if (((TLSParameters)object).a.entryInstanceOf(string, KeyStore.TrustedCertificateEntry.class)) {
                    ((TLSParameters)object).a = (X509Certificate)((TLSParameters)object).a.getCertificate(string);
                    if (((TLSParameters)object).a != null) {
                        ++n2;
                        continue;
                    }
                }
                if (!((TLSParameters)object).a.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class)) continue;
                ((TLSParameters)object).a = ((TLSParameters)object).a.getKey(string, cArray);
                Certificate[] certificateArray = ((TLSParameters)object).a.getCertificateChain(string);
                if (certificateArray == null) continue;
                ((TLSParameters)object).c = new X509Certificate[certificateArray.length];
                for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                    ((TLSParameters)object).c[i2] = (X509Certificate)certificateArray[i2];
                }
                ((TLSParameters)object).a = ((TLSParameters)object).a.getKey(string, cArray);
                ++n3;
            }
            if (((TLSParameters)object).getEntity() == Entity.Client) {
                if (n3 > 1) {
                    throw new IOException("More than one certificate chain is present - only one is allowed in the KeyStore.");
                }
                if (n2 > 1) {
                    throw new IOException("More than one CA certificate is present - only one is allowed in the KeyStore.");
                }
                if (n2 == 0) {
                    throw new IOException("Missing root (CA) certificate in KeyStore.");
                }
            } else {
                if (n3 > 1) {
                    throw new IOException("More than one certificate chain is present - only one is allowed in the KeyStore.");
                }
                if (n3 == 0) {
                    throw new IOException("Missing server certificate chain in the KeyStore.");
                }
                if (n2 > 1) {
                    throw new IOException("More than one CA certificate is present - only one is allowed in the KeyStore.");
                }
                if (n2 == 0) {
                    throw new IOException("Missing root (CA) certificate in KeyStore.");
                }
            }
            return;
        }
        catch (Exception exception) {
            object2 = exception;
            exception.printStackTrace();
            System.exit(1);
            new StackTrace();
            System.out.println("extractKeyStore: Stacktrace:\n" + StackTrace.getStackTrace((Throwable)object2));
            throw new IOException(object2.getMessage());
        }
    }

    public X509Certificate[] getCertificateChain() {
        return this.c;
    }

    public X509Certificate getRootCertificate() {
        return this.a;
    }

    public PrivateKey getPrivateKey() {
        return (PrivateKey)this.a;
    }

    public final KeyStore getKeyStore() {
        return this.a;
    }

    public final void setEntity(Entity entity) {
        this.a = entity;
    }

    public final Entity getEntity() {
        return this.a;
    }

    public final void setMaximumEAPDataSize(int n2) {
        this.Z = n2;
    }

    public final int getMaximumEAPDataSize() {
        return this.Z;
    }

    public final void verify() throws IllegalArgumentException {
        if (this.getEntity() == Entity.Server && (this.e == null || this.e.length() == 0)) {
            throw new IllegalArgumentException("Missing key store path to certificate chain");
        }
    }

    public final void setCRL(List<CRL> list) {
        this.a = list;
    }

    public final List<CRL> getCRL() {
        if (this.a == null) {
            return new ArrayList<CRL>();
        }
        return this.a;
    }

    public final void setDH(KeyPair keyPair) {
        this.a = keyPair;
    }

    public final KeyPair getDH() {
        return this.a;
    }

    public final DHPublicKey getDHPublic() {
        return (DHPublicKey)this.a.getPublic();
    }

    public final DHPrivateKey getDHPrivate() {
        return (DHPrivateKey)this.a.getPrivate();
    }

    public final KeyPair readDHFile(String string, char[] cArray) throws IOException {
        return C.readDHFile(string, cArray);
    }

    public static final KeyPair createDHKeyPair(int n2) throws InvalidParameterException, IOException {
        return C.createDHKeyPair(n2);
    }

    public static final void createDHKeyFile(File file, KeyPair keyPair, byte[] byArray) throws Exception {
        C.createDHKeyFile(file, keyPair, byArray);
    }

    public final String getSubjectName() throws Exception {
        if (this.c == null) {
            return null;
        }
        String[] stringArray = this.c[0].getSubjectDN().getName().split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].startsWith("CN=")) continue;
            System.out.println("getSubjectName: CN = " + stringArray[i2].substring(3));
            return stringArray[i2].substring(3);
        }
        return null;
    }
}

