/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.Function;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListCollectionNamesIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.internal.ListCollectionsIterableImpl;
import com.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

final class ListCollectionNamesIterableImpl
implements ListCollectionNamesIterable {
    private final ListCollectionsIterableImpl<BsonDocument> wrapped;
    private final MongoIterable<String> wrappedWithMapping;

    ListCollectionNamesIterableImpl(ListCollectionsIterableImpl<BsonDocument> wrapped) {
        this.wrapped = wrapped;
        this.wrappedWithMapping = wrapped.map(collectionDoc -> collectionDoc.getString((Object)"name").getValue());
    }

    @Override
    public ListCollectionNamesIterable filter(@Nullable Bson filter) {
        this.wrapped.filter(filter);
        return this;
    }

    @Override
    public ListCollectionNamesIterable maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListCollectionNamesIterable batchSize(int batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    @Override
    public ListCollectionNamesIterable comment(@Nullable String comment) {
        this.wrapped.comment(comment);
        return this;
    }

    @Override
    public ListCollectionNamesIterable comment(@Nullable BsonValue comment) {
        this.wrapped.comment(comment);
        return this;
    }

    @Override
    public ListCollectionNamesIterable authorizedCollections(boolean authorizedCollections) {
        this.wrapped.authorizedCollections(authorizedCollections);
        return this;
    }

    @Override
    public MongoCursor<String> iterator() {
        return this.wrappedWithMapping.iterator();
    }

    @Override
    public MongoCursor<String> cursor() {
        return this.wrappedWithMapping.cursor();
    }

    @Override
    @Nullable
    public String first() {
        return this.wrappedWithMapping.first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<String, U> mapper) {
        return this.wrappedWithMapping.map(mapper);
    }

    @Override
    public <A extends Collection<? super String>> A into(A target) {
        return this.wrappedWithMapping.into(target);
    }

    ListCollectionsIterableImpl<BsonDocument> getWrapped() {
        return this.wrapped;
    }
}

