/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.messaging.StompSubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;

public class WebSocketMessageBrokerStats
implements SmartInitializingSingleton {
    private static final Log logger = LogFactory.getLog(WebSocketMessageBrokerStats.class);
    @Nullable
    private SubProtocolWebSocketHandler webSocketHandler;
    @Nullable
    private StompSubProtocolHandler stompSubProtocolHandler;
    @Nullable
    private StompBrokerRelayMessageHandler stompBrokerRelay;
    @Nullable
    private TaskExecutor inboundChannelExecutor;
    @Nullable
    private TaskExecutor outboundChannelExecutor;
    @Nullable
    private TaskScheduler sockJsTaskScheduler;
    @Nullable
    private ScheduledFuture<?> loggingTask;
    private long loggingPeriod = TimeUnit.MINUTES.toMillis(30L);

    public void setSubProtocolWebSocketHandler(SubProtocolWebSocketHandler webSocketHandler) {
        this.webSocketHandler = webSocketHandler;
    }

    public void setStompBrokerRelay(StompBrokerRelayMessageHandler stompBrokerRelay) {
        this.stompBrokerRelay = stompBrokerRelay;
    }

    public void setInboundChannelExecutor(TaskExecutor inboundChannelExecutor) {
        this.inboundChannelExecutor = inboundChannelExecutor;
    }

    public void setOutboundChannelExecutor(TaskExecutor outboundChannelExecutor) {
        this.outboundChannelExecutor = outboundChannelExecutor;
    }

    public void setSockJsTaskScheduler(TaskScheduler sockJsTaskScheduler) {
        this.sockJsTaskScheduler = sockJsTaskScheduler;
    }

    public void setLoggingPeriod(long period) {
        this.loggingPeriod = period;
        if (this.loggingTask != null) {
            this.loggingTask.cancel(true);
            this.loggingTask = this.initLoggingTask(0L);
        }
    }

    public long getLoggingPeriod() {
        return this.loggingPeriod;
    }

    public void afterSingletonsInstantiated() {
        this.stompSubProtocolHandler = this.initStompSubProtocolHandler();
        this.loggingTask = this.initLoggingTask(TimeUnit.MINUTES.toMillis(1L));
    }

    @Nullable
    private StompSubProtocolHandler initStompSubProtocolHandler() {
        if (this.webSocketHandler == null) {
            return null;
        }
        for (SubProtocolHandler handler : this.webSocketHandler.getProtocolHandlers()) {
            if (!(handler instanceof StompSubProtocolHandler)) continue;
            StompSubProtocolHandler stompHandler = (StompSubProtocolHandler)handler;
            return stompHandler;
        }
        SubProtocolHandler defaultHandler = this.webSocketHandler.getDefaultProtocolHandler();
        if (defaultHandler instanceof StompSubProtocolHandler) {
            StompSubProtocolHandler stompHandler = (StompSubProtocolHandler)defaultHandler;
            return stompHandler;
        }
        return null;
    }

    @Nullable
    private ScheduledFuture<?> initLoggingTask(long initialDelay) {
        if (this.sockJsTaskScheduler != null && this.loggingPeriod > 0L && logger.isInfoEnabled()) {
            return this.sockJsTaskScheduler.scheduleWithFixedDelay(() -> logger.info((Object)this.toString()), Instant.now().plusMillis(initialDelay), Duration.ofMillis(this.loggingPeriod));
        }
        return null;
    }

    public String getWebSocketSessionStatsInfo() {
        return this.webSocketHandler != null ? this.webSocketHandler.getStatsInfo() : "null";
    }

    public String getStompSubProtocolStatsInfo() {
        return this.stompSubProtocolHandler != null ? this.stompSubProtocolHandler.getStatsInfo() : "null";
    }

    public String getStompBrokerRelayStatsInfo() {
        return this.stompBrokerRelay != null ? this.stompBrokerRelay.getStatsInfo() : "null";
    }

    public String getClientInboundExecutorStatsInfo() {
        return this.getExecutorStatsInfo((Executor)this.inboundChannelExecutor);
    }

    public String getClientOutboundExecutorStatsInfo() {
        return this.getExecutorStatsInfo((Executor)this.outboundChannelExecutor);
    }

    public String getSockJsTaskSchedulerStatsInfo() {
        if (this.sockJsTaskScheduler == null) {
            return "null";
        }
        TaskScheduler taskScheduler = this.sockJsTaskScheduler;
        if (taskScheduler instanceof ThreadPoolTaskScheduler) {
            ThreadPoolTaskScheduler threadPoolTaskScheduler = (ThreadPoolTaskScheduler)taskScheduler;
            return this.getExecutorStatsInfo(threadPoolTaskScheduler.getScheduledThreadPoolExecutor());
        }
        return "unknown";
    }

    private String getExecutorStatsInfo(@Nullable Executor executor) {
        String str;
        int indexOfPool;
        if (executor == null) {
            return "null";
        }
        if (executor instanceof ThreadPoolTaskExecutor) {
            ThreadPoolTaskExecutor threadPoolTaskScheduler = (ThreadPoolTaskExecutor)executor;
            executor = threadPoolTaskScheduler.getThreadPoolExecutor();
        }
        if (executor instanceof ThreadPoolExecutor && (indexOfPool = (str = executor.toString()).indexOf("pool")) != -1) {
            return str.substring(indexOfPool, str.length() - 1);
        }
        return "unknown";
    }

    public String toString() {
        return "WebSocketSession[" + this.getWebSocketSessionStatsInfo() + "], stompSubProtocol[" + this.getStompSubProtocolStatsInfo() + "], stompBrokerRelay[" + this.getStompBrokerRelayStatsInfo() + "], inboundChannel[" + this.getClientInboundExecutorStatsInfo() + "], outboundChannel[" + this.getClientOutboundExecutorStatsInfo() + "], sockJsScheduler[" + this.getSockJsTaskSchedulerStatsInfo() + "]";
    }
}

