/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.aot;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.annotation.Reference;
import org.springframework.data.mongodb.aot.MongoAotReflectionHelper;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxyFactory;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.DocumentReference;

public class LazyLoadingProxyAotProcessor {
    private boolean generalLazyLoadingProxyContributed = false;

    public void registerLazyLoadingProxyIfNeeded(Class<?> type, GenerationContext generationContext) {
        Set<Field> refFields = LazyLoadingProxyAotProcessor.getFieldsWithAnnotationPresent(type, Reference.class);
        if (refFields.isEmpty()) {
            return;
        }
        refFields.stream().filter(LazyLoadingProxyAotProcessor::isLazyLoading).forEach(field -> {
            if (!this.generalLazyLoadingProxyContributed) {
                generationContext.getRuntimeHints().proxies().registerJdkProxy(new TypeReference[]{TypeReference.of(LazyLoadingProxy.class), TypeReference.of(SpringProxy.class), TypeReference.of(Advised.class), TypeReference.of(DecoratingProxy.class)});
                this.generalLazyLoadingProxyContributed = true;
            }
            if (field.getType().isInterface()) {
                ArrayList<Class> interfaces = new ArrayList<Class>(Arrays.asList(LazyLoadingProxyFactory.prepareFactory(field.getType()).getProxiedInterfaces()));
                interfaces.add(SpringProxy.class);
                interfaces.add(Advised.class);
                interfaces.add(DecoratingProxy.class);
                generationContext.getRuntimeHints().proxies().registerJdkProxy((Class[])interfaces.toArray(Class[]::new));
            } else {
                Class<?> proxyClass = LazyLoadingProxyFactory.resolveProxyType(field.getType(), LazyLoadingProxyFactory.LazyLoadingInterceptor::none);
                generationContext.getRuntimeHints().reflection().registerType(proxyClass, MongoAotReflectionHelper::cglibProxyReflectionMemberAccess);
            }
        });
    }

    private static boolean isLazyLoading(Field field) {
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)field, DBRef.class)) {
            return ((DBRef)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, DBRef.class)).lazy();
        }
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)field, DocumentReference.class)) {
            return ((DocumentReference)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, DocumentReference.class)).lazy();
        }
        return false;
    }

    private static Set<Field> getFieldsWithAnnotationPresent(Class<?> type, Class<? extends Annotation> annotation) {
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        for (Field field : type.getDeclaredFields()) {
            if (!MergedAnnotations.from((AnnotatedElement)field).get(annotation).isPresent()) continue;
            fields.add(field);
        }
        return fields;
    }
}

