/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration;

import com.ubnt.ace.U;
import com.ubnt.ooOO.super.o0OO;
import com.ubnt.service.orchestration.OrchestratorMetadataService;
import com.ubnt.service.orchestration.dto.report.IssueDetailReportDto;
import com.ubnt.service.orchestration.dto.report.OrchestrationSiteReportDto;
import com.ubnt.service.orchestration.dto.report.TemplateReportDto;
import com.ubnt.service.orchestration.model.AbstractTemplate;
import com.ubnt.service.orchestration.model.Orchestration;
import com.ubnt.service.orchestration.model.OrchestrationMetaData;
import com.ubnt.service.orchestration.model.OrchestratorMetadata;
import com.ubnt.service.orchestration.model.TemplateMetaData;
import com.ubnt.service.orchestration.template.TemplateProvisioningHandler;
import com.ubnt.service.orchestration.template.TemplateProvisioningValidationIssue;
import com.ubnt.service.orchestration.template.TemplateType;
import com.ubnt.service.system.jA;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;

public class OrchestrationApplyHandler {
    private static final Logger LOGGER = jA.ifnew;
    private final Map<TemplateType, TemplateProvisioningHandler<? extends AbstractTemplate>> templateTypeHandlers;
    private final OrchestratorMetadataService orchestratorMetaDataService;

    public List<OrchestrationSiteReportDto> handleOrchestration(Orchestration orchestration) {
        OrchestrationMetaData orchestrationMetaData = orchestration.metaData();
        List<String> list = orchestrationMetaData.siteIds();
        List<AbstractTemplate> list2 = orchestration.templates();
        OrchestratorMetadata orchestratorMetadata = orchestrationMetaData.orchestratorMetadata();
        if (orchestratorMetadata == null) {
            LOGGER.warn("Orchestrator metadata is null, proceeding without it.");
        }
        Supplier<List<OrchestrationSiteReportDto>> supplier = U.new(this::o00000, list, list2);
        return this.orchestratorMetaDataService.handleOrchestrationWithOrchestratorData(supplier, orchestratorMetadata);
    }

    private List<OrchestrationSiteReportDto> o00000(List<String> list, List<AbstractTemplate> list2) {
        return list.stream().map(string -> this.String((String)string, list2)).toList();
    }

    private OrchestrationSiteReportDto String(String string, List<AbstractTemplate> list) {
        o0OO o0OO2 = o0OO.Object();
        for (AbstractTemplate abstractTemplate : list) {
            TemplateProvisioningHandler<? extends AbstractTemplate> templateProvisioningHandler = this.templateTypeHandlers.get((Object)abstractTemplate.getType());
            if (templateProvisioningHandler == null) continue;
            TemplateReportDto templateReportDto = this.\u00d200000(string, abstractTemplate, templateProvisioningHandler);
            o0OO2.\u00d400000((Object)templateReportDto);
        }
        return OrchestrationSiteReportDto.builder().id(string).reports(o0OO2.o00000()).build();
    }

    private <T extends AbstractTemplate> TemplateReportDto \u00d200000(String string, AbstractTemplate abstractTemplate, TemplateProvisioningHandler<T> templateProvisioningHandler) {
        AbstractTemplate abstractTemplate2 = (AbstractTemplate)templateProvisioningHandler.handledType().cast(abstractTemplate);
        Map<TemplateProvisioningValidationIssue, List<IssueDetailReportDto>> map = templateProvisioningHandler.handle(string, abstractTemplate2);
        TemplateMetaData templateMetaData = abstractTemplate.getMetaData();
        return TemplateReportDto.builder().type(abstractTemplate2.getType()).application("network").templateId(templateMetaData.templateId()).revisionId(templateMetaData.revisionId()).errors(map.getOrDefault((Object)TemplateProvisioningValidationIssue.ERROR, List.of())).warnings(map.getOrDefault((Object)TemplateProvisioningValidationIssue.WARNING, List.of())).build();
    }

    public Set<TemplateType> getTypeHandlers() {
        return this.templateTypeHandlers.keySet();
    }

    @ConstructorProperties(value={"templateTypeHandlers", "orchestratorMetaDataService"})
    @Generated
    public OrchestrationApplyHandler(Map<TemplateType, TemplateProvisioningHandler<? extends AbstractTemplate>> map, OrchestratorMetadataService orchestratorMetadataService) {
        this.templateTypeHandlers = map;
        this.orchestratorMetaDataService = orchestratorMetadataService;
    }
}

