/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.config.security;

import com.google.common.collect.Sets;
import com.ubnt.ace.view.AuthFilter;
import com.ubnt.ace.view.OooO;
import com.ubnt.data.Setting;
import com.ubnt.data.X;
import com.ubnt.net.security.B;
import com.ubnt.net.security.F;
import com.ubnt.net.security.O0OO;
import com.ubnt.net.security.int;
import com.ubnt.net.v2.config.security.EndpointType;
import com.ubnt.net.v2.config.security.ImmutableV2EndpointParams;
import com.ubnt.net.v2.config.security.RequestSiteInfoExtractor;
import com.ubnt.net.v2.config.security.V2EndpointParams;
import com.ubnt.net.v2.config.security.V2RequestConditionBuilder;
import com.ubnt.net.v2.config.security.exception.AccessForbidden;
import com.ubnt.net.v2.config.security.exception.AccessToSiteForbidden;
import com.ubnt.net.v2.config.security.exception.ConsoleOwnerOnlyAccess;
import com.ubnt.net.v2.config.security.exception.UCoreOnlyAccess;
import com.ubnt.net.v2.exception.UserNotAuthenticatedException;
import com.ubnt.service.system.IA;
import com.ubnt.service.system.O00Oo;
import com.ubnt.service.system.W;
import com.ubnt.service.system.null;
import com.ubnt.service.system.setting.H;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.immutables.builder.Builder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.condition.RequestCondition;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class V2RequestCondition
implements RequestCondition<V2RequestCondition> {
    private static final boolean \u00d600000 = Boolean.parseBoolean(System.getProperty("skip.check.for.ucore.only.requests", "false"));
    private final null \u00d500000;
    private final O00Oo o00000;
    private final W String;
    private final F \u00d300000;
    private final RequestSiteInfoExtractor \u00d200000;
    private final V2EndpointParams \u00d800000;

    @Builder.Constructor
    V2RequestCondition(null nullVal, O00Oo o00Oo2, W w2, F f2, RequestSiteInfoExtractor requestSiteInfoExtractor, V2EndpointParams v2EndpointParams) {
        this.\u00d500000 = nullVal;
        this.o00000 = o00Oo2;
        this.String = w2;
        this.\u00d200000 = requestSiteInfoExtractor;
        this.\u00d300000 = f2;
        this.\u00d800000 = v2EndpointParams;
    }

    public V2RequestCondition getMatchingCondition(HttpServletRequest httpServletRequest) {
        X x2;
        if (this.String.\u00d2\u00d40000() || this.class(httpServletRequest) || this.do(httpServletRequest) || this.\u00f800000(httpServletRequest)) {
            return this;
        }
        try {
            x2 = Optional.ofNullable(AuthFilter.Object().\u00f600000(httpServletRequest)).or(() -> this.\u00d300000.\u00f4O0000(httpServletRequest, this.\u00d800000())).orElseThrow(() -> new UserNotAuthenticatedException(httpServletRequest.getRequestURI()));
        }
        catch (O0OO o0OO2) {
            throw new UserNotAuthenticatedException(httpServletRequest.getRequestURI());
        }
        this.\u00f600000(httpServletRequest, x2);
        return this;
    }

    public V2RequestCondition combine(V2RequestCondition v2RequestCondition) {
        EndpointType endpointType = this.\u00d800000.getEndpointType() != EndpointType.UNKNOWN ? this.\u00d800000.getEndpointType() : v2RequestCondition.getEndpointType();
        boolean bl = this.isAllowPrivateNetworks() || v2RequestCondition.\u00d800000.isAllowPrivateNetworks();
        boolean bl2 = this.isAllowApiToken() || v2RequestCondition.\u00d800000.isAllowApiToken();
        boolean bl3 = this.isAllowUcoreLocal() || v2RequestCondition.isAllowUcoreLocal();
        Sets.SetView setView = Sets.union(this.getAllowedPrivileges(), v2RequestCondition.getAllowedPrivileges());
        boolean bl4 = this.isUcoreLocalOnlyEndpoint() || v2RequestCondition.isUcoreLocalOnlyEndpoint();
        boolean bl5 = this.isRequireConsoleOwner() || v2RequestCondition.isRequireConsoleOwner();
        ImmutableV2EndpointParams immutableV2EndpointParams = V2EndpointParams.builder().endpointType(endpointType).isAllowUCoreLocal(bl3).allowPrivileges((Iterable<String>)setView).isRequireUCoreLocal(bl4).isAllowPrivateNetworks(bl).isAllowApiToken(bl2).isRequireConsoleOwner(bl5).build();
        return V2RequestCondition.builder().configCache(this.\u00d500000).siteManager(this.o00000).requestSiteInfoExtractor(this.\u00d200000).systemEnvironmentService(this.String).ucoreAuthenticator(this.\u00d300000).endpointParams(immutableV2EndpointParams).build();
    }

    public int compareTo(V2RequestCondition v2RequestCondition, HttpServletRequest httpServletRequest) {
        return 0;
    }

    private void \u00f600000(HttpServletRequest httpServletRequest, X x2) {
        OooO.\u00f400000(httpServletRequest, x2);
        this.\u00d4O0000(x2);
        if (x2.is("super_admin", false)) {
            return;
        }
        Optional<String> optional = this.\u00d200000.String(httpServletRequest.getRequestURI());
        X x3 = x2.getX("privileges", X.\u00f4\u00d30000);
        if (optional.isPresent()) {
            this.\u00d300000(x3, optional.get());
        } else {
            this.OO0000(x3);
        }
    }

    private void \u00d4O0000(X x2) {
        if (this.\u00d800000.isRequireConsoleOwner() && !x2.is("is_owner", false)) {
            throw new ConsoleOwnerOnlyAccess();
        }
    }

    private void \u00d300000(X x2, String string) {
        String string2 = this.o00000.\u00f4O0000(string);
        String string3 = x2.getString(string2);
        if ("admin".equals(string3)) {
            return;
        }
        if ("readonly".equals(string3) && (this.getEndpointType() == EndpointType.READ || this.getAllowedPrivileges().contains("readonly"))) {
            return;
        }
        if ("hotspot".equals(string3) && this.getAllowedPrivileges().contains("hotspot")) {
            return;
        }
        if ("identity_user".equals(string3)) {
            return;
        }
        throw new AccessToSiteForbidden();
    }

    private void OO0000(X x2) {
        if (Stream.of("admin", "readonly", "hotspot").anyMatch(string -> this.\u00f400000(x2, (String)string))) {
            return;
        }
        throw new AccessForbidden();
    }

    private boolean \u00f400000(X x2, String string) {
        return this.\u00d200000(string, x2) && this.getAllowedPrivileges().contains(string);
    }

    private boolean \u00d200000(String string, X x2) {
        return x2.values().stream().anyMatch(string::equals);
    }

    public EndpointType getEndpointType() {
        return this.\u00d800000.getEndpointType();
    }

    public boolean isAllowUcoreLocal() {
        return this.\u00d800000.isAllowUCoreLocal();
    }

    public Set<String> getAllowedPrivileges() {
        return this.\u00d800000.getAllowPrivileges();
    }

    public boolean isRequireConsoleOwner() {
        return this.\u00d800000.isRequireConsoleOwner();
    }

    public boolean isUcoreLocalOnlyEndpoint() {
        return this.\u00d800000.isRequireUCoreLocal();
    }

    public boolean isAllowPrivateNetworks() {
        return this.\u00d800000.isAllowPrivateNetworks();
    }

    public boolean isAllowApiToken() {
        return this.\u00d800000.isAllowApiToken();
    }

    private boolean class(HttpServletRequest httpServletRequest) {
        boolean bl;
        if (\u00d600000) {
            return false;
        }
        boolean bl2 = bl = IA.\u00d5\u00f50000() && httpServletRequest.getLocalPort() == IA.\u00f4o0000();
        if (bl && !B.\u00d200000(httpServletRequest)) {
            return this.\u00d800000.isAllowUCoreLocal() || this.\u00d800000.isRequireUCoreLocal();
        }
        if (this.\u00d800000.isRequireUCoreLocal()) {
            throw new UCoreOnlyAccess();
        }
        return false;
    }

    private boolean do(HttpServletRequest httpServletRequest) {
        if (this.\u00d800000.isAllowPrivateNetworks()) {
            String string = httpServletRequest.getRemoteAddr();
            String string2 = httpServletRequest.getHeader("X-Forwarded-For");
            if (IA.\u00d5\u00f50000()) {
                return string2 != null && com.ubnt.net.OOoO.null.\u00d8\u00d20000(string2);
            }
            return com.ubnt.net.OOoO.null.\u00d8\u00d20000(string);
        }
        return false;
    }

    private boolean \u00f800000(HttpServletRequest httpServletRequest) {
        if (this.\u00d800000.isAllowApiToken()) {
            return this.\u00d200000.\u00d200000(httpServletRequest.getRequestURI()).map(string -> this.\u00d3O0000(httpServletRequest, (String)string)).orElse(false);
        }
        return false;
    }

    private boolean \u00d3O0000(HttpServletRequest httpServletRequest, String string2) {
        Setting setting = this.\u00d500000.\u00d5\u00d4\u00d3O00(H.\u00d8o0000.toString(), string2);
        return int.\u00d500000(httpServletRequest).map(string -> StringUtils.equals((CharSequence)setting.getString("x_api_token"), (CharSequence)string)).orElse(false);
    }

    private HttpServletResponse \u00d800000() {
        return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getResponse();
    }

    public static V2RequestConditionBuilder builder() {
        return new V2RequestConditionBuilder();
    }
}

