/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.avgroup;

import com.ubnt.ace.Q;
import com.ubnt.data.AvBridgeRole;
import com.ubnt.data.DeviceType;
import com.ubnt.data.Site;
import com.ubnt.model.api.avgroup.AvGroupDto;
import com.ubnt.model.api.avgroup.AvGroupMatrixDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.avgroup.AvGroupDocument;
import com.ubnt.service.avgroup.K;
import com.ubnt.service.avgroup.M;
import com.ubnt.service.devmgr.c;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Tag(name="AV Groups")
public class AvGroupController {
    private final c \u00d200000;
    private final K o00000;

    @GetMapping(value={"/api/site/{siteName}/proav/{type}/matrix"})
    @Operation(summary="List AV Matrix")
    public AvGroupMatrixDto getAvMatrix(@PathVariable(value="siteName") Site site, @PathVariable(value="type") String string) {
        String string2 = site.getId();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        M m2 = Q.private(M.class, string.toUpperCase()).orElse(M.new);
        this.\u00d200000.\u00d8\u00f5OO00(string2, DeviceType.super).forEach(device -> {
            AvBridgeRole avBridgeRole = device.getCurrentAvGroupRole(m2);
            if (avBridgeRole == AvBridgeRole.super) {
                arrayList.add(device.getMAC());
            } else if (avBridgeRole == AvBridgeRole.\u00d400000) {
                arrayList2.add(device.getMAC());
            }
        });
        List<AvGroupDocument> list = this.o00000.\u00d600000(string2);
        return AvGroupMatrixDto.fromDocument(m2, list, arrayList, arrayList2);
    }

    @GetMapping(value={"/api/site/{siteName}/proav/{type}/group/{id}"})
    @Operation(summary="Get AV Group")
    public AvGroupDto getAvGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        return AvGroupDto.fromDocument(this.o00000.\u00d500000(string));
    }

    @PostMapping(value={"/api/site/{siteName}/proav/{type}/group"}, consumes={"application/json"})
    @Operation(summary="Create a new AV Group")
    @ResponseStatus(value=HttpStatus.CREATED)
    public AvGroupDto createAvGroup(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull AvGroupDto avGroupDto) {
        return AvGroupDto.fromDocument(this.o00000.\u00d400000(avGroupDto.toDocument(site.getId())));
    }

    @PutMapping(value={"/api/site/{siteName}/proav/{type}/group/{id}"}, consumes={"application/json"})
    @Operation(summary="Update AV Group")
    public AvGroupDto updateAvGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string, @RequestBody @Valid @NotNull AvGroupDto avGroupDto) {
        AvGroupDto avGroupDto2 = avGroupDto.withId(string);
        AvGroupDocument avGroupDocument = this.o00000.\u00d200000(avGroupDto2.toDocument(site.getId()));
        return AvGroupDto.fromDocument(avGroupDocument);
    }

    @DeleteMapping(value={"/api/site/{siteName}/proav/{type}/group/{id}"})
    @Operation(summary="Delete AV Group")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAvGroup(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        this.o00000.o00000(string);
    }

    @ConstructorProperties(value={"deviceManager", "avGroupService"})
    @Generated
    public AvGroupController(c c2, K k2) {
        this.\u00d200000 = c2;
        this.o00000 = k2;
    }
}

