/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2;

import com.ubnt.data.Setting;
import com.ubnt.data.Site;
import com.ubnt.model.api.speedtest.LastSpeedTestDto;
import com.ubnt.model.api.speedtest.SpeedTestOverviewDto;
import com.ubnt.model.api.speedtest.SpeedtestDto;
import com.ubnt.model.api.speedtest.SpeedtestListDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.devmgr.command.E.OOoO;
import com.ubnt.service.stat.A.new;
import com.ubnt.service.stat.A.super;
import com.ubnt.service.system.setting.H;
import com.ubnt.service.system.setting.Oo0O;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="Speed Test")
public class SpeedTestController {
    private final super new;
    private final new \u00d400000;
    private final Clock o00000;
    private final Oo0O \u00d300000;

    public SpeedTestController(super super_, new new_, Clock clock, Oo0O oo0O2) {
        this.new = super_;
        this.\u00d400000 = new_;
        this.o00000 = clock;
        this.\u00d300000 = oo0O2;
    }

    @GetMapping(value={"/api/site/{siteName}/speedtest"})
    @Operation(summary="List historical speed test results")
    public SpeedtestListDto getHistoricalSpeedTestResults(@PathVariable(value="siteName") Site site, @RequestParam(value="timestampFrom") Optional<Long> optional, @RequestParam(value="timestampTo") Optional<Long> optional2) {
        List list = this.new.for(site.getId(), optional.orElse(Long.MIN_VALUE), optional2.orElse(Long.MAX_VALUE)).stream().map(SpeedtestDto::fromX).collect(Collectors.toList());
        return SpeedtestListDto.builder().data(list).build();
    }

    @GetMapping(value={"/api/site/{siteName}/speedtest/latest"})
    @Operation(summary="Get last speed test result", description="Since 7.2.51")
    public LastSpeedTestDto getLastSpeedTestResult(@PathVariable(value="siteName") Site site) {
        List<SpeedtestDto> list = this.new.\u00d600000(site.getId());
        Optional<SpeedtestDto> optional = OOoO.\u00d200000(list);
        Setting setting = this.\u00d300000.\u00d300000(H.whilenew, site.getId());
        return LastSpeedTestDto.builder().speedTestLatest(optional).cronSchedule(this.o00000(setting)).build();
    }

    @GetMapping(value={"/api/site/{siteName}/speedtest/latest-per-wan"})
    @Operation(summary="Get last speed test result for all network groups", description="Since 8.4.48")
    public SpeedTestOverviewDto getSpeedTestDataResult(@PathVariable(value="siteName") Site site) {
        return this.new.\u00d200000(site.getId());
    }

    private Optional<String> o00000(Setting setting) {
        return setting.isEnabled() ? setting.getOptionalString("cron_expr") : Optional.empty();
    }

    @GetMapping(path={"/api/site/{siteName}/speedtest/csv"}, produces={"text/csv"})
    @Operation(summary="List historical speed test results as csv document")
    public ResponseEntity<Resource> getHistoricalSpeedTestResultsAsCsv(@PathVariable(value="siteName") Site site) {
        String string = this.\u00d400000.super(site.getId());
        long l2 = this.o00000.instant().getEpochSecond();
        String string2 = "speedtest-" + l2 + ".csv";
        ByteArrayResource byteArrayResource = new ByteArrayResource(string.getBytes(StandardCharsets.UTF_8));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + string2})).contentType(MediaType.parseMediaType((String)"text/csv")).contentLength(byteArrayResource.contentLength()).body((Object)byteArrayResource);
    }
}

