/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.teleport;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.teleport.ImmutableTeleportTokenListParameter;
import com.ubnt.model.api.teleport.TeleportTokenListParameter;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="TeleportTokenListParameter", generator="Modifiables")
public final class ModifiableTeleportTokenListParameter
implements TeleportTokenListParameter {
    private static final long OPT_BIT_PAGE_NUMBER = 1L;
    private static final long OPT_BIT_PAGE_SIZE = 2L;
    private long optBits;
    private int pageNumber;
    private int pageSize;

    private ModifiableTeleportTokenListParameter() {
    }

    public static ModifiableTeleportTokenListParameter create() {
        return new ModifiableTeleportTokenListParameter();
    }

    @Override
    @Min(value=0L)
    @Parameter(name="pageNumber", schema=@Schema(defaultValue="0"), example="0")
    public final @Min(value=0L) int getPageNumber() {
        if (this.pageNumberIsSet()) {
            return this.pageNumber;
        }
        return TeleportTokenListParameter.super.getPageNumber();
    }

    @Override
    @Min(value=1L)
    @Parameter(name="pageSize", schema=@Schema(defaultValue="10"), example="10")
    public final @Min(value=1L) int getPageSize() {
        if (this.pageSizeIsSet()) {
            return this.pageSize;
        }
        return TeleportTokenListParameter.super.getPageSize();
    }

    @CanIgnoreReturnValue
    public ModifiableTeleportTokenListParameter clear() {
        this.optBits = 0L;
        this.pageNumber = 0;
        this.pageSize = 0;
        return this;
    }

    public ModifiableTeleportTokenListParameter from(TeleportTokenListParameter teleportTokenListParameter) {
        Objects.requireNonNull(teleportTokenListParameter, "instance");
        if (teleportTokenListParameter instanceof ModifiableTeleportTokenListParameter) {
            this.from((ModifiableTeleportTokenListParameter)teleportTokenListParameter);
            return this;
        }
        this.setPageNumber(teleportTokenListParameter.getPageNumber());
        this.setPageSize(teleportTokenListParameter.getPageSize());
        return this;
    }

    public ModifiableTeleportTokenListParameter from(ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter) {
        Objects.requireNonNull(modifiableTeleportTokenListParameter, "instance");
        this.setPageNumber(modifiableTeleportTokenListParameter.getPageNumber());
        this.setPageSize(modifiableTeleportTokenListParameter.getPageSize());
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableTeleportTokenListParameter setPageNumber(int n2) {
        this.pageNumber = n2;
        this.optBits |= 1L;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableTeleportTokenListParameter setPageSize(int n2) {
        this.pageSize = n2;
        this.optBits |= 2L;
        return this;
    }

    public final boolean pageNumberIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    public final boolean pageSizeIsSet() {
        return (this.optBits & 2L) != 0L;
    }

    @CanIgnoreReturnValue
    public final ModifiableTeleportTokenListParameter unsetPageNumber() {
        this.optBits |= 0L;
        this.pageNumber = 0;
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableTeleportTokenListParameter unsetPageSize() {
        this.optBits |= 0L;
        this.pageSize = 0;
        return this;
    }

    public final boolean initialized() {
        return true;
    }

    public final ImmutableTeleportTokenListParameter toImmutable() {
        return ImmutableTeleportTokenListParameter.builder().from(this).build();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ModifiableTeleportTokenListParameter)) {
            return false;
        }
        ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter = (ModifiableTeleportTokenListParameter)object;
        return this.\u00d400000(modifiableTeleportTokenListParameter);
    }

    private boolean \u00d400000(ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter) {
        int n2 = this.getPageNumber();
        int n3 = this.getPageSize();
        return n2 == modifiableTeleportTokenListParameter.getPageNumber() && n3 == modifiableTeleportTokenListParameter.getPageSize();
    }

    public int hashCode() {
        int n2 = 5381;
        int n3 = this.getPageNumber();
        n2 += (n2 << 5) + n3;
        int n4 = this.getPageSize();
        n2 += (n2 << 5) + n4;
        return n2;
    }

    public String toString() {
        return "ModifiableTeleportTokenListParameter{pageNumber=" + this.getPageNumber() + ", pageSize=" + this.getPageSize() + "}";
    }
}

