/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.firewall.qos;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.model.api.firewall.qos.CombinedQosRuleOriginType;
import com.ubnt.model.api.firewall.qos.ImmutableQosRuleDto;
import com.ubnt.model.api.firewall.qos.destination.FirewallQosDestinationDto;
import com.ubnt.model.api.firewall.qos.source.FirewallQosSourceDto;
import com.ubnt.model.schedule.ScheduleDto;
import com.ubnt.return.F;
import com.ubnt.service.firewall.qos.QosRuleDocument;
import com.ubnt.service.firewall.qos.ooOO;
import com.ubnt.service.firewall.qos.public;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=ImmutableQosRuleDto.Builder.class)
@Value.Immutable(copy=true)
@F
public interface QosRuleDto {
    @JsonProperty(value="_id")
    @Nullable
    public String id();

    @JsonProperty(value="enabled")
    public boolean enabled();

    @JsonProperty(value="name")
    public String name();

    @JsonProperty(value="index")
    public int index();

    @JsonProperty(value="objective")
    @NotNull
    public public objective();

    @JsonProperty(value="source")
    @Valid
    @NotNull
    public FirewallQosSourceDto source();

    @JsonProperty(value="destination")
    @Valid
    @NotNull
    public FirewallQosDestinationDto destination();

    @JsonProperty(value="wan_or_vpn_network")
    @Valid
    public Optional<String> wanOrVpnNetwork();

    @JsonProperty(value="download_limit_kbps")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public @Min(value=0L) @Max(value=0x7FFFFFFFL) Integer downloadLimitKbps();

    @JsonProperty(value="download_burst")
    public ooOO downloadBurst();

    @JsonProperty(value="upload_limit_kbps")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public @Min(value=0L) @Max(value=0x7FFFFFFFL) Integer uploadLimitKbps();

    @JsonProperty(value="upload_burst")
    public ooOO uploadBurst();

    @JsonProperty(value="schedule")
    @Valid
    @NotNull
    public ScheduleDto schedule();

    @JsonProperty(value="predefined")
    public Boolean predefined();

    @JsonProperty(value="origin_id")
    public Optional<String> originId();

    @JsonProperty(value="origin_type")
    public Optional<CombinedQosRuleOriginType> originType();

    public static ImmutableQosRuleDto.Builder builder() {
        return ImmutableQosRuleDto.builder();
    }

    public static QosRuleDto fromDocument(QosRuleDocument qosRuleDocument) {
        return QosRuleDto.builder().id(qosRuleDocument.getId()).enabled(qosRuleDocument.isEnabled()).name(qosRuleDocument.getName()).index(qosRuleDocument.getIndex()).objective(qosRuleDocument.getObjective()).source(FirewallQosSourceDto.fromDocument(qosRuleDocument.getSource())).destination(FirewallQosDestinationDto.fromDocument(qosRuleDocument.getDestination())).wanOrVpnNetwork(qosRuleDocument.getWanOrVpnNetwork()).downloadLimitKbps(qosRuleDocument.getDownloadLimitKbps()).downloadBurst(qosRuleDocument.getDownloadBurst()).uploadLimitKbps(qosRuleDocument.getUploadLimitKbps()).uploadBurst(qosRuleDocument.getUploadBurst()).schedule(ScheduleDto.fromDocument(qosRuleDocument.getSchedule())).build();
    }

    default public QosRuleDocument toDocument(String string) {
        return QosRuleDocument.builder().\u00d300000(this.id()).\u00d4O0000(this.enabled()).\u00f600000(this.name()).class(this.index()).\u00d600000(this.objective()).super(this.destination().toDocument()).do(this.source().toDocument()).\u00d200000(this.wanOrVpnNetwork().orElse(null)).int(this.downloadLimitKbps()).\u00d3O0000(this.downloadBurst() != null ? this.downloadBurst() : ooOO.\u00d400000).\u00f400000(this.uploadLimitKbps()).OO0000(this.uploadBurst() != null ? this.uploadBurst() : ooOO.\u00d400000).\u00d800000(ScheduleDto.toDocument(this.schedule())).\u00f800000(string).\u00d2O0000();
    }

    public static QosRuleDto withId(QosRuleDto qosRuleDto, String string) {
        return ImmutableQosRuleDto.copyOf(qosRuleDto).withId(string);
    }
}

