/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.engine.TimedResult;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;

final class TimedExecutor {
    private final Executor _executor;

    public TimedExecutor(Executor executor) {
        this._executor = Objects.requireNonNull(executor);
    }

    public <T> CompletableFuture<TimedResult<T>> async(Supplier<T> supplier, Clock clock) {
        return CompletableFuture.supplyAsync(TimedResult.of(supplier, clock), this._executor);
    }

    public <U, T> CompletableFuture<TimedResult<T>> thenApply(CompletableFuture<U> result, Function<U, T> function, Clock clock) {
        return result.thenApplyAsync(TimedResult.of(function, clock), this._executor);
    }

    public Executor get() {
        return this._executor;
    }
}

