/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.node;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.gjt.xpp.XmlNode;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.impl.node.EmptyEnumerator;
import org.gjt.xpp.impl.node.OneChildEnumerator;
import org.gjt.xpp.impl.tag.PullParserRuntimeException;
import org.gjt.xpp.impl.tag.StartTag;

public class Node
extends StartTag
implements XmlNode {
    protected static final Enumeration EMPTY_ENUMERATION = new EmptyEnumerator();
    protected Vector children;
    protected int childrenCount;
    protected Object oneChild;
    protected XmlNode parent;
    protected String defaultNamespaceUri;
    protected Hashtable prefix2Ns;
    protected int declaredNsEnd;
    protected String[] declaredNs;
    protected String[] declaredPrefixes;

    public boolean equals(Object o) {
        String nodeU;
        String u;
        if (o == null) {
            return false;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node node = (Node)o;
        if (this.childrenCount != node.childrenCount) {
            return false;
        }
        if (this.childrenCount == 1) {
            if (!this.oneChild.equals(node.oneChild)) {
                return false;
            }
        } else {
            for (int i = 0; i < this.childrenCount; ++i) {
                if (this.children.elementAt(i).equals(node.children.elementAt(i))) continue;
                return false;
            }
        }
        if ((u = this.defaultNamespaceUri) == null) {
            u = "";
        }
        if ((nodeU = node.defaultNamespaceUri) == null) {
            nodeU = "";
        }
        if (!u.equals(nodeU)) {
            return false;
        }
        return super.equals(o);
    }

    public void resetNode() {
        super.resetStartTag();
        this.parent = null;
        this.childrenCount = 0;
        this.oneChild = null;
        if (this.children != null) {
            this.children.removeAllElements();
        }
        this.removeDeclaredNamespaces();
    }

    public XmlNode newNode() throws XmlPullParserException {
        return new Node();
    }

    public XmlNode newNode(String namespaceUri, String localName) throws XmlPullParserException {
        Node node = new Node();
        String prefix = this.namespace2Prefix(namespaceUri);
        if (prefix == null) {
            throw new XmlPullParserException("namespace '" + namespaceUri + "' has no prefix declared in node tree");
        }
        node.modifyTag(namespaceUri, localName, "".equals(prefix) ? localName : prefix + ':' + localName);
        return node;
    }

    public XmlNode getParentNode() {
        return this.parent;
    }

    public Enumeration children() {
        if (this.childrenCount == 0) {
            return EMPTY_ENUMERATION;
        }
        if (this.childrenCount == 1) {
            return new OneChildEnumerator(this.oneChild);
        }
        return this.children.elements();
    }

    public int getChildrenCount() {
        return this.childrenCount;
    }

    public Object getChildAt(int pos) {
        if (this.childrenCount > 0) {
            if (pos == 0 && this.childrenCount == 1) {
                return this.oneChild;
            }
            if (pos < this.childrenCount) {
                return this.children.elementAt(pos);
            }
            throw new IllegalArgumentException("no child at position " + pos);
        }
        throw new IllegalArgumentException("this node has no children");
    }

    public void setParentNode(XmlNode parent) {
        this.parent = parent;
    }

    public void appendChild(Object child) throws XmlPullParserException {
        if (this.childrenCount == 0) {
            this.oneChild = child;
        } else {
            if (this.children == null) {
                this.children = new Vector(4, 4);
            }
            if (this.childrenCount == 1) {
                if (this.children.size() > 0) {
                    this.children.removeAllElements();
                }
                this.children.addElement(this.oneChild);
                this.oneChild = null;
            }
            this.children.addElement(child);
        }
        if (child instanceof XmlNode) {
            ((XmlNode)child).setParentNode(this);
        }
        ++this.childrenCount;
    }

    public void insertChildAt(int pos, Object child) throws XmlPullParserException {
        if (this.childrenCount == 0) {
            if (pos != 0) {
                throw new XmlPullParserException("to insert first child position must be 0 not " + pos);
            }
            this.oneChild = child;
        } else {
            if (this.children == null) {
                this.children = new Vector(4, 4);
            }
            if (this.childrenCount == 1) {
                if (this.children.size() > 0) {
                    this.children.removeAllElements();
                }
                this.children.addElement(this.oneChild);
            }
            this.children.insertElementAt(child, pos);
        }
        if (child instanceof XmlNode) {
            ((XmlNode)child).setParentNode(this);
        }
        ++this.childrenCount;
    }

    public void removeChildAt(int pos) throws XmlPullParserException {
        Object removedChild = null;
        if (this.childrenCount == 0) {
            throw new XmlPullParserException("node has no children to remove");
        }
        if (this.childrenCount == 1) {
            if (pos != 0) {
                throw new XmlPullParserException("to remove last child position must be 0 not " + pos);
            }
            removedChild = this.oneChild;
            this.oneChild = null;
        } else if (this.childrenCount == 2) {
            if (pos == 0) {
                this.oneChild = this.children.elementAt(1);
                removedChild = this.children.elementAt(0);
            } else if (pos == 1) {
                this.oneChild = this.children.elementAt(0);
                removedChild = this.children.elementAt(1);
            } else {
                throw new XmlPullParserException("only two children position must 0 or 1 but not " + pos);
            }
            this.children.removeAllElements();
        } else {
            removedChild = this.children.elementAt(pos);
            this.children.removeElementAt(pos);
        }
        if (removedChild instanceof XmlNode) {
            ((XmlNode)removedChild).setParentNode(null);
        }
        --this.childrenCount;
    }

    public void replaceChildAt(int pos, Object child) throws XmlPullParserException {
        if (this.childrenCount == 1) {
            if (pos != 0) {
                throw new XmlPullParserException("to set first child position must be 0 not " + pos);
            }
            this.oneChild = child;
        } else if (this.childrenCount > 1) {
            this.children.setElementAt(child, pos);
        } else {
            throw new XmlPullParserException("node must have at least one children to set child at " + pos);
        }
        if (child instanceof XmlNode) {
            ((XmlNode)child).setParentNode(this);
        }
    }

    public void ensureChildrenCapacity(int minCapacity) throws XmlPullParserException {
        if (minCapacity <= 1) {
            return;
        }
        if (this.children == null) {
            this.children = new Vector(minCapacity, 4);
        } else {
            this.children.ensureCapacity(minCapacity);
        }
    }

    public void removeChildren() throws XmlPullParserException {
        if (this.childrenCount == 1 && this.oneChild instanceof XmlNode) {
            ((XmlNode)this.oneChild).setParentNode(null);
        }
        this.oneChild = null;
        if (this.children != null && this.children.size() > 0) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                Object child = enumeration.nextElement();
                if (!(child instanceof XmlNode)) continue;
                ((XmlNode)child).setParentNode(null);
            }
            this.children.removeAllElements();
        }
        this.childrenCount = 0;
    }

    public String getQNameLocal(String qName) {
        int i = qName.lastIndexOf(58);
        return qName.substring(i + 1);
    }

    public String getQNameUri(String qName) {
        int i = qName.lastIndexOf(58);
        if (i > 0) {
            String prefix = qName.substring(0, i);
            try {
                return this.prefix2Namespace(prefix);
            }
            catch (XmlPullParserException ex) {
                throw new PullParserRuntimeException(ex);
            }
        }
        return this.defaultNamespaceUri;
    }

    public String prefix2Namespace(String prefix) throws XmlPullParserException {
        if (prefix == null) {
            return null;
        }
        if ("".equals(prefix)) {
            return this.defaultNamespaceUri;
        }
        String namespaceUri = null;
        if (this.declaredNsEnd > 0) {
            if (this.prefix2Ns == null) {
                this.prefix2Ns = new Hashtable();
                for (int i = 0; i < this.declaredNsEnd; ++i) {
                    this.prefix2Ns.put(this.declaredPrefixes[i], this.declaredNs[i]);
                }
            }
            namespaceUri = (String)this.prefix2Ns.get(prefix);
        }
        if (this.parent != null && namespaceUri == null) {
            return this.parent.prefix2Namespace(prefix);
        }
        return namespaceUri;
    }

    public String namespace2Prefix(String namespaceUri) throws XmlPullParserException {
        if (namespaceUri == null) {
            throw new XmlPullParserException("null is not allowed for namespace name");
        }
        if (namespaceUri.equals(this.getDefaultNamespaceUri())) {
            return "";
        }
        for (int i = 0; i < this.declaredNsEnd; ++i) {
            if (!namespaceUri.equals(this.declaredNs[i])) continue;
            return this.declaredPrefixes[i];
        }
        if (this.parent != null) {
            return this.parent.namespace2Prefix(namespaceUri);
        }
        return null;
    }

    public String getDefaultNamespaceUri() {
        return this.defaultNamespaceUri;
    }

    public void setDefaultNamespaceUri(String defaultNamespaceUri) {
        this.defaultNamespaceUri = defaultNamespaceUri;
    }

    public int getDeclaredNamespaceLength() {
        return this.declaredNsEnd;
    }

    public void readDeclaredNamespaceUris(String[] uris, int off, int len) {
        if (len > this.declaredNsEnd) {
            throw new IllegalArgumentException("this node has only " + this.declaredNsEnd + " namespace URIs and not " + len);
        }
        if (this.declaredNs != null) {
            System.arraycopy(this.declaredNs, 0, uris, off, len);
        }
    }

    public void readDeclaredPrefixes(String[] prefixes, int off, int len) {
        if (len > this.declaredNsEnd) {
            throw new IllegalArgumentException("this node has only " + this.declaredNsEnd + " prefixes and nor " + len);
        }
        if (this.declaredPrefixes != null) {
            System.arraycopy(this.declaredPrefixes, 0, prefixes, off, len);
        }
    }

    public void ensureDeclaredNamespacesCapacity(int minCapacity) {
        if (this.declaredNs == null || this.declaredNs.length < minCapacity) {
            String[] newDeclaredNs = new String[minCapacity];
            String[] newDeclaredPrefixes = new String[minCapacity];
            if (this.declaredNsEnd > 0) {
                System.arraycopy(this.declaredNs, 0, newDeclaredNs, 0, this.declaredNsEnd);
                System.arraycopy(this.declaredPrefixes, 0, newDeclaredPrefixes, 0, this.declaredNsEnd);
            }
            this.declaredNs = newDeclaredNs;
            this.declaredPrefixes = newDeclaredPrefixes;
        }
    }

    public void addNamespaceDeclaration(String prefix, String namespaceUri) throws XmlPullParserException {
        Object exisitingNs;
        if (this.prefix2Ns != null && (exisitingNs = this.prefix2Ns.get(prefix)) != null) {
            throw new IllegalArgumentException("prefix '" + prefix + "' already bound to '" + exisitingNs + "' (and can not be rebound to '" + namespaceUri + "'");
        }
        this.ensureDeclaredNamespacesCapacity(this.declaredNsEnd + 1);
        this.declaredNs[this.declaredNsEnd] = namespaceUri;
        this.declaredPrefixes[this.declaredNsEnd] = prefix;
        ++this.declaredNsEnd;
        if (this.prefix2Ns != null) {
            this.prefix2Ns.put(prefix, namespaceUri);
        }
    }

    public void addDeclaredNamespaces(String[] prefix, int off, int len, String[] namespaceUri) {
        int i;
        if (len == 0) {
            return;
        }
        if (len < 0) {
            throw new IllegalArgumentException("number of added namespaces can not be negative");
        }
        if (this.prefix2Ns != null) {
            for (i = 0; i < prefix.length; ++i) {
                String pref = prefix[i];
                Object exisitingNs = this.prefix2Ns.get(pref);
                if (exisitingNs == null) continue;
                throw new IllegalArgumentException("prefix '" + pref + "' already bound to '" + exisitingNs + "' (and can not be rebound to '" + namespaceUri[i] + "'");
            }
        }
        this.ensureDeclaredNamespacesCapacity(this.declaredNsEnd + len);
        System.arraycopy(namespaceUri, off, this.declaredNs, this.declaredNsEnd, len);
        System.arraycopy(prefix, off, this.declaredPrefixes, this.declaredNsEnd, len);
        this.declaredNsEnd += len;
        if (this.prefix2Ns != null) {
            for (i = off; i < off + len; ++i) {
                this.prefix2Ns.put(prefix[i], namespaceUri[i]);
            }
        }
    }

    public void removeDeclaredNamespaces() {
        this.prefix2Ns = null;
        this.declaredNsEnd = 0;
        this.defaultNamespaceUri = null;
    }

    protected void printFields(StringBuffer buf) {
        super.printFields(buf);
        buf.append(" children=[ ");
        if (this.childrenCount == 0) {
            buf.append("");
        } else if (this.childrenCount == 1) {
            buf.append("'");
            buf.append(this.oneChild);
            buf.append("'");
        } else if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                buf.append('\'');
                buf.append(this.children.elementAt(i));
                buf.append("', ");
            }
        }
        buf.append(" ]");
        XmlNode parent = this.getParentNode();
        String defaultUri = this.getDefaultNamespaceUri();
        if (!(defaultUri == null || parent != null && defaultUri.equals(parent.getDefaultNamespaceUri()))) {
            buf.append(" xmlns='");
            buf.append(defaultUri);
            buf.append('\'');
        }
        if (this.declaredNsEnd > 0) {
            buf.append(" namespaces = [");
            for (int i = 0; i < this.declaredNsEnd; ++i) {
                buf.append(" xmlns:");
                buf.append(this.declaredPrefixes[i]);
                buf.append("='");
                buf.append(this.declaredNs[i]);
                buf.append("'");
            }
            buf.append(" ]");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Node={");
        this.printFields(buf);
        buf.append(" }");
        return buf.toString();
    }
}

