/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.wan.sla;

import com.ubnt.data.Site;
import com.ubnt.model.api.wan.loadbalancing.sla.WanSlaDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.config.ubios.wanfailover.sla.B;
import com.ubnt.service.config.ubios.wanfailover.sla.WanSlaDocument;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Validated
@Tag(name="WAN Service Level Agreements")
public class WanSlaController {
    private final B o00000;

    @GetMapping(value={"/api/site/{siteName}/wan-slas"})
    @Operation(summary="List WAN SLAs")
    public List<WanSlaDto> listWanSlas(@PathVariable(value="siteName") Site site) {
        return this.o00000.class(site.getId()).stream().map(WanSlaDto::fromDocument).toList();
    }

    @GetMapping(value={"/api/site/{siteName}/wan-slas/{id}"})
    @Operation(summary="Get WAN SLA")
    public WanSlaDto getWanSla(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        return WanSlaDto.fromDocument(this.o00000.\u00d200000(string));
    }

    @PostMapping(value={"/api/site/{siteName}/wan-slas"}, consumes={"application/json"})
    @Operation(summary="Create a new WAN SLA")
    @ResponseStatus(value=HttpStatus.CREATED)
    public WanSlaDto createWanSla(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull WanSlaDto wanSlaDto) {
        return WanSlaDto.fromDocument(this.o00000.\u00d2O0000(wanSlaDto.toDocument(site.getId())));
    }

    @PutMapping(value={"/api/site/{siteName}/wan-slas/{id}"}, consumes={"application/json"})
    @Operation(summary="Update a WAN SLA")
    public WanSlaDto updateWanSla(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string, @RequestBody @Valid @NotNull WanSlaDto wanSlaDto) {
        WanSlaDto wanSlaDto2 = WanSlaDto.withId(wanSlaDto, string);
        WanSlaDocument wanSlaDocument = this.o00000.\u00d4O0000(wanSlaDto2.toDocument(site.getId()));
        return WanSlaDto.fromDocument(wanSlaDocument);
    }

    @DeleteMapping(value={"/api/site/{siteName}/wan-slas/{id}"})
    @Operation(summary="Delete a WAN SLA")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteWanSla(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        this.o00000.super(string);
    }

    @PostMapping(value={"/api/site/{siteName}/wan-slas/batch-delete"})
    @Operation(summary="Batch delete WAN SLAs")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void batchDeleteWanSlas(@PathVariable(value="siteName") Site site, @RequestBody @NotEmpty List<String> list) {
        this.o00000.\u00d300000(list, site.getId());
    }

    @ConstructorProperties(value={"wanSlaService"})
    @Generated
    public WanSlaController(B b2) {
        this.o00000 = b2;
    }
}

