/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.trafficflow;

import com.ubnt.data.Site;
import com.ubnt.model.api.stats.StatsPeriod;
import com.ubnt.model.api.trafficflow.TrafficFlowDto;
import com.ubnt.model.api.trafficflow.TrafficFlowFilterDataDto;
import com.ubnt.model.api.trafficflow.TrafficFlowFilterDataParametersDto;
import com.ubnt.model.api.trafficflow.TrafficFlowListDto;
import com.ubnt.model.api.trafficflow.TrafficFlowParametersDto;
import com.ubnt.model.api.trafficstats.AppTrafficDto;
import com.ubnt.net.E;
import com.ubnt.net.interface;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.service.stat.dpi.OoOO;
import com.ubnt.service.trafficflow.IA;
import com.ubnt.service.trafficflow.l;
import com.ubnt.service.trafficflow.search.A.D;
import com.ubnt.service.trafficflow.stats.F;
import com.ubnt.service.trafficflow.stats.dto.TrafficFlowStatisticsDto;
import com.ubnt.service.trafficflow.stats.oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import reactor.core.publisher.Flux;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Traffic Flow")
public class TrafficFlowController {
    static final int \u00d400000 = 30;
    static final int Object = 100;
    private final IA \u00f400000;
    private final l void;
    private final F \u00d600000;
    private final OoOO o00000;
    private final Clock \u00d200000;
    private final oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO \u00d500000;

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/traffic-flows"})
    @Operation(summary="List Traffic Flows", description="Since 9.1.64")
    public TrafficFlowListDto listTrafficFlows(@PathVariable(value="siteName") Site site, @RequestBody @Valid TrafficFlowParametersDto trafficFlowParametersDto) {
        Page<TrafficFlowDto> page = this.\u00f400000.\u00d2O0000(site.getId(), this.void.\u00d300000(trafficFlowParametersDto));
        return TrafficFlowListDto.of(page);
    }

    @GetMapping(value={"/api/site/{siteName}/traffic-flows/{id}"})
    @Operation(summary="Get Traffic Flow by ID", description="Since 9.2.60")
    public TrafficFlowDto getTrafficFlowById(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        return this.\u00f400000.\u00d500000(string, site.getId()).orElseThrow(D::new);
    }

    @GetMapping(value={"/api/site/{siteName}/traffic-flows/alarm/{alarmId}"})
    @Operation(summary="Get Traffic Flow by IPS alarm ID", description="Since 9.1.98")
    public TrafficFlowDto getTrafficFlowByAlarmId(@PathVariable(value="siteName") Site site, @PathVariable(value="alarmId") String string) {
        return this.\u00f400000.\u00d5O0000(site.getId(), string).orElseThrow(D::new);
    }

    @PostMapping(value={"/api/site/{siteName}/traffic-flows/export"}, consumes={"application/json"}, produces={"text/csv"})
    @AllowReadPrivileges
    @Operation(summary="Export Traffic Flows in CSV format", description="Since 9.1.93")
    public ResponseBodyEmitter exportTrafficFlows(@PathVariable(value="siteName") Site site, @RequestBody @Valid TrafficFlowParametersDto trafficFlowParametersDto) {
        E e2 = new E();
        Flux<String> flux = this.\u00f400000.for(site.getId(), this.void.\u00d300000(trafficFlowParametersDto));
        e2.onTimeout(() -> flux.subscribe().dispose());
        e2.onCompletion(() -> flux.subscribe().dispose());
        flux.subscribe(string -> {
            try {
                e2.send(string, interface.o00000);
            }
            catch (Exception exception) {
                e2.completeWithError(exception);
            }
        }, arg_0 -> ((ResponseBodyEmitter)e2).completeWithError(arg_0), () -> ((ResponseBodyEmitter)e2).complete());
        return e2;
    }

    @AllowReadPrivileges
    @Operation(summary="Get traffic flow stats for the last 1H/1D/1W/1M", description="Since 9.1.82")
    @GetMapping(value={"/api/site/{siteName}/traffic-flow-latest-statistics"})
    public TrafficFlowStatisticsDto getTrafficFlowStats(@PathVariable(value="siteName") Site site, @RequestParam(value="period") StatsPeriod statsPeriod, @RequestParam(value="top", required=false) Integer n3) {
        Instant instant = this.\u00d200000.instant();
        long l2 = statsPeriod.subtractFrom(instant).toEpochMilli();
        long l3 = instant.toEpochMilli();
        com.ubnt.service.trafficflow.stats.D d2 = this.\u00d600000.\u00f5Oo000(site.getId(), l2, l3).get(0);
        List<AppTrafficDto> list = this.o00000.\u00d5oo000(site.getId(), l2, l3);
        return this.\u00d500000.\u00d500000(site, d2, list, Optional.ofNullable(n3).map(n2 -> Math.max(Math.min(n2, 100), 1)).orElse(30));
    }

    @GetMapping(value={"/api/site/{siteName}/traffic-flows/filter-data"})
    @Operation(summary="Get Traffic Flows filter data", description="Since 9.1.100")
    public TrafficFlowFilterDataDto getTrafficFlowFilterData(@PathVariable(value="siteName") Site site, @Valid TrafficFlowFilterDataParametersDto trafficFlowFilterDataParametersDto) {
        return this.\u00f400000.\u00d300000(site.getId(), this.void.\u00d200000(trafficFlowFilterDataParametersDto));
    }

    @ConstructorProperties(value={"trafficFlowService", "trafficFlowParametersDtoMapper", "summarizedTrafficFlowStatisticsProvider", "summarizedGatewayDpiStatisticsProvider", "clock", "trafficFlowStatisticsDtoMapper"})
    @Generated
    public TrafficFlowController(IA iA2, l l2, F f2, OoOO ooOO2, Clock clock, oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2) {
        this.\u00f400000 = iA2;
        this.void = l2;
        this.\u00d600000 = f2;
        this.o00000 = ooOO2;
        this.\u00d200000 = clock;
        this.\u00d500000 = oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2;
    }
}

