/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.firewall;

import com.ubnt.data.Site;
import com.ubnt.model.api.firewall.qos.QosRuleDto;
import com.ubnt.model.api.firewall.qos.QosRuleUpdateDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.firewall.qos.E;
import com.ubnt.service.firewall.qos.J;
import com.ubnt.service.firewall.qos.QosRuleDocument;
import com.ubnt.service.object.oriented.network.N;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="QoS Rules")
public class FirewallQosRuleController {
    private final E o00000;
    private final N new;

    @GetMapping(value={"/api/site/{siteName}/qos-rules"})
    @Operation(summary="List QoS Rules")
    public List<QosRuleDto> listQosRules(@PathVariable(value="siteName") Site site) {
        String string = site.getId();
        Stream<QosRuleDto> stream = this.o00000.null(string).stream().map(QosRuleDto::fromDocument);
        Stream stream2 = this.new.\u00d200000(string).stream();
        return Stream.concat(stream, stream2).toList();
    }

    @GetMapping(value={"/api/site/{siteName}/qos-rules/{id}"})
    @Operation(summary="Get QoS Rule")
    public QosRuleDto getQosRule(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        return QosRuleDto.fromDocument(this.o00000.\u00d200000(string));
    }

    @PostMapping(value={"/api/site/{siteName}/qos-rules"}, consumes={"application/json"})
    @Operation(summary="Create a new QoS Rule")
    @ResponseStatus(value=HttpStatus.CREATED)
    public QosRuleDto createQosRule(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull QosRuleDto qosRuleDto) {
        return QosRuleDto.fromDocument(this.o00000.\u00d500000(qosRuleDto.toDocument(site.getId())));
    }

    @PutMapping(value={"/api/site/{siteName}/qos-rules/{id}"}, consumes={"application/json"})
    @Operation(summary="Update QoS Rule")
    public QosRuleDto updateQosRule(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string, @RequestBody @Valid @NotNull QosRuleDto qosRuleDto) {
        QosRuleDto qosRuleDto2 = QosRuleDto.withId(qosRuleDto, string);
        QosRuleDocument qosRuleDocument = this.o00000.\u00f500000(qosRuleDto2.toDocument(site.getId()));
        return QosRuleDto.fromDocument(qosRuleDocument);
    }

    @DeleteMapping(value={"/api/site/{siteName}/qos-rules/{id}"})
    @Operation(summary="Delete QoS Rule")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteQosRule(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        this.o00000.String(string);
    }

    @PostMapping(value={"/api/site/{siteName}/qos-rules/batch-delete"})
    @Operation(summary="Batch delete QoS Rules")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void batchDeleteQosRules(@PathVariable(value="siteName") Site site, @RequestBody @NotEmpty List<String> list) {
        this.o00000.\u00d800000(list, site.getId());
    }

    @PutMapping(value={"/api/site/{siteName}/qos-rules/batch"})
    @Operation(summary="Batch update QoS Rules")
    public List<QosRuleDto> batchUpdateQosRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<QosRuleUpdateDto> list) {
        List<J> list2 = list.stream().map(QosRuleUpdateDto::toUpdate).toList();
        List<QosRuleDocument> list3 = this.o00000.\u00f800000(list2, site.getId());
        return list3.stream().map(QosRuleDto::fromDocument).toList();
    }

    @PutMapping(value={"/api/site/{siteName}/qos-rules/batch-reorder"})
    @Operation(summary="Batch update QoS Rules")
    public List<QosRuleDto> batchReorderQosRules(@PathVariable(value="siteName") Site site, @RequestBody @NotEmpty List<String> list) {
        List<QosRuleDocument> list2 = this.o00000.o00000(list, site.getId());
        return list2.stream().map(QosRuleDto::fromDocument).toList();
    }

    @ConstructorProperties(value={"qosRuleService", "objectOrientedNetworkService"})
    @Generated
    public FirewallQosRuleController(E e2, N n2) {
        this.o00000 = e2;
        this.new = n2;
    }
}

