/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.integration.api.network.dto.details;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.ubnt.net.Dto;
import com.ubnt.net.integration.api.network.dto.details.IntegrationNetworkIpv6ClientAddressAssignmentDto;
import com.ubnt.net.integration.api.network.dto.details.IntegrationNetworkIpv6PrefixDelegationConfigurationDto;
import com.ubnt.net.integration.api.network.dto.details.IntegrationNetworkIpv6RouterAdvertisementDto;
import com.ubnt.net.integration.api.network.dto.details.IntegrationNetworkIpv6StaticConfigurationDto;
import com.ubnt.net.v2.validation.constraints.IpV6;
import com.ubnt.net.v2.validation.constraints.IpV6Cidr;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="interfaceType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=IntegrationNetworkIpv6PrefixDelegationConfigurationDto.class, name="PREFIX_DELEGATION"), @JsonSubTypes.Type(value=IntegrationNetworkIpv6StaticConfigurationDto.class, name="STATIC")})
@Schema(name="Network IPv6 Configuration", discriminatorProperty="interfaceType", discriminatorMapping={@DiscriminatorMapping(value="PREFIX_DELEGATION", schema=IntegrationNetworkIpv6PrefixDelegationConfigurationDto.class), @DiscriminatorMapping(value="STATIC", schema=IntegrationNetworkIpv6StaticConfigurationDto.class)})
public abstract class IntegrationNetworkIpv6ConfigurationDto
implements Dto {
    @Valid
    @NotNull
    @Schema(description="Client Address Assignment")
    private final IntegrationNetworkIpv6ClientAddressAssignmentDto clientAddressAssignment;
    @Nullable
    @Valid
    @Schema(description="Router advertisement. Without it, hosts will not autoconfigure addresses and will lack a default route even with DHCPv6.")
    private final IntegrationNetworkIpv6RouterAdvertisementDto routerAdvertisement;
    @Nullable
    @Size(min=1, max=4)
    @Schema(description="The IPv6 DNS server addresses assigned to this Network. If none are specified, they will be selected automatically.")
    @ArraySchema(minItems=1, maxItems=4)
    private final @Size(min=1, max=4) List<@NotNull @IpV6 String> dnsServerIpAddressesOverride;
    @Nullable
    @Size(min=1, max=4)
    @ArraySchema(minItems=1, maxItems=4)
    @Schema(description="Additional host IP subnets assigned to this VLAN.")
    private final @Size(min=1, max=4) List<@NotNull @IpV6Cidr String> additionalHostIpSubnets;

    @Generated
    protected IntegrationNetworkIpv6ConfigurationDto(IntegrationNetworkIpv6ConfigurationDtoBuilder<?, ?> integrationNetworkIpv6ConfigurationDtoBuilder) {
        this.clientAddressAssignment = integrationNetworkIpv6ConfigurationDtoBuilder.String;
        this.routerAdvertisement = integrationNetworkIpv6ConfigurationDtoBuilder.o00000;
        this.dnsServerIpAddressesOverride = integrationNetworkIpv6ConfigurationDtoBuilder.\u00d200000;
        this.additionalHostIpSubnets = integrationNetworkIpv6ConfigurationDtoBuilder.\u00d300000;
    }

    @Generated
    public IntegrationNetworkIpv6ClientAddressAssignmentDto getClientAddressAssignment() {
        return this.clientAddressAssignment;
    }

    @Nullable
    @Generated
    public IntegrationNetworkIpv6RouterAdvertisementDto getRouterAdvertisement() {
        return this.routerAdvertisement;
    }

    @Nullable
    @Generated
    public List<@NotNull @IpV6 String> getDnsServerIpAddressesOverride() {
        return this.dnsServerIpAddressesOverride;
    }

    @Nullable
    @Generated
    public List<@NotNull @IpV6Cidr String> getAdditionalHostIpSubnets() {
        return this.additionalHostIpSubnets;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntegrationNetworkIpv6ConfigurationDto)) {
            return false;
        }
        IntegrationNetworkIpv6ConfigurationDto integrationNetworkIpv6ConfigurationDto = (IntegrationNetworkIpv6ConfigurationDto)object;
        if (!integrationNetworkIpv6ConfigurationDto.canEqual(this)) {
            return false;
        }
        IntegrationNetworkIpv6ClientAddressAssignmentDto integrationNetworkIpv6ClientAddressAssignmentDto = this.getClientAddressAssignment();
        IntegrationNetworkIpv6ClientAddressAssignmentDto integrationNetworkIpv6ClientAddressAssignmentDto2 = integrationNetworkIpv6ConfigurationDto.getClientAddressAssignment();
        if (integrationNetworkIpv6ClientAddressAssignmentDto == null ? integrationNetworkIpv6ClientAddressAssignmentDto2 != null : !((Object)integrationNetworkIpv6ClientAddressAssignmentDto).equals(integrationNetworkIpv6ClientAddressAssignmentDto2)) {
            return false;
        }
        IntegrationNetworkIpv6RouterAdvertisementDto integrationNetworkIpv6RouterAdvertisementDto = this.getRouterAdvertisement();
        IntegrationNetworkIpv6RouterAdvertisementDto integrationNetworkIpv6RouterAdvertisementDto2 = integrationNetworkIpv6ConfigurationDto.getRouterAdvertisement();
        if (integrationNetworkIpv6RouterAdvertisementDto == null ? integrationNetworkIpv6RouterAdvertisementDto2 != null : !((Object)integrationNetworkIpv6RouterAdvertisementDto).equals(integrationNetworkIpv6RouterAdvertisementDto2)) {
            return false;
        }
        List<String> list = this.getDnsServerIpAddressesOverride();
        List<String> list2 = integrationNetworkIpv6ConfigurationDto.getDnsServerIpAddressesOverride();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<String> list3 = this.getAdditionalHostIpSubnets();
        List<String> list4 = integrationNetworkIpv6ConfigurationDto.getAdditionalHostIpSubnets();
        return !(list3 == null ? list4 != null : !((Object)list3).equals(list4));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof IntegrationNetworkIpv6ConfigurationDto;
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        IntegrationNetworkIpv6ClientAddressAssignmentDto integrationNetworkIpv6ClientAddressAssignmentDto = this.getClientAddressAssignment();
        n2 = n2 * 59 + (integrationNetworkIpv6ClientAddressAssignmentDto == null ? 43 : ((Object)integrationNetworkIpv6ClientAddressAssignmentDto).hashCode());
        IntegrationNetworkIpv6RouterAdvertisementDto integrationNetworkIpv6RouterAdvertisementDto = this.getRouterAdvertisement();
        n2 = n2 * 59 + (integrationNetworkIpv6RouterAdvertisementDto == null ? 43 : ((Object)integrationNetworkIpv6RouterAdvertisementDto).hashCode());
        List<String> list = this.getDnsServerIpAddressesOverride();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<String> list2 = this.getAdditionalHostIpSubnets();
        n2 = n2 * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        return n2;
    }

    @Generated
    public static abstract class IntegrationNetworkIpv6ConfigurationDtoBuilder<C extends IntegrationNetworkIpv6ConfigurationDto, B extends IntegrationNetworkIpv6ConfigurationDtoBuilder<C, B>> {
        @Generated
        private IntegrationNetworkIpv6ClientAddressAssignmentDto String;
        @Generated
        private IntegrationNetworkIpv6RouterAdvertisementDto o00000;
        @Generated
        private List<@NotNull @IpV6 String> \u00d200000;
        @Generated
        private List<@NotNull @IpV6Cidr String> \u00d300000;

        @Generated
        public B clientAddressAssignment(IntegrationNetworkIpv6ClientAddressAssignmentDto integrationNetworkIpv6ClientAddressAssignmentDto) {
            this.String = integrationNetworkIpv6ClientAddressAssignmentDto;
            return this.o00000();
        }

        @Generated
        public B routerAdvertisement(@Nullable IntegrationNetworkIpv6RouterAdvertisementDto integrationNetworkIpv6RouterAdvertisementDto) {
            this.o00000 = integrationNetworkIpv6RouterAdvertisementDto;
            return this.o00000();
        }

        @Generated
        public B dnsServerIpAddressesOverride(@Nullable List<@NotNull @IpV6 String> list) {
            this.\u00d200000 = list;
            return this.o00000();
        }

        @Generated
        public B additionalHostIpSubnets(@Nullable List<@NotNull @IpV6Cidr String> list) {
            this.\u00d300000 = list;
            return this.o00000();
        }

        @Generated
        protected abstract B o00000();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "IntegrationNetworkIpv6ConfigurationDto.IntegrationNetworkIpv6ConfigurationDtoBuilder(clientAddressAssignment=" + java.lang.String.valueOf(this.String) + ", routerAdvertisement=" + java.lang.String.valueOf(this.o00000) + ", dnsServerIpAddressesOverride=" + java.lang.String.valueOf(this.\u00d200000) + ", additionalHostIpSubnets=" + java.lang.String.valueOf(this.\u00d300000) + ")";
        }
    }
}

