/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.uid;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.F.OOoO;
import com.ubnt.data.NetworkConf;
import com.ubnt.data.RadiusProfile;
import com.ubnt.data.X;
import com.ubnt.model.M.B.OoOO;
import com.ubnt.model.api.network.configuration.NetworkPurpose;
import com.ubnt.model.api.network.configuration.VpnNetworkProtocol;
import com.ubnt.model.api.uid.ImmutableUidVpnServerConfigurationDto;
import com.ubnt.model.api.uid.ImmutableUidVpnServerRadiusConfigurationDto;
import com.ubnt.model.api.uid.UidVpnServerRadiusConfigurationDto;
import com.ubnt.model.api.uid.UidVpnType;
import com.ubnt.net.v2.validation.constraints.Ip;
import com.ubnt.net.v2.validation.constraints.IpCidr;
import com.ubnt.net.v2.validation.constraints.IpV4OrSubnet;
import com.ubnt.net.v2.validation.constraints.IpV6Cidr;
import com.ubnt.service.sso.messagebox.oOOo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;

@Schema(name="UID VPN Server Configuration")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableUidVpnServerConfigurationDto.class)
@JsonDeserialize(as=ImmutableUidVpnServerConfigurationDto.class)
@Value.Immutable
@OOoO
public abstract class UidVpnServerConfigurationDto
implements oOOo {
    @JsonProperty(value="vpn_type")
    @Schema(name="By default \"openvpn\", for backward compatibility")
    @Value.Default
    public UidVpnType getVpnType() {
        return UidVpnType.OPENVPN;
    }

    @JsonProperty(value="enabled")
    public abstract boolean isEnabled();

    @JsonProperty(value="name")
    @NotEmpty
    @Schema(required=true)
    public abstract String getName();

    @Schema(example="5e6285ec05938c3d128aaa07", accessMode=Schema.AccessMode.READ_ONLY)
    @JsonProperty(value="networkconf_id")
    @Nullable
    public abstract String getNetworkConfId();

    @JsonProperty(value="ip_subnet")
    public abstract Optional<@IpCidr String> getIpSubnet();

    @JsonProperty(value="ipv6_subnet")
    public abstract Optional<@IpV6Cidr String> getIpv6Subnet();

    @JsonProperty(value="dns")
    @Ip
    public abstract List<String> getDns();

    @JsonProperty(value="local_wan_ip")
    public abstract Optional<@Ip String> getLocalWanIp();

    @JsonProperty(value="server_port")
    @Min(value=1L)
    @Max(value=65535L)
    public abstract @Min(value=1L) @Max(value=65535L) int getServerPort();

    @JsonProperty(value="public_gateway_port")
    @Schema(description="If VPN is behind NAT, user can set a port forward on a 3rd party gateway. In this case, the UID App may use this port to connect to the VPN")
    public abstract Optional<@Min(value=1L) @Max(value=65535L) Integer> publicGatewayPort();

    @JsonProperty(value="radius")
    public abstract Optional<@Valid UidVpnServerRadiusConfigurationDto> getRadius();

    @JsonProperty(value="ca_crt")
    @Schema(name="Required only for Open VPN")
    public abstract Optional<String> getCaCrt();

    @JsonProperty(value="ca_key")
    @Schema(name="Required only for Open VPN")
    public abstract Optional<String> getCaKey();

    @JsonProperty(value="server_crt")
    @Schema(name="Required only for Open VPN")
    public abstract Optional<String> getServerCrt();

    @JsonProperty(value="server_key")
    @Schema(name="Server Key for OpenVPN, or Private Key of WireGuard Server")
    public abstract String getServerKey();

    @JsonProperty(value="auth_key")
    @Schema(name="Required only for Open VPN")
    public abstract Optional<String> getAuthKey();

    @JsonProperty(value="dh_key")
    @Schema(name="Required only for Open VPN")
    public abstract Optional<String> getDhKey();

    @Schema(name="VPN Server protocol.")
    @JsonProperty(value="protocol")
    public abstract VpnNetworkProtocol getProtocol();

    @JsonProperty(value="renegotiation_timeout")
    @Schema(name="Renegotiate data channel key after n seconds (OpenVPN only)")
    public abstract Optional<@Min(value=1L) @Max(value=345600L) Integer> getRenegotiationTimeout();

    @JsonProperty(value="strict_client_common_name")
    @Schema(description="If true, then client certificate's common name must match client's username. Effective for the server mode only (OpenVPN only)")
    public abstract boolean isStrictClientCommonName();

    @JsonProperty(value="uid_workspace_url")
    public abstract Optional<String> uidWorkspaceUrl();

    @JsonProperty(value="masquerade_enabled")
    public abstract boolean masqueradeEnabled();

    @JsonProperty(value="uid_policy_name")
    public abstract Optional<String> uidPolicyName();

    @JsonProperty(value="uid_policy_enabled")
    public abstract boolean uidPolicyEnabled();

    @JsonProperty(value="custom_routing")
    public abstract List<@IpV4OrSubnet String> customRouting();

    @JsonProperty(value="default_dns_suffix")
    public abstract Optional<String> defaultDnsSuffix();

    @JsonProperty(value="sync_public_ip")
    public abstract boolean syncPublicIp();

    @JsonProperty(value="mac_connection_time_seconds")
    public abstract Optional<Integer> maxConnectionTimeSeconds();

    public static UidVpnServerConfigurationDto fromWireguard(NetworkConf networkConf) {
        return ImmutableUidVpnServerConfigurationDto.builder().vpnType(UidVpnType.WIREGUARD).networkConfId(networkConf.getId()).isEnabled(networkConf.isEnabled()).name(networkConf.getName()).ipSubnet(networkConf.getIpSubnetOrNull()).localWanIp(networkConf.getWireguardLocalWanIp().filter(StringUtils::isNotEmpty).filter(string -> !"any".equals(string))).masqueradeEnabled(networkConf.isUidVpnMasqueradeEnabled()).serverPort(networkConf.getLocalPort()).publicGatewayPort(networkConf.getUidPublicGatewayPort()).dns(networkConf.getDhcpdDnsPrefixedList()).serverKey(networkConf.getWireguardPrivateKey().orElse("")).uidWorkspaceUrl(networkConf.getUidWorkspaceUrl()).uidPolicyEnabled(networkConf.isUidPolicyEnabled()).uidPolicyName(networkConf.getUidPolicyName()).customRouting(networkConf.getUidVpnCustomRouting()).defaultDnsSuffix(networkConf.getUidVpnDefaultDnsSuffix()).syncPublicIp(networkConf.isUidVpnSyncPublicIp()).maxConnectionTimeSeconds(networkConf.getUidVpnMaxConnectionTime()).build();
    }

    public static UidVpnServerConfigurationDto fromOpenVpn(NetworkConf networkConf, RadiusProfile radiusProfile) {
        if (networkConf == null || radiusProfile == null) {
            return null;
        }
        List<X> list = radiusProfile.getAuthenticationServers();
        List<X> list2 = radiusProfile.getAccountingServers();
        ImmutableUidVpnServerRadiusConfigurationDto immutableUidVpnServerRadiusConfigurationDto = null;
        if (!list.isEmpty()) {
            X x2 = list.get(0);
            X x3 = !list2.isEmpty() ? list2.get(0) : X.\u00f4\u00d30000;
            immutableUidVpnServerRadiusConfigurationDto = UidVpnServerRadiusConfigurationDto.builder().ip(x2.getString("ip")).authPort(x2.getInt("port")).secret(x2.getString("x_secret")).acctPort(Optional.ofNullable(x3.getIntOrNull("port"))).build();
        }
        return ImmutableUidVpnServerConfigurationDto.builder().vpnType(UidVpnType.OPENVPN).networkConfId(networkConf.getId()).isEnabled(networkConf.isEnabled()).name(networkConf.getName()).ipSubnet(networkConf.getIpSubnetOrNull()).ipv6Subnet(networkConf.getIpV6Subnet()).localWanIp(networkConf.getOpenVpnLocalWanIp().filter(StringUtils::isNotEmpty).filter(string -> !"any".equals(string))).masqueradeEnabled(networkConf.isUidVpnMasqueradeEnabled()).serverPort(networkConf.getLocalPort()).publicGatewayPort(networkConf.getUidPublicGatewayPort()).dns(networkConf.getDhcpdDnsPrefixedList()).protocol(networkConf.getVpnProtocol().orElse(VpnNetworkProtocol.TCP)).isStrictClientCommonName(networkConf.isOpenvpnStrictClientCommonName()).uidWorkspaceUrl(networkConf.getUidWorkspaceUrl()).uidPolicyEnabled(networkConf.isUidPolicyEnabled()).uidPolicyName(networkConf.getUidPolicyName()).customRouting(networkConf.getUidVpnCustomRouting()).defaultDnsSuffix(networkConf.getUidVpnDefaultDnsSuffix()).syncPublicIp(networkConf.isUidVpnSyncPublicIp()).maxConnectionTimeSeconds(networkConf.getUidVpnMaxConnectionTime()).caCrt(networkConf.getOpenVpnAuthorityCertificate()).caKey(networkConf.getOpenVpnAuthorityKey()).serverCrt(networkConf.getOpenVpnServerCertificate()).serverKey(networkConf.getOpenVpnServerKey().orElse("")).authKey(networkConf.getOpenVpnAuthKey()).dhKey(networkConf.getOpenVpnDhKey()).renegotiationTimeout((Integer)networkConf.getOpenVpnTlsRenegotiationTimeout().orElse(null)).radius(immutableUidVpnServerRadiusConfigurationDto).build();
    }

    public NetworkConf toNetworkConf(String string) {
        NetworkConf networkConf = new NetworkConf();
        String string2 = this.getNetworkConfId();
        if (string2 != null) {
            networkConf.setId(string2);
        }
        UidVpnType uidVpnType = this.getVpnType();
        List<String> list = this.getDns();
        networkConf.setSiteId(string).setNoDelete(true).setPurpose(NetworkPurpose.REMOTE_USER_VPN).setVpnType(OoOO.\u00d5O0000).setUidVpnType(uidVpnType).setEnabled(this.isEnabled()).setName(this.getName()).setIpSubnet(this.getIpSubnet().orElse(null)).setLocalPort(this.getServerPort()).setExposedToSiteVpn(true).setDhcpdDnsEnabled(!list.isEmpty()).setUidVpnMasqueradeEnabled(this.masqueradeEnabled()).setUidPolicyEnabled(this.uidPolicyEnabled()).setUidVpnCustomRouting(this.customRouting()).setUidVpnSyncPublicIp(this.syncPublicIp());
        this.uidPolicyName().ifPresent(networkConf::setUidPolicyName);
        this.uidWorkspaceUrl().ifPresent(networkConf::setUidWorkspaceUrl);
        this.defaultDnsSuffix().ifPresent(networkConf::setUidVpnDefaultDnsSuffix);
        this.maxConnectionTimeSeconds().ifPresent(networkConf::setUidVpnMaxConnectionTime);
        this.publicGatewayPort().ifPresent(networkConf::setUidPublicGatewayPort);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            networkConf.put("dhcpd_dns_" + (i2 + 1), (Object)list.get(i2));
        }
        if (uidVpnType == UidVpnType.OPENVPN) {
            networkConf.setOpenVpnServerKey(this.getServerKey()).setIpV6Subnet(this.getIpv6Subnet().orElse("")).setOpenvpnStrictClientCommonName(this.isStrictClientCommonName()).setOpenVpnTlsRenegotiationTimeout(this.getRenegotiationTimeout().orElse(null)).setVpnProtocol((VpnNetworkProtocol)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.getProtocol()), (Object)((Object)VpnNetworkProtocol.TCP))));
            this.getLocalWanIp().ifPresent(networkConf::setOpenVpnLocalWanIp);
            this.getCaCrt().ifPresent(networkConf::setOpenVpnAuthorityCertificate);
            this.getServerCrt().ifPresent(networkConf::setOpenVpnServerCertificate);
            this.getAuthKey().ifPresent(networkConf::setOpenVpnAuthKey);
            this.getDhKey().ifPresent(networkConf::setOpenVpnDhKey);
            this.getCaKey().ifPresent(networkConf::setOpenVpnAuthorityKey);
        } else if (uidVpnType == UidVpnType.WIREGUARD) {
            this.getLocalWanIp().ifPresent(networkConf::setWireguardLocalWanIp);
            networkConf.setWireguardPrivateKey(this.getServerKey());
        }
        return networkConf;
    }

    public Optional<RadiusProfile> toRadiusProfile(RadiusProfile radiusProfile) {
        return this.getRadius().map(uidVpnServerRadiusConfigurationDto -> this.\u00f5\u00d4\u00d3000(radiusProfile, (UidVpnServerRadiusConfigurationDto)uidVpnServerRadiusConfigurationDto));
    }

    private RadiusProfile \u00f5\u00d4\u00d3000(RadiusProfile radiusProfile, UidVpnServerRadiusConfigurationDto uidVpnServerRadiusConfigurationDto) {
        RadiusProfile radiusProfile2 = new RadiusProfile();
        radiusProfile2.mergeFrom(radiusProfile);
        String string = uidVpnServerRadiusConfigurationDto.getIp();
        String string2 = uidVpnServerRadiusConfigurationDto.getSecret();
        int n3 = uidVpnServerRadiusConfigurationDto.getAuthPort();
        radiusProfile2.setAuthenticationServers(List.of(new X().append("ip", string).append("port", n3).append("x_secret", string2)));
        uidVpnServerRadiusConfigurationDto.getAcctPort().filter(n2 -> n2 > 0).ifPresent(n2 -> {
            radiusProfile2.setAccountingEnabled(true);
            radiusProfile2.setAccountingServers(List.of(new X().append("ip", string).append("port", n2).append("x_secret", string2)));
        });
        return radiusProfile2;
    }

    public static ImmutableUidVpnServerConfigurationDto.Builder builder() {
        return ImmutableUidVpnServerConfigurationDto.builder();
    }
}

