/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.device;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.model.L.O0oO;
import com.ubnt.model.L.for;
import com.ubnt.model.api.device.UpsDeviceDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;

public interface UnifiDeviceDto {
    @JsonProperty(value="_id")
    @Schema(name="Object Id")
    public Optional<String> id();

    @JsonProperty(value="mac")
    @Schema(name="MAC address")
    public String mac();

    @JsonProperty(value="state")
    @Schema(name="State", example="1")
    public int state();

    @JsonProperty(value="default")
    public boolean isDefault();

    @JsonProperty(value="name")
    @Schema(name="Device name")
    public String name();

    @JsonProperty(value="model")
    @Schema(name="Device model shortname")
    public String modelShortname();

    @JsonProperty(value="ip")
    @Schema(name="IP address")
    public Optional<String> ipAddress();

    @JsonProperty(value="satisfaction")
    @Schema(name="Experience", example="99")
    public Optional<Integer> experience();

    @JsonProperty(value="version")
    @Schema(name="Firmware version")
    public Optional<String> version();

    @JsonProperty(value="displayable_version")
    @Schema(name="Firmware version in user friendly form")
    public Optional<String> displayableVersion();

    @JsonProperty(value="usage_bytes")
    @Schema(name="24h usage in bytes per second")
    public Optional<Double> usageBytes();

    @JsonProperty(value="download_speed_bytes_per_second")
    @Schema(name="Download speed in bytes per second", example="1024")
    public Optional<Long> downloadSpeedBytesPerSecond();

    @JsonProperty(value="upload_speed_bytes_per_second")
    @Schema(name="Upload speed in bytes", example="512")
    public Optional<Long> uploadSpeedBytesPerSecond();

    @JsonProperty(value="uptime")
    @Schema(name="Uptime in seconds", example="120")
    public Optional<Long> uptimeSeconds();

    @JsonProperty(value="device_type")
    @Schema(description="Information whether the device is considered a client or device from the NET point of view")
    public for unifiDeviceType();

    @JsonProperty(value="product_line")
    @Schema(name="Controller that could manage this device")
    public O0oO productLine();

    @JsonProperty(value="last_seen")
    @Schema(description="Information about when the device was seen for the last time in unix timestamp in seconds")
    public Optional<Long> lastSeenTimestampSeconds();

    @JsonProperty(value="connection_network_id")
    @Schema(name="Network id where the device is connected to")
    public Optional<String> connectionNetworkId();

    @JsonProperty(value="connection_network_name")
    @Schema(name="Network name where the device is connected to")
    public Optional<String> connectionNetworkName();

    @JsonProperty(value="ipv4_lease_expiration_timestamp_seconds")
    @Schema(name="Device ip v4 lease expiration timestamp in seconds")
    public Optional<Long> ipv4ActiveLeaseExpirationTimestampSeconds();

    @JsonProperty(value="last_connection_network_id")
    public Optional<String> lastConnectionNetworkId();

    @JsonProperty(value="last_connection_network_name")
    public Optional<String> lastConnectionNetworkName();

    @JsonProperty(value="stacking_group_id")
    @Schema(name="Stacking group that the device belongs to")
    public Optional<String> stackingGroupId();

    @JsonProperty(value="ups_device")
    @Schema(name="Unifi device that has paired with an UPS device")
    public Optional<UpsDeviceDto> upsDevice();

    @JsonProperty(value="graceful_shutdown_triggered_at")
    @Schema(name="The timestamp of the Unifi device that has been shutdown by an UPS device")
    public Optional<Long> gracefulShutdownTriggeredByPairedUpsAt();
}

