/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.annotation;

import com.networknt.schema.SchemaLocation;
import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.path.NodePath;
import java.util.function.Predicate;

public class AnnotationPredicate
implements Predicate<Annotation> {
    final Predicate<NodePath> instanceLocationPredicate;
    final Predicate<NodePath> evaluationPathPredicate;
    final Predicate<SchemaLocation> schemaLocationPredicate;
    final Predicate<String> keywordPredicate;
    final Predicate<Object> valuePredicate;

    protected AnnotationPredicate(Predicate<NodePath> instanceLocationPredicate, Predicate<NodePath> evaluationPathPredicate, Predicate<SchemaLocation> schemaLocationPredicate, Predicate<String> keywordPredicate, Predicate<Object> valuePredicate) {
        this.instanceLocationPredicate = instanceLocationPredicate;
        this.evaluationPathPredicate = evaluationPathPredicate;
        this.schemaLocationPredicate = schemaLocationPredicate;
        this.keywordPredicate = keywordPredicate;
        this.valuePredicate = valuePredicate;
    }

    @Override
    public boolean test(Annotation t) {
        return !(this.valuePredicate != null && !this.valuePredicate.test(t.getValue()) || this.keywordPredicate != null && !this.keywordPredicate.test(t.getKeyword()) || this.instanceLocationPredicate != null && !this.instanceLocationPredicate.test(t.getInstanceLocation()) || this.evaluationPathPredicate != null && !this.evaluationPathPredicate.test(t.getEvaluationPath()) || this.schemaLocationPredicate != null && !this.schemaLocationPredicate.test(t.getSchemaLocation()));
    }

    public Predicate<NodePath> getInstanceLocationPredicate() {
        return this.instanceLocationPredicate;
    }

    public Predicate<NodePath> getEvaluationPathPredicate() {
        return this.evaluationPathPredicate;
    }

    public Predicate<SchemaLocation> getSchemaLocationPredicate() {
        return this.schemaLocationPredicate;
    }

    public Predicate<String> getKeywordPredicate() {
        return this.keywordPredicate;
    }

    public Predicate<Object> getValuePredicate() {
        return this.valuePredicate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        Predicate<NodePath> instanceLocationPredicate;
        Predicate<NodePath> evaluationPathPredicate;
        Predicate<SchemaLocation> schemaLocationPredicate;
        Predicate<String> keywordPredicate;
        Predicate<Object> valuePredicate;

        public Builder instanceLocation(Predicate<NodePath> instanceLocationPredicate) {
            this.instanceLocationPredicate = instanceLocationPredicate;
            return this;
        }

        public Builder evaluationPath(Predicate<NodePath> evaluationPathPredicate) {
            this.evaluationPathPredicate = evaluationPathPredicate;
            return this;
        }

        public Builder schema(Predicate<SchemaLocation> schemaLocationPredicate) {
            this.schemaLocationPredicate = schemaLocationPredicate;
            return this;
        }

        public Builder keyword(Predicate<String> keywordPredicate) {
            this.keywordPredicate = keywordPredicate;
            return this;
        }

        public Builder value(Predicate<Object> valuePredicate) {
            this.valuePredicate = valuePredicate;
            return this;
        }

        public AnnotationPredicate build() {
            return new AnnotationPredicate(this.instanceLocationPredicate, this.evaluationPathPredicate, this.schemaLocationPredicate, this.keywordPredicate, this.valuePredicate);
        }
    }
}

