---
name: Bug report
about: Create a bug report to help us improve Terragrunt.
title: ''
labels: bug
assignees: ''

---

## Describe the bug

A clear and concise description of what the bug is.

## Reproducing bugs

It is vital when reporting bugs that you provide the exact steps that _anyone_ would be able to follow to reproduce the bug you are seeing.

Without this information, it is much less likely that maintainers will invest time in investigating and fixing the bug, and maintainers may not know if they have actually fixed the bug once a fix is made.

The exceptions to requiring steps to reproduce are:

1. You are reporting a bug that you don't know how to reproduce, but you are reporting it so that others in the community are aware of it.
2. You are willing to fix the bug yourself, and you accept the responsibility of ensuring that the bug is valid, and that the fix is well tested.

How to provide steps for reproduction:

The most common way to provide steps for reproduction is to create a minimal example that reproduces the bug, and steps to run that example to reproduce the issue. Maintainers will refer to this example as a "fixture" when asking questions about reproduction.

You can either do so with code snippets in this issue, or by creating a public Git repository that contains the minimal example, with instructions for running the example.

You can delete this section right before submitting the issue, if you like.

## Steps To Reproduce

Steps to reproduce the behavior, code snippets and examples which can be used to reproduce the issue.

Be sure that the maintainers can actually reproduce the issue. Bug reports that are too vague or hard to reproduce are hard to troubleshoot and fix.

```hcl
// paste code snippets here
```

## Expected behavior

A clear and concise description of what you expected to happen.

## Must haves

- [ ] Steps for reproduction provided.

## Nice to haves

- [ ] Terminal output
- [ ] Screenshots

## Versions

- Terragrunt version:
- OpenTofu/Terraform version:
- Environment details (Ubuntu 20.04, Windows 10, etc.):

## Additional context

Add any other context about the problem here.
