/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs3.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.DiscoveredService;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryReceiver;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoverySender;
import org.apache.commons.jcs3.utils.discovery.behavior.IDiscoveryListener;
import org.apache.commons.jcs3.utils.net.HostNameUtil;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class UDPDiscoveryService
implements IShutdownObserver,
IRequireScheduler {
    private static final Log log = LogManager.getLog(UDPDiscoveryService.class);
    private Thread udpReceiverThread;
    private UDPDiscoveryReceiver receiver;
    private UDPDiscoveryAttributes udpDiscoveryAttributes;
    private final IElementSerializer serializer;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final ConcurrentMap<Integer, DiscoveredService> discoveredServices = new ConcurrentHashMap<Integer, DiscoveredService>();
    private final Set<String> cacheNames = new CopyOnWriteArraySet<String>();
    private final Set<IDiscoveryListener> discoveryListeners = new CopyOnWriteArraySet<IDiscoveryListener>();
    private ScheduledFuture<?> broadcastTaskFuture;
    private ScheduledFuture<?> cleanupTaskFuture;

    @Deprecated
    public UDPDiscoveryService(UDPDiscoveryAttributes attributes) {
        this(attributes, new StandardSerializer());
    }

    public UDPDiscoveryService(UDPDiscoveryAttributes attributes, IElementSerializer serializer) {
        this.udpDiscoveryAttributes = attributes.clone();
        this.serializer = serializer;
        try {
            InetAddress multicastAddress = InetAddress.getByName(this.getUdpDiscoveryAttributes().getUdpDiscoveryAddr());
            if (this.getUdpDiscoveryAttributes().getServiceAddress() == null || this.getUdpDiscoveryAttributes().getServiceAddress().isEmpty()) {
                NetworkInterface serviceInterface = null;
                serviceInterface = this.getUdpDiscoveryAttributes().getUdpDiscoveryInterface() != null ? NetworkInterface.getByName(this.getUdpDiscoveryAttributes().getUdpDiscoveryInterface()) : HostNameUtil.getMulticastNetworkInterface();
                try {
                    InetAddress serviceAddress = null;
                    Enumeration<InetAddress> addresses = serviceInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        serviceAddress = addresses.nextElement();
                        if (!(multicastAddress instanceof Inet6Address ? serviceAddress instanceof Inet6Address && !serviceAddress.isLoopbackAddress() && !serviceAddress.isMulticastAddress() && serviceAddress.isLinkLocalAddress() : serviceAddress instanceof Inet4Address && !serviceAddress.isLoopbackAddress() && !serviceAddress.isMulticastAddress() && serviceAddress.isSiteLocalAddress())) continue;
                    }
                    if (serviceAddress == null) {
                        serviceAddress = HostNameUtil.getLocalHostLANAddress();
                    }
                    this.getUdpDiscoveryAttributes().setServiceAddress(serviceAddress.getHostAddress());
                }
                catch (UnknownHostException e) {
                    log.error("Couldn't get local host address", e);
                }
            }
            this.receiver = new UDPDiscoveryReceiver(this, this.getUdpDiscoveryAttributes().getUdpDiscoveryInterface(), multicastAddress, this.getUdpDiscoveryAttributes().getUdpDiscoveryPort());
        }
        catch (IOException e) {
            log.error("Problem creating UDPDiscoveryReceiver, address [{0}] port [{1}] we won't be able to find any other caches", this.getUdpDiscoveryAttributes().getUdpDiscoveryAddr(), this.getUdpDiscoveryAttributes().getUdpDiscoveryPort(), e);
        }
        this.initiateBroadcast();
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutor) {
        this.broadcastTaskFuture = scheduledExecutor.scheduleAtFixedRate(this::serviceRequestBroadcast, 0L, 15L, TimeUnit.SECONDS);
        this.cleanupTaskFuture = scheduledExecutor.scheduleAtFixedRate(this::cleanup, 0L, this.getUdpDiscoveryAttributes().getMaxIdleTimeSec(), TimeUnit.SECONDS);
    }

    protected void cleanup() {
        long now = System.currentTimeMillis();
        this.getDiscoveredServices().stream().filter(service -> {
            if (now - service.getLastHearFromTime() > (long)(this.getUdpDiscoveryAttributes().getMaxIdleTimeSec() * 1000)) {
                log.info("Removing service, since we haven't heard from it in {0} seconds. service = {1}", this.getUdpDiscoveryAttributes().getMaxIdleTimeSec(), service);
                return true;
            }
            return false;
        }).forEach(this::removeDiscoveredService);
    }

    public void initiateBroadcast() {
        log.debug("Creating sender for discoveryAddress = [{0}] and discoveryPort = [{1}] myHostName = [{2}] and port = [{3}]", () -> this.getUdpDiscoveryAttributes().getUdpDiscoveryAddr(), () -> this.getUdpDiscoveryAttributes().getUdpDiscoveryPort(), () -> this.getUdpDiscoveryAttributes().getServiceAddress(), () -> this.getUdpDiscoveryAttributes().getServicePort());
        try (UDPDiscoverySender sender = new UDPDiscoverySender(this.getUdpDiscoveryAttributes(), this.getSerializer());){
            sender.requestBroadcast();
            log.debug("Sent a request broadcast to the group");
        }
        catch (IOException e) {
            log.error("Problem sending a Request Broadcast", e);
        }
    }

    protected void serviceRequestBroadcast() {
        try (UDPDiscoverySender sender = new UDPDiscoverySender(this.getUdpDiscoveryAttributes(), this.getSerializer());){
            sender.passiveBroadcast(this.getUdpDiscoveryAttributes().getServiceAddress(), this.getUdpDiscoveryAttributes().getServicePort(), this.getCacheNames());
            log.debug("Called sender to issue a passive broadcast");
        }
        catch (IOException e) {
            log.error("Problem calling the UDP Discovery Sender, address [{0}] port [{1}]", this.getUdpDiscoveryAttributes().getUdpDiscoveryAddr(), this.getUdpDiscoveryAttributes().getUdpDiscoveryPort(), e);
        }
    }

    protected void shutdownBroadcast() {
        try (UDPDiscoverySender sender = new UDPDiscoverySender(this.getUdpDiscoveryAttributes(), this.getSerializer());){
            sender.removeBroadcast(this.getUdpDiscoveryAttributes().getServiceAddress(), this.getUdpDiscoveryAttributes().getServicePort(), this.getCacheNames());
            log.debug("Called sender to issue a remove broadcast in shutdown.");
        }
        catch (IOException e) {
            log.error("Problem calling the UDP Discovery Sender", e);
        }
    }

    public void addParticipatingCacheName(String cacheName) {
        this.cacheNames.add(cacheName);
    }

    public void removeDiscoveredService(DiscoveredService service) {
        if (this.discoveredServices.remove(service.hashCode()) != null) {
            log.info("Removing {0}", service);
        }
        this.getDiscoveryListeners().forEach(listener -> listener.removeDiscoveredService(service));
    }

    protected void addOrUpdateService(DiscoveredService discoveredService) {
        this.discoveredServices.merge(discoveredService.hashCode(), discoveredService, (oldService, newService) -> {
            log.debug("Set contains service.");
            log.debug("Updating service in the set {0}", newService);
            if (!oldService.getCacheNames().equals(newService.getCacheNames())) {
                log.info("List of cache names changed for service: {0}", newService);
                return newService;
            }
            if (oldService.getLastHearFromTime() != newService.getLastHearFromTime()) {
                return newService;
            }
            return oldService;
        });
        this.getDiscoveryListeners().forEach(listener -> listener.addDiscoveredService(discoveredService));
    }

    protected ArrayList<String> getCacheNames() {
        return new ArrayList<String>(this.cacheNames);
    }

    public void setUdpDiscoveryAttributes(UDPDiscoveryAttributes attr) {
        this.udpDiscoveryAttributes = attr;
    }

    public UDPDiscoveryAttributes getUdpDiscoveryAttributes() {
        return this.udpDiscoveryAttributes;
    }

    public IElementSerializer getSerializer() {
        return this.serializer;
    }

    public void startup() {
        this.udpReceiverThread = new Thread(this.receiver);
        this.udpReceiverThread.setDaemon(true);
        this.udpReceiverThread.start();
    }

    @Override
    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            if (this.broadcastTaskFuture != null) {
                this.broadcastTaskFuture.cancel(false);
            }
            if (this.cleanupTaskFuture != null) {
                this.cleanupTaskFuture.cancel(false);
            }
            if (this.receiver != null) {
                log.info("Shutting down UDP discovery service receiver.");
                this.receiver.shutdown();
            }
            log.info("Shutting down UDP discovery service sender.");
            this.shutdownBroadcast();
        } else {
            log.debug("Shutdown already called.");
        }
    }

    public Set<DiscoveredService> getDiscoveredServices() {
        return new HashSet<DiscoveredService>(this.discoveredServices.values());
    }

    private Set<IDiscoveryListener> getDiscoveryListeners() {
        return this.discoveryListeners;
    }

    public Set<IDiscoveryListener> getCopyOfDiscoveryListeners() {
        return new HashSet<IDiscoveryListener>(this.getDiscoveryListeners());
    }

    public boolean addDiscoveryListener(IDiscoveryListener listener) {
        return this.getDiscoveryListeners().add(listener);
    }

    public boolean removeDiscoveryListener(IDiscoveryListener listener) {
        return this.getDiscoveryListeners().remove(listener);
    }
}

