// Copyright 2026 The Hugo Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package predicate

import (
	"testing"

	qt "github.com/frankban/quicktest"
)

func TestCutRangeOp(t *testing.T) {
	c := qt.New(t)

	op, rest := cutRangeOp(">= value")
	c.Assert(op, qt.Equals, rangeOpGTE)
	c.Assert(rest, qt.Equals, "value")

	op, rest = cutRangeOp("<= value")
	c.Assert(op, qt.Equals, rangeOpLTE)
	c.Assert(rest, qt.Equals, "value")

	op, rest = cutRangeOp("> value")
	c.Assert(op, qt.Equals, rangeOpGT)
	c.Assert(rest, qt.Equals, "value")

	op, rest = cutRangeOp("< value")
	c.Assert(op, qt.Equals, rangeOpLT)
	c.Assert(rest, qt.Equals, "value")

	op, rest = cutRangeOp("== value")
	c.Assert(op, qt.Equals, rangeOpEQ)
	c.Assert(rest, qt.Equals, "value")

	op, rest = cutRangeOp("!= value")
	c.Assert(op, qt.Equals, rangeOpNE)
	c.Assert(rest, qt.Equals, "value")

	op, rest = cutRangeOp("value")
	c.Assert(op, qt.Equals, rangeOpNone)
	c.Assert(rest, qt.Equals, "value")
}
