---
date: 2025-11-30
slug: goreleaser-v2.13
categories: [announcements]
authors: [caarlos0]
---

# Announcing GoReleaser v2.13

Happy thanksgiving - GoReleaser v2.13 is here!

<!-- more -->

## GitHub Universe and GoLab Firenze

If you attended these events, you might have gotten yourself some GoReleaser
stickers!

We also had a booth on GitHub Universe day 1!

![The GoReleaser booth](https://carlosbecker.com/posts/goreleaser-v2.13/booth.png)

I don't usually do this kind of thing, but it was pretty fun!
Thanks to everyone that passed by to chat, and thanks specially to Abby and Lee
from GitHub for inviting me!

## All about MCP

Big news here!

First, GoReleaser now supports publishing MCPs to the
[Model Context Protocol Registry](https://github.com/modelcontextprotocol/registry)!

See this example:

```yaml title=".goreleaser.yaml"
mcp:
  name: "io.github.goreleaser/mcp"
  title: "The MCP server for GoReleaser"
  repository:
    source: "github"
    url: "https://github.com/goreleaser/mcp"
  auth:
    type: "github-oidc"
  packages:
    - registry_type: oci
      identifier: "ghcr.io/goreleaser/mcp:{{ .Version }}"
      transport:
        type: stdio
    - registry_type: npm
      identifier: "@goreleaser/mcp"
      transport:
        type: stdio
```

So, [GoReleaser MCP is published in the MCP Registry](https://github.com/mcp/goreleaser/mcp)!

And the second news is that the GoReleaser MCP now has its own repository.
This should allow us to evolve it faster, and also, if you only want the MCP,
the binary is much smaller.

One good use case for our MCP is that it provides a ready to use prompt + tools
to update your configuration, fixing deprecated options.

Here's how it looks like on [Charm's Crush](https://charm.land/crush):

![Choosing the prompt](https://carlosbecker.com/posts/goreleaser-v2.13/crush1.png)
![Running it](https://carlosbecker.com/posts/goreleaser-v2.13/crush2.png)

There's also a prompt to fix all the issues with
[Cosign v3](https://goreleaser.com/blog/cosign-v3/).

Make sure to give it a try!

Relevant links:

- [Documentation](https://goreleaser.com/customization/mcp)
- [GoReleaser MCP](https://goreleaser.com/mcp)

## GoReleaser Pro

For Pro users, the NPM feature got some improvements: you can now set the NPM
tag (instead of defaulting to latest), so you may have
`npm install yourthing@beta`, for example.
You can also set extra fields into the `package.json`, which is specially
relevant for the aforementioned MCP feature.

Example:

```yaml title=".goreleaser.yaml"
npms:
  - name: "@foo/bar"
    extra:
      mcpName: "io.github.foo/bar"
```

[NPM documentation](https://goreleaser.com/customization/npm).

Finally, you can use the fields from the [global metadata](https://goreleaser.com/customization/metadata)
in your templates, e.g.:

```yaml title=".goreleaser.yaml"
metadata:
  description: Foo bar zaz
dockers_v2:
  - images:
      - "ghcr.io/foo/bar"
    labels:
      "org.opencontainers.image.description": "{{.Metadata.Description}}"
```

## Dockers v2

We continue investing in the
[dockers_v2](https://goreleaser.com/customization/dockers_v2) feature, and since
v2.13.0 we made **a lot** of improvements:

1. allow `linux/arm/v5`
1. allow to disable SBOMs
1. allow to template the `sbom` field
1. allow to disable a configuration
1. properly handle `--split` (on Pro)
1. respect `monorepo.dir` (on Pro)
1. properly set manifest annotations
1. properly support PyWheel
1. improve error handling
1. warning if buildx driver is unknown/unsupported
1. check buildx driver on `goreleaser healthcheck`

## Other highlights

- **aur**: [AUR](https://goreleaser.com/customization/aur) will now use `${pkgver}` in the URLs to generate smaller diffs
- **aur**: allows pre-release versions
- **announce**: [Discourse announcer](https://goreleaser.com/customization/announce/discourse/)
- **homebrew_casks**: Allow to template `'hooks`
- **signs** and **docker_signs**: allow to template `output`
- **homebrew_casks**: set more than one binary
- **ko**: [Ko](https://goreleaser.com/customization/ko) can now use a local base image
- **sbom**: make `--enrich=all` a default flag
- **makeself**: properly handle binary and script names
- **npm**: properly handle HTTP/HTTPS proxies
- **npm**: properly handle `run.js` exit codes
- **announce**: fix user agent
- **jsonschema**: properly mark fields deprecated
- **builds/go**: only add `.h` file if it exists
- **github**: better handle GitHub enterprise URLs

## Other news

- GoReleaser now has ~15.3k stars and 450 contributors! Thanks, everyone!
- We often discuss new features in our Discord server. 
  [Join the conversation][discord]!
- nFPM had new releases as well, 
  [check it out](https://github.com/goreleaser/nfpm/releases).
- The GoReleaser Action had a new release,
  [check it out](https://github.com/goreleaser/goreleaser-action/releases)

## Download

You can install or upgrade using your favorite package manager, or see the
full release notes and download the pre-compiled binaries from GitHub:

[:fontawesome-solid-download: Install][install]{ .md-button .md-button--primary }
[:fontawesome-brands-github: v2.13.0 (OSS)][oss-rel]{ .md-button }
[:fontawesome-brands-github: v2.13.0 (Pro)][pro-rel]{ .md-button }

## Helping out

You can help by reporting issues, contributing features, documentation
improvements, and bug fixes.
You can also sponsor the project, or get a GoReleaser Pro license.

[:material-professional-hexagon: Get the Pro license][pro]{ .md-button .md-button--primary }
[:simple-githubsponsors: Sponsor the project][sponsor]{ .md-button }

[sponsor]: https://goreleaser.com/sponsors
[pro]: https://goreleaser.com/pro
[install]: https://goreleaser.com/install
[pro-rel]: https://github.com/goreleaser/goreleaser-pro/releases/tag/v2.13.0
[oss-rel]: https://github.com/goreleaser/goreleaser/releases/tag/v2.13.0
[discord]: https://goreleaser.com/discord
