---
date: 2025-11-05
slug: cosign-v3
categories:
  - tutorials
authors:
  - caarlos0
---

# Upgrading to Cosign v3

Cosign v3 streamlined its signing workflow by introducing the `--bundle` flag,
replacing the previous approach that required separate certificate and signature
files.

<!-- more -->

## What Changed

Previously, signing artifacts with cosign required managing two separate outputs:

- A `.pem` certificate file via `--output-certificate`
- A `.sig` signature file via `--output-signature`

Now, the `--bundle` flag combines both into a single `.sigstore.json` file,
simplifying both signing and verification workflows.

## Updating Your GoReleaser Configuration

Here's how to update your `.goreleaser.yaml`:

```diff
# https://goreleaser.com/customization/sign
signs:
  - cmd: cosign
-   certificate: "${artifact}.pem"
+   signature: "${artifact}.sigstore.json"
    args:
      - sign-blob
-     - "--output-certificate=${certificate}"
-     - "--output-signature=${signature}"
+     - "--bundle=${signature}"
      - "${artifact}"
      - "--yes"
    artifacts: checksum
```

The key changes:

1. Remove the `certificate` field
2. Update `signature` to use `.sigstore.json` extension
3. Replace `--output-certificate` and `--output-signature` flags with a single
   `--bundle` flag

## Verifying Signatures

Verification is now simpler too. Instead of:

```bash
cosign verify-blob \
  --certificate artifact.pem \
  --signature artifact.sig \
  artifact
```

You now just need:

```bash
cosign verify-blob \
  --bundle artifact.sigstore.json \
  artifact
```

## Try It Out

Check out the complete working example at
[github.com/goreleaser/example-secure](https://github.com/goreleaser/example-secure)
to see the new bundle-based signing in action.

This change reduces complexity and makes artifact signing more straightforward
for everyone.

For more details, see
[goreleaser/goreleaser#6195](https://github.com/goreleaser/goreleaser/issues/6195).
