// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigSummaryDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigSummaryDataPoint()
				CopyOrigSummaryDataPoint(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigSummaryDataPoint(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigSummaryDataPointUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigSummaryDataPoint()
	UnmarshalJSONOrigSummaryDataPoint(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigSummaryDataPoint(), dest)
}

func TestMarshalAndUnmarshalJSONOrigSummaryDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigSummaryDataPoint(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigSummaryDataPoint()
				UnmarshalJSONOrigSummaryDataPoint(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigSummaryDataPoint(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigSummaryDataPointFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesSummaryDataPoint() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigSummaryDataPoint()
			require.Error(t, UnmarshalProtoOrigSummaryDataPoint(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigSummaryDataPointUnknown(t *testing.T) {
	dest := NewOrigSummaryDataPoint()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigSummaryDataPoint(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigSummaryDataPoint(), dest)
}

func TestMarshalAndUnmarshalProtoOrigSummaryDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigSummaryDataPoint(src))
				gotSize := MarshalProtoOrigSummaryDataPoint(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigSummaryDataPoint()
				require.NoError(t, UnmarshalProtoOrigSummaryDataPoint(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigSummaryDataPoint(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufSummaryDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPoint() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigSummaryDataPoint(src))
			gotSize := MarshalProtoOrigSummaryDataPoint(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.SummaryDataPoint{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigSummaryDataPoint()
			require.NoError(t, UnmarshalProtoOrigSummaryDataPoint(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesSummaryDataPoint() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                     {0x02},
		"Attributes/wrong_wire_type":        {0x3c},
		"Attributes/missing_value":          {0x3a},
		"StartTimeUnixNano/wrong_wire_type": {0x14},
		"StartTimeUnixNano/missing_value":   {0x11},
		"TimeUnixNano/wrong_wire_type":      {0x1c},
		"TimeUnixNano/missing_value":        {0x19},
		"Count/wrong_wire_type":             {0x24},
		"Count/missing_value":               {0x21},
		"Sum/wrong_wire_type":               {0x2c},
		"Sum/missing_value":                 {0x29},
		"QuantileValues/wrong_wire_type":    {0x34},
		"QuantileValues/missing_value":      {0x32},
		"Flags/wrong_wire_type":             {0x44},
		"Flags/missing_value":               {0x40},
	}
}

func genTestEncodingValuesSummaryDataPoint() map[string]*otlpmetrics.SummaryDataPoint {
	return map[string]*otlpmetrics.SummaryDataPoint{
		"empty":                           NewOrigSummaryDataPoint(),
		"Attributes/default_and_test":     {Attributes: []otlpcommon.KeyValue{{}, *GenTestOrigKeyValue()}},
		"StartTimeUnixNano/test":          {StartTimeUnixNano: uint64(13)},
		"TimeUnixNano/test":               {TimeUnixNano: uint64(13)},
		"Count/test":                      {Count: uint64(13)},
		"Sum/test":                        {Sum: float64(3.1415926)},
		"QuantileValues/default_and_test": {QuantileValues: []*otlpmetrics.SummaryDataPoint_ValueAtQuantile{{}, GenTestOrigSummaryDataPoint_ValueAtQuantile()}},
		"Flags/test":                      {Flags: uint32(13)},
	}
}
