// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
)

func TestCopyOrigScopeSpansSlice(t *testing.T) {
	src := []*otlptrace.ScopeSpans{}
	dest := []*otlptrace.ScopeSpans{}
	// Test CopyTo empty
	dest = CopyOrigScopeSpansSlice(dest, src)
	assert.Equal(t, []*otlptrace.ScopeSpans{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestScopeSpansSlice()
	dest = CopyOrigScopeSpansSlice(dest, src)
	assert.Equal(t, GenerateOrigTestScopeSpansSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigScopeSpansSlice(dest, src)
	assert.Equal(t, GenerateOrigTestScopeSpansSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigScopeSpansSlice(dest, []*otlptrace.ScopeSpans{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigScopeSpansSlice(dest, src)
	assert.Equal(t, GenerateOrigTestScopeSpansSlice(), dest)
}
