// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestCopyOrigSampleSlice(t *testing.T) {
	src := []*otlpprofiles.Sample{}
	dest := []*otlpprofiles.Sample{}
	// Test CopyTo empty
	dest = CopyOrigSampleSlice(dest, src)
	assert.Equal(t, []*otlpprofiles.Sample{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestSampleSlice()
	dest = CopyOrigSampleSlice(dest, src)
	assert.Equal(t, GenerateOrigTestSampleSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigSampleSlice(dest, src)
	assert.Equal(t, GenerateOrigTestSampleSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigSampleSlice(dest, []*otlpprofiles.Sample{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigSampleSlice(dest, src)
	assert.Equal(t, GenerateOrigTestSampleSlice(), dest)
}
