// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectortrace "go.opentelemetry.io/proto/slim/otlp/collector/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcollectortrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportTraceServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigExportTraceServiceResponse()
				CopyOrigExportTraceServiceResponse(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigExportTraceServiceResponse(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigExportTraceServiceResponseUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigExportTraceServiceResponse()
	UnmarshalJSONOrigExportTraceServiceResponse(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigExportTraceServiceResponse(), dest)
}

func TestMarshalAndUnmarshalJSONOrigExportTraceServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigExportTraceServiceResponse(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigExportTraceServiceResponse()
				UnmarshalJSONOrigExportTraceServiceResponse(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigExportTraceServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigExportTraceServiceResponseFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportTraceServiceResponse() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigExportTraceServiceResponse()
			require.Error(t, UnmarshalProtoOrigExportTraceServiceResponse(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportTraceServiceResponseUnknown(t *testing.T) {
	dest := NewOrigExportTraceServiceResponse()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigExportTraceServiceResponse(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigExportTraceServiceResponse(), dest)
}

func TestMarshalAndUnmarshalProtoOrigExportTraceServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigExportTraceServiceResponse(src))
				gotSize := MarshalProtoOrigExportTraceServiceResponse(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigExportTraceServiceResponse()
				require.NoError(t, UnmarshalProtoOrigExportTraceServiceResponse(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigExportTraceServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportTraceServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceResponse() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportTraceServiceResponse(src))
			gotSize := MarshalProtoOrigExportTraceServiceResponse(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectortrace.ExportTraceServiceResponse{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigExportTraceServiceResponse()
			require.NoError(t, UnmarshalProtoOrigExportTraceServiceResponse(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportTraceServiceResponse() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"PartialSuccess/wrong_wire_type": {0xc},
		"PartialSuccess/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportTraceServiceResponse() map[string]*otlpcollectortrace.ExportTraceServiceResponse {
	return map[string]*otlpcollectortrace.ExportTraceServiceResponse{
		"empty":               NewOrigExportTraceServiceResponse(),
		"PartialSuccess/test": {PartialSuccess: *GenTestOrigExportTracePartialSuccess()},
	}
}
